/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.adapters.spatial.geo;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.stem.definitions.Activator;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongDataProvider;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class PlatformLatLongDataProvider
implements LatLongDataProvider {
    public static final String SAX_PARSER1 = "org.apache.xerces.parsers.SAXParser";
    public static final String SAX_PARSER2 = "org.apache.crimson.parser.XMLReaderImpl";
    static Map<URI, Map<String, LatLong>> cache = new ConcurrentHashMap<URI, Map<String, LatLong>>();
    public static final String PLATFORM_SCHEME = "platform";
    private static final CharSequence NORMAL_RES_FOLDER = "country";
    private static final CharSequence LOW_RES_FOLDER = "country_reduced";
    public boolean isSampling = false;
    public int sampleFrequency = 1;
    public boolean reportIOExceptions = true;
    public boolean useLowerResolutionLatLongData = false;

    public PlatformLatLongDataProvider() {
        this.setPreferences();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                PlatformLatLongDataProvider.this.setPreferences();
                cache = new ConcurrentHashMap<URI, Map<String, LatLong>>();
            }
        });
    }

    public static void flush() {
        cache = new ConcurrentHashMap<URI, Map<String, LatLong>>();
    }

    @Override
    public LatLong getLatLong(URI latlongFileURI) {
        LatLong retValue = null;
        retValue = this.getLatLongMap(latlongFileURI.trimFragment()).get(latlongFileURI.fragment());
        return retValue;
    }

    @Override
    public LatLong getLatLongNoWait(URI latlongFileURI) {
        LatLong retValue = null;
        retValue = this.getLatLongMapNoWait(latlongFileURI.trimFragment()).get(latlongFileURI.fragment());
        retValue = retValue != null ? retValue : new LatLong();
        return retValue;
    }

    public Set<String> getIds(URI fileURI) {
        return this.getLatLongMap(fileURI).keySet();
    }

    public Set<String> getIdsNoWait(URI fileURI) {
        return this.getLatLongMapNoWait(fileURI).keySet();
    }

    private Map<String, LatLong> getLatLongMap(URI fileURI) {
        Map<String, LatLong> latLongMap = cache.get(fileURI);
        if (latLongMap == null) {
            latLongMap = this.createLatLongMap(fileURI);
            cache.put(fileURI, latLongMap);
        }
        return latLongMap;
    }

    private synchronized Map<String, LatLong> getLatLongMapNoWait(final URI fileURI) {
        Map<String, LatLong> latLongMap = cache.get(fileURI);
        if (latLongMap == null) {
            latLongMap = new ConcurrentHashMap<String, LatLong>();
            cache.put(fileURI, latLongMap);
            Job readGMLJob = new Job(fileURI.toString()){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(fileURI.toString(), 100);
                    Map<String, LatLong> latLongMap = PlatformLatLongDataProvider.this.createLatLongMap(fileURI);
                    cache.put(fileURI, latLongMap);
                    monitor.done();
                    return new Status(0, "org.eclipse.stem.definitions", 0, "Done", null);
                }
            };
            readGMLJob.schedule();
        }
        return latLongMap;
    }

    Map<String, LatLong> createLatLongMap(URI fileURI) {
        ConcurrentHashMap<String, LatLong> latLongMap;
        block8: {
            latLongMap = new ConcurrentHashMap<String, LatLong>();
            URIConverterImpl converter = new URIConverterImpl();
            GMLDecoder gMLDecoder = new GMLDecoder(latLongMap);
            try {
                InputStream is = converter.createInputStream(this.adjustFilePath(fileURI));
                BufferedReader in = new BufferedReader(new InputStreamReader(is));
                PlatformLatLongDataProvider.parseInputStream(in, gMLDecoder);
            }
            catch (IOException e) {
                if (this.useLowerResolutionLatLongData) {
                    try {
                        InputStream is = converter.createInputStream(fileURI);
                        BufferedReader in = new BufferedReader(new InputStreamReader(is));
                        PlatformLatLongDataProvider.parseInputStream(in, gMLDecoder);
                    }
                    catch (FileNotFoundException fnfe) {
                        if (this.reportIOExceptions) {
                            Activator.logInformation(fnfe.getMessage(), fnfe);
                        }
                        break block8;
                    }
                    catch (IOException e2) {
                        if (this.reportIOExceptions) {
                            Activator.logError(e2.getMessage(), e2);
                        }
                        break block8;
                    }
                }
                if (!this.reportIOExceptions) break block8;
                Activator.logError(e.getMessage(), e);
            }
        }
        return latLongMap;
    }

    private URI adjustFilePath(URI fileURI) {
        URI retValue = fileURI;
        if (this.useLowerResolutionLatLongData) {
            String adjustedPath = fileURI.toString().replace(NORMAL_RES_FOLDER, LOW_RES_FOLDER);
            retValue = URI.createURI((String)adjustedPath);
        }
        return retValue;
    }

    private void setPreferences() {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        if (preferenceStore != null) {
            this.isSampling = preferenceStore.getBoolean("org.eclipse.stem.definitions.latlong.sample");
            this.sampleFrequency = preferenceStore.getInt("org.eclipse.stem.definitions.latlong.samplefrequency");
            this.reportIOExceptions = preferenceStore.getBoolean("org.eclipse.stem.definitions.latlong.ioreport");
            this.useLowerResolutionLatLongData = preferenceStore.getBoolean("org.eclipse.stem.definitions.latlong.lowresolution");
        }
    }

    public static XMLReader getSAXParser() {
        XMLReader retValue = null;
        try {
            retValue = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            try {
                retValue = XMLReaderFactory.createXMLReader(SAX_PARSER1);
            }
            catch (SAXException sAXException2) {
                try {
                    retValue = XMLReaderFactory.createXMLReader(SAX_PARSER2);
                }
                catch (SAXException saxe2) {
                    Activator.logError(saxe2.getMessage(), saxe2);
                }
            }
        }
        return retValue;
    }

    public static void parseInputStream(BufferedReader in, DefaultHandler handler) {
        try {
            XMLReader saxParser = PlatformLatLongDataProvider.getSAXParser();
            saxParser.setContentHandler(handler);
            saxParser.parse(new InputSource(in));
            in.close();
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
        }
        catch (SAXException e) {
            Activator.logError(e.getMessage(), e);
        }
    }

    public class GMLDecoder
    extends DefaultHandler {
        private static final String XML_MAP_ELEMENT_NAME = "Map";
        private static final String XML_TITLE_ELEMENT_NAME = "title";
        private static final String XML_SUBTITLE_ELEMENT_NAME = "subTitle";
        private static final String XML_UPDATED_ELEMENT_NAME = "updated";
        private static final String XML_ENTRY_ELEMENT_NAME = "entry";
        private static final String XML_WHERE_ELEMENT_NAME = "where";
        private static final String XML_OUTER_BOUNDARY_ELEMENT_NAME = "outerBoundaryIs";
        private static final String XML_LINEAR_RING_ELEMENT_NAME = "LinearRing";
        private static final String XML_POLYGON_ELEMENT_NAME = "Polygon";
        private static final String XML_POSLIST_ELEMENT_NAME = "posList";
        private static final String XML_ID_ATTR = "gml:id";
        private String title = "";
        private String currentPolygonId = null;
        private Locator locator = null;
        Map<String, LatLong> latLongMap = null;
        private LatLong polygonLatLong = null;
        private LatLong.SegmentBuilder segmentBuilder = null;
        private StringBuilder characterStringBuilder = new StringBuilder();

        protected GMLDecoder(Map<String, LatLong> latLongMap) {
            this.latLongMap = latLongMap;
        }

        @Override
        public void startElement(String namespace, String sName, String qName, Attributes attributes) throws SAXException {
            String elementName;
            String string = elementName = sName.equals("") ? qName : sName;
            if (elementName.equalsIgnoreCase(XML_MAP_ELEMENT_NAME)) {
                assert (this.latLongMap != null);
            } else if (elementName.equalsIgnoreCase(XML_TITLE_ELEMENT_NAME)) {
                this.characterStringBuilder = new StringBuilder();
            } else if (elementName.equalsIgnoreCase(XML_SUBTITLE_ELEMENT_NAME)) {
                this.characterStringBuilder = new StringBuilder();
            } else if (elementName.equalsIgnoreCase(XML_UPDATED_ELEMENT_NAME)) {
                this.characterStringBuilder = new StringBuilder();
            } else if (!(elementName.equalsIgnoreCase(XML_ENTRY_ELEMENT_NAME) || elementName.equalsIgnoreCase(XML_WHERE_ELEMENT_NAME) || elementName.equalsIgnoreCase(XML_OUTER_BOUNDARY_ELEMENT_NAME) || elementName.equalsIgnoreCase(XML_LINEAR_RING_ELEMENT_NAME))) {
                if (elementName.equalsIgnoreCase(XML_POLYGON_ELEMENT_NAME)) {
                    assert (this.currentPolygonId == null);
                    assert (this.polygonLatLong == null);
                    this.currentPolygonId = attributes.getValue(XML_ID_ATTR);
                    this.polygonLatLong = new LatLong();
                } else if (elementName.equalsIgnoreCase(XML_POSLIST_ELEMENT_NAME)) {
                    assert (this.segmentBuilder == null);
                    this.segmentBuilder = new LatLong.SegmentBuilder();
                    this.characterStringBuilder = new StringBuilder();
                } else {
                    throw new SAXParseException("Invalid element name \"" + elementName + "\"", this.locator);
                }
            }
        }

        @Override
        public void endElement(String namespace, String sName, String qName) throws SAXException {
            String elementName;
            String string = elementName = sName.equals("") ? qName : sName;
            if (elementName.equalsIgnoreCase(XML_MAP_ELEMENT_NAME)) {
                assert (this.latLongMap != null);
            } else if (elementName.equalsIgnoreCase(XML_TITLE_ELEMENT_NAME)) {
                this.title = this.characterStringBuilder.toString();
                this.characterStringBuilder = new StringBuilder();
            } else if (elementName.equalsIgnoreCase(XML_SUBTITLE_ELEMENT_NAME)) {
                this.characterStringBuilder = new StringBuilder();
            } else if (elementName.equalsIgnoreCase(XML_UPDATED_ELEMENT_NAME)) {
                this.characterStringBuilder = new StringBuilder();
            } else if (!(elementName.equalsIgnoreCase(XML_ENTRY_ELEMENT_NAME) || elementName.equalsIgnoreCase(XML_WHERE_ELEMENT_NAME) || elementName.equalsIgnoreCase(XML_OUTER_BOUNDARY_ELEMENT_NAME) || elementName.equalsIgnoreCase(XML_LINEAR_RING_ELEMENT_NAME))) {
                if (elementName.equalsIgnoreCase(XML_POLYGON_ELEMENT_NAME)) {
                    this.latLongMap.put(this.currentPolygonId, this.polygonLatLong);
                    this.currentPolygonId = null;
                    this.polygonLatLong = null;
                } else if (elementName.equalsIgnoreCase(XML_POSLIST_ELEMENT_NAME)) {
                    StringTokenizer st = new StringTokenizer(this.characterStringBuilder.toString(), " \n");
                    this.characterStringBuilder = new StringBuilder();
                    while (st.hasMoreTokens()) {
                        String value1 = st.nextToken();
                        if (st.hasMoreTokens()) {
                            String value2 = st.nextToken();
                            this.segmentBuilder.add(value1, value2);
                            continue;
                        }
                        Activator.logError("Latitude/Longitude data titled \"" + this.title + "\" is missing a longitude  match for the latitude value \"" + value1 + "\" at line: " + this.locator.getLineNumber() + ", column: " + this.locator.getColumnNumber(), null);
                        this.segmentBuilder.clear();
                        break;
                    }
                    if (this.segmentBuilder.size() > 0) {
                        try {
                            this.polygonLatLong.add(PlatformLatLongDataProvider.this.isSampling ? this.segmentBuilder.toSegment(PlatformLatLongDataProvider.this.sampleFrequency) : this.segmentBuilder.toSegment());
                        }
                        catch (IllegalArgumentException iae) {
                            Activator.logError("Problem processing Latitude/Longitude data titled \"" + this.title + "\"", iae);
                        }
                    }
                    this.segmentBuilder = null;
                } else {
                    throw new SAXParseException("Invalid element name \"" + elementName + "\"", this.locator);
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.characterStringBuilder.append(new String(ch, start, length));
        }

        @Override
        public void warning(SAXParseException spe) {
            Activator.logInformation(spe.getMessage(), spe);
        }

        @Override
        public void error(SAXParseException spe) {
            Activator.logError(spe.getMessage(), spe);
        }

        @Override
        public void fatalError(SAXParseException spe) {
            Activator.logError(spe.getMessage(), spe);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }
}

