/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRoot;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jdt.internal.junit.ui.CopyFailureListAction;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.OpenTestAction;
import org.eclipse.jdt.internal.junit.ui.RerunAction;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.internal.junit.ui.TestSessionLabelProvider;
import org.eclipse.jdt.internal.junit.ui.TestSessionTableContentProvider;
import org.eclipse.jdt.internal.junit.ui.TestSessionTreeContentProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.SelectionProviderMediator;
import org.eclipse.jdt.junit.model.ITestElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.PageBook;

public class TestViewer {
    private final FailuresOnlyFilter fFailuresOnlyFilter = new FailuresOnlyFilter();
    private final TestRunnerViewPart fTestRunnerPart;
    private final Clipboard fClipboard;
    private PageBook fViewerbook;
    private TreeViewer fTreeViewer;
    private TestSessionTreeContentProvider fTreeContentProvider;
    private TestSessionLabelProvider fTreeLabelProvider;
    private TableViewer fTableViewer;
    private TestSessionTableContentProvider fTableContentProvider;
    private TestSessionLabelProvider fTableLabelProvider;
    private SelectionProviderMediator fSelectionProvider;
    private int fLayoutMode;
    private boolean fTreeHasFilter;
    private boolean fTableHasFilter;
    private TestRunSession fTestRunSession;
    private boolean fTreeNeedsRefresh;
    private boolean fTableNeedsRefresh;
    private HashSet<TestElement> fNeedUpdate;
    private TestCaseElement fAutoScrollTarget;
    private LinkedList<TestSuiteElement> fAutoClose;
    private HashSet<TestSuiteElement> fAutoExpand;

    public TestViewer(Composite parent, Clipboard clipboard, TestRunnerViewPart runner) {
        this.fTestRunnerPart = runner;
        this.fClipboard = clipboard;
        this.fLayoutMode = 1;
        this.createTestViewers(parent);
        this.registerViewersRefresh();
        this.initContextMenu();
    }

    private void createTestViewers(Composite parent) {
        this.fViewerbook = new PageBook(parent, 0);
        this.fTreeViewer = new TreeViewer((Composite)this.fViewerbook, 516);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeContentProvider = new TestSessionTreeContentProvider();
        this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        this.fTreeLabelProvider = new TestSessionLabelProvider(this.fTestRunnerPart, 1);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new ColoringLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.fTreeLabelProvider));
        this.fTableViewer = new TableViewer((Composite)this.fViewerbook, 772);
        this.fTableViewer.setUseHashlookup(true);
        this.fTableContentProvider = new TestSessionTableContentProvider();
        this.fTableViewer.setContentProvider((IContentProvider)this.fTableContentProvider);
        this.fTableLabelProvider = new TestSessionLabelProvider(this.fTestRunnerPart, 0);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ColoringLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.fTableLabelProvider));
        this.fSelectionProvider = new SelectionProviderMediator(new StructuredViewer[]{this.fTreeViewer, this.fTableViewer}, (StructuredViewer)this.fTreeViewer);
        this.fSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)new TestSelectionListener());
        TestOpenListener testOpenListener = new TestOpenListener();
        this.fTreeViewer.getTree().addSelectionListener((SelectionListener)testOpenListener);
        this.fTableViewer.getTable().addSelectionListener((SelectionListener)testOpenListener);
        this.fTestRunnerPart.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProvider);
        this.fViewerbook.showPage((Control)this.fTreeViewer.getTree());
    }

    private void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TestViewer.this.handleMenuAboutToShow(manager);
            }
        });
        this.fTestRunnerPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fSelectionProvider);
        Menu menu = menuMgr.createContextMenu((Control)this.fViewerbook);
        this.fTreeViewer.getTree().setMenu(menu);
        this.fTableViewer.getTable().setMenu(menu);
    }

    void handleMenuAboutToShow(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.fSelectionProvider.getSelection();
        if (!selection.isEmpty()) {
            TestElement testElement = (TestElement)selection.getFirstElement();
            String testLabel = testElement.getTestName();
            String className = testElement.getClassName();
            if (testElement instanceof TestSuiteElement) {
                manager.add((IAction)new OpenTestAction(this.fTestRunnerPart, testLabel));
                manager.add((IContributionItem)new Separator());
                if (this.testClassExists(className) && !this.fTestRunnerPart.lastLaunchIsKeptAlive()) {
                    manager.add((IAction)new RerunAction(JUnitMessages.RerunAction_label_run, this.fTestRunnerPart, testElement.getId(), className, null, "run"));
                    manager.add((IAction)new RerunAction(JUnitMessages.RerunAction_label_debug, this.fTestRunnerPart, testElement.getId(), className, null, "debug"));
                }
            } else {
                TestCaseElement testCaseElement = (TestCaseElement)testElement;
                String testMethodName = testCaseElement.getTestMethodName();
                manager.add((IAction)new OpenTestAction(this.fTestRunnerPart, testCaseElement));
                manager.add((IContributionItem)new Separator());
                if (this.fTestRunnerPart.lastLaunchIsKeptAlive()) {
                    manager.add((IAction)new RerunAction(JUnitMessages.RerunAction_label_rerun, this.fTestRunnerPart, testElement.getId(), className, testMethodName, "run"));
                } else {
                    manager.add((IAction)new RerunAction(JUnitMessages.RerunAction_label_run, this.fTestRunnerPart, testElement.getId(), className, testMethodName, "run"));
                    manager.add((IAction)new RerunAction(JUnitMessages.RerunAction_label_debug, this.fTestRunnerPart, testElement.getId(), className, testMethodName, "debug"));
                }
            }
            if (this.fLayoutMode == 1) {
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new ExpandAllAction());
            }
        }
        if (this.fTestRunSession != null && this.fTestRunSession.getFailureCount() + this.fTestRunSession.getErrorCount() > 0) {
            if (this.fLayoutMode != 1) {
                manager.add((IContributionItem)new Separator());
            }
            manager.add((IAction)new CopyFailureListAction(this.fTestRunnerPart, this.fClipboard));
        }
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("additions-end"));
    }

    private boolean testClassExists(String className) {
        IJavaProject project = this.fTestRunnerPart.getLaunchedProject();
        if (project == null) {
            return false;
        }
        try {
            IType type = project.findType(className);
            return type != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public Control getTestViewerControl() {
        return this.fViewerbook;
    }

    public synchronized void registerActiveSession(TestRunSession testRunSession) {
        this.fTestRunSession = testRunSession;
        this.registerAutoScrollTarget(null);
        this.registerViewersRefresh();
    }

    void handleDefaultSelected() {
        OpenTestAction action;
        IStructuredSelection selection = (IStructuredSelection)this.fSelectionProvider.getSelection();
        if (selection.size() != 1) {
            return;
        }
        TestElement testElement = (TestElement)selection.getFirstElement();
        if (testElement instanceof TestSuiteElement) {
            action = new OpenTestAction(this.fTestRunnerPart, testElement.getTestName());
        } else if (testElement instanceof TestCaseElement) {
            TestCaseElement testCase = (TestCaseElement)testElement;
            action = new OpenTestAction(this.fTestRunnerPart, testCase);
        } else {
            throw new IllegalStateException(String.valueOf(testElement));
        }
        if (action.isEnabled()) {
            action.run();
        }
    }

    private void handleSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.fSelectionProvider.getSelection();
        TestElement testElement = null;
        if (selection.size() == 1) {
            testElement = (TestElement)selection.getFirstElement();
        }
        this.fTestRunnerPart.handleTestSelected(testElement);
    }

    public synchronized void setShowTime(boolean showTime) {
        try {
            this.fViewerbook.setRedraw(false);
            this.fTreeLabelProvider.setShowTime(showTime);
            this.fTableLabelProvider.setShowTime(showTime);
        }
        finally {
            this.fViewerbook.setRedraw(true);
        }
    }

    public synchronized void setShowFailuresOnly(boolean failuresOnly, int layoutMode) {
        try {
            boolean switchLayout;
            this.fViewerbook.setRedraw(false);
            IStructuredSelection selection = null;
            boolean bl = switchLayout = layoutMode != this.fLayoutMode;
            if (switchLayout) {
                selection = (IStructuredSelection)this.fSelectionProvider.getSelection();
                if (layoutMode == 1) {
                    if (this.fTreeNeedsRefresh) {
                        this.clearUpdateAndExpansion();
                    }
                } else if (this.fTableNeedsRefresh) {
                    this.clearUpdateAndExpansion();
                }
                this.fLayoutMode = layoutMode;
                this.fViewerbook.showPage(this.getActiveViewer().getControl());
            }
            StructuredViewer viewer = this.getActiveViewer();
            if (failuresOnly) {
                if (!this.getActiveViewerHasFilter()) {
                    this.setActiveViewerNeedsRefresh(true);
                    this.setActiveViewerHasFilter(true);
                    viewer.setInput(null);
                    viewer.addFilter((ViewerFilter)this.fFailuresOnlyFilter);
                }
            } else if (this.getActiveViewerHasFilter()) {
                this.setActiveViewerNeedsRefresh(true);
                this.setActiveViewerHasFilter(false);
                viewer.setInput(null);
                viewer.removeFilter((ViewerFilter)this.fFailuresOnlyFilter);
            }
            this.processChangesInUI();
            if (selection != null) {
                StructuredSelection flatSelection = new StructuredSelection(selection.toList());
                this.fSelectionProvider.setSelection((ISelection)flatSelection, true);
            }
        }
        finally {
            this.fViewerbook.setRedraw(true);
        }
    }

    private boolean getActiveViewerHasFilter() {
        if (this.fLayoutMode == 1) {
            return this.fTreeHasFilter;
        }
        return this.fTableHasFilter;
    }

    private void setActiveViewerHasFilter(boolean filter) {
        if (this.fLayoutMode == 1) {
            this.fTreeHasFilter = filter;
        } else {
            this.fTableHasFilter = filter;
        }
    }

    private StructuredViewer getActiveViewer() {
        if (this.fLayoutMode == 1) {
            return this.fTreeViewer;
        }
        return this.fTableViewer;
    }

    private boolean getActiveViewerNeedsRefresh() {
        if (this.fLayoutMode == 1) {
            return this.fTreeNeedsRefresh;
        }
        return this.fTableNeedsRefresh;
    }

    private void setActiveViewerNeedsRefresh(boolean needsRefresh) {
        if (this.fLayoutMode == 1) {
            this.fTreeNeedsRefresh = needsRefresh;
        } else {
            this.fTableNeedsRefresh = needsRefresh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChangesInUI() {
        if (this.fTestRunSession == null) {
            this.registerViewersRefresh();
            this.fTreeNeedsRefresh = false;
            this.fTableNeedsRefresh = false;
            this.fTreeViewer.setInput(null);
            this.fTableViewer.setInput(null);
            return;
        }
        TestRoot testRoot = this.fTestRunSession.getTestRoot();
        StructuredViewer viewer = this.getActiveViewer();
        if (this.getActiveViewerNeedsRefresh()) {
            this.clearUpdateAndExpansion();
            this.setActiveViewerNeedsRefresh(false);
            viewer.setInput((Object)testRoot);
        } else {
            Object element;
            int n;
            Object[] objectArray;
            Object[] toUpdate;
            TestViewer testViewer = this;
            synchronized (testViewer) {
                toUpdate = this.fNeedUpdate.toArray();
                this.fNeedUpdate.clear();
            }
            if (!this.fTreeNeedsRefresh && toUpdate.length > 0) {
                if (this.fTreeHasFilter) {
                    objectArray = toUpdate;
                    n = toUpdate.length;
                    int n2 = 0;
                    while (n2 < n) {
                        element = objectArray[n2];
                        this.updateElementInTree((TestElement)element);
                        ++n2;
                    }
                } else {
                    HashSet<Object> toUpdateWithParents = new HashSet<Object>();
                    toUpdateWithParents.addAll(Arrays.asList(toUpdate));
                    Object[] objectArray2 = toUpdate;
                    int n3 = toUpdate.length;
                    n = 0;
                    while (n < n3) {
                        Object element2 = objectArray2[n];
                        TestSuiteElement parent = ((TestElement)element2).getParent();
                        while (parent != null) {
                            toUpdateWithParents.add(parent);
                            parent = parent.getParent();
                        }
                        ++n;
                    }
                    this.fTreeViewer.update(toUpdateWithParents.toArray(), null);
                }
            }
            if (!this.fTableNeedsRefresh && toUpdate.length > 0) {
                if (this.fTableHasFilter) {
                    objectArray = toUpdate;
                    n = toUpdate.length;
                    int n4 = 0;
                    while (n4 < n) {
                        element = objectArray[n4];
                        this.updateElementInTable((TestElement)element);
                        ++n4;
                    }
                } else {
                    this.fTableViewer.update(toUpdate, null);
                }
            }
        }
        this.autoScrollInUI();
    }

    private void updateElementInTree(TestElement testElement) {
        if (this.isShown(testElement)) {
            this.updateShownElementInTree(testElement);
        } else {
            TestElement current = testElement;
            do {
                if (this.fTreeViewer.testFindItem((Object)current) == null) continue;
                this.fTreeViewer.remove((Object)current);
            } while (!((current = current.getParent()) instanceof TestRoot) && !this.isShown(current));
            while (current != null && !(current instanceof TestRoot)) {
                this.fTreeViewer.update((Object)current, null);
                current = current.getParent();
            }
        }
    }

    private void updateShownElementInTree(TestElement testElement) {
        if (testElement == null || testElement instanceof TestRoot) {
            return;
        }
        TestSuiteElement parent = testElement.getParent();
        this.updateShownElementInTree((TestElement)parent);
        if (this.fTreeViewer.testFindItem((Object)testElement) == null) {
            this.fTreeViewer.add((Object)parent, (Object)testElement);
        } else {
            this.fTreeViewer.update((Object)testElement, null);
        }
    }

    private void updateElementInTable(TestElement element) {
        if (this.isShown(element)) {
            if (this.fTableViewer.testFindItem((Object)element) == null) {
                TableItem item;
                TestElement previous = this.getNextFailure(element, false);
                int insertionIndex = -1;
                if (previous != null && (item = (TableItem)this.fTableViewer.testFindItem((Object)previous)) != null) {
                    insertionIndex = this.fTableViewer.getTable().indexOf(item);
                }
                this.fTableViewer.insert((Object)element, insertionIndex);
            } else {
                this.fTableViewer.update((Object)element, null);
            }
        } else {
            this.fTableViewer.remove((Object)element);
        }
    }

    private boolean isShown(TestElement current) {
        return this.fFailuresOnlyFilter.select(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoScrollInUI() {
        TestSuiteElement parent;
        if (!this.fTestRunnerPart.isAutoScroll()) {
            this.clearAutoExpand();
            this.fAutoClose.clear();
            return;
        }
        if (this.fLayoutMode == 0) {
            if (this.fAutoScrollTarget != null) {
                this.fTableViewer.reveal((Object)this.fAutoScrollTarget);
            }
            return;
        }
        TestViewer testViewer = this;
        synchronized (testViewer) {
            for (TestSuiteElement suite : this.fAutoExpand) {
                this.fTreeViewer.setExpandedState((Object)suite, true);
            }
            this.clearAutoExpand();
        }
        TestCaseElement current = this.fAutoScrollTarget;
        this.fAutoScrollTarget = null;
        TestSuiteElement testSuiteElement = parent = current == null ? null : (TestSuiteElement)this.fTreeContentProvider.getParent(current);
        if (this.fAutoClose.isEmpty() || !this.fAutoClose.getLast().equals(parent)) {
            ListIterator<TestSuiteElement> iter = this.fAutoClose.listIterator(this.fAutoClose.size());
            while (iter.hasPrevious()) {
                TestSuiteElement previousAutoOpened = iter.previous();
                if (previousAutoOpened.equals(parent)) break;
                if (previousAutoOpened.getStatus() != TestElement.Status.OK) continue;
                iter.remove();
                this.fTreeViewer.collapseToLevel((Object)previousAutoOpened, -1);
            }
            while (parent != null && !this.fTestRunSession.getTestRoot().equals(parent) && !this.fTreeViewer.getExpandedState((Object)parent)) {
                this.fAutoClose.add(parent);
                parent = (TestSuiteElement)this.fTreeContentProvider.getParent(parent);
            }
        }
        if (current != null) {
            this.fTreeViewer.reveal((Object)current);
        }
    }

    public void selectFirstFailure() {
        TestCaseElement firstFailure = this.getNextChildFailure((TestSuiteElement)this.fTestRunSession.getTestRoot(), true);
        if (firstFailure != null) {
            this.getActiveViewer().setSelection((ISelection)new StructuredSelection((Object)firstFailure), true);
        }
    }

    public void selectFailure(boolean showNext) {
        IStructuredSelection selection = (IStructuredSelection)this.getActiveViewer().getSelection();
        TestElement selected = (TestElement)selection.getFirstElement();
        Object next = selected == null ? this.getNextChildFailure((TestSuiteElement)this.fTestRunSession.getTestRoot(), showNext) : this.getNextFailure(selected, showNext);
        if (next != null) {
            this.getActiveViewer().setSelection((ISelection)new StructuredSelection(next), true);
        }
    }

    private TestElement getNextFailure(TestElement selected, boolean showNext) {
        TestCaseElement nextChild;
        if (selected instanceof TestSuiteElement && (nextChild = this.getNextChildFailure((TestSuiteElement)selected, showNext)) != null) {
            return nextChild;
        }
        return this.getNextFailureSibling(selected, showNext);
    }

    private TestCaseElement getNextFailureSibling(TestElement current, boolean showNext) {
        int nextIndex;
        TestSuiteElement parent = current.getParent();
        if (parent == null) {
            return null;
        }
        List<ITestElement> siblings = Arrays.asList(parent.getChildren());
        if (!showNext) {
            siblings = new ReverseList<ITestElement>(siblings);
        }
        int i = nextIndex = siblings.indexOf(current) + 1;
        while (i < siblings.size()) {
            TestElement sibling = (TestElement)siblings.get(i);
            if (sibling.getStatus().isErrorOrFailure()) {
                if (sibling instanceof TestCaseElement) {
                    return (TestCaseElement)sibling;
                }
                return this.getNextChildFailure((TestSuiteElement)sibling, showNext);
            }
            ++i;
        }
        return this.getNextFailureSibling((TestElement)parent, showNext);
    }

    private TestCaseElement getNextChildFailure(TestSuiteElement root, boolean showNext) {
        List<ITestElement> children = Arrays.asList(root.getChildren());
        if (!showNext) {
            children = new ReverseList<ITestElement>(children);
        }
        int i = 0;
        while (i < children.size()) {
            TestElement child = (TestElement)children.get(i);
            if (child.getStatus().isErrorOrFailure()) {
                if (child instanceof TestCaseElement) {
                    return (TestCaseElement)child;
                }
                return this.getNextChildFailure((TestSuiteElement)child, showNext);
            }
            ++i;
        }
        return null;
    }

    public synchronized void registerViewersRefresh() {
        this.fTreeNeedsRefresh = true;
        this.fTableNeedsRefresh = true;
        this.clearUpdateAndExpansion();
    }

    private void clearUpdateAndExpansion() {
        this.fNeedUpdate = new LinkedHashSet<TestElement>();
        this.fAutoClose = new LinkedList();
        this.fAutoExpand = new HashSet();
    }

    public synchronized void registerTestAdded(TestElement testElement) {
        this.fTreeNeedsRefresh = true;
        this.fTableNeedsRefresh = true;
    }

    public synchronized void registerViewerUpdate(TestElement testElement) {
        this.fNeedUpdate.add(testElement);
    }

    private synchronized void clearAutoExpand() {
        this.fAutoExpand.clear();
    }

    public void registerAutoScrollTarget(TestCaseElement testCaseElement) {
        this.fAutoScrollTarget = testCaseElement;
    }

    public synchronized void registerFailedForAutoScroll(TestElement testElement) {
        TestSuiteElement parent = (TestSuiteElement)this.fTreeContentProvider.getParent(testElement);
        if (parent != null) {
            this.fAutoExpand.add(parent);
        }
    }

    public void expandFirstLevel() {
        this.fTreeViewer.expandToLevel(2);
    }

    private class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            this.setText(JUnitMessages.ExpandAllAction_text);
            this.setToolTipText(JUnitMessages.ExpandAllAction_tooltip);
        }

        public void run() {
            TestViewer.this.fTreeViewer.expandAll();
        }
    }

    private final class FailuresOnlyFilter
    extends ViewerFilter {
        private FailuresOnlyFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.select((TestElement)element);
        }

        public boolean select(TestElement testElement) {
            TestElement.Status status = testElement.getStatus();
            if (status.isErrorOrFailure()) {
                return true;
            }
            return !TestViewer.this.fTestRunSession.isRunning() && status == TestElement.Status.RUNNING;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReverseList<E>
    extends AbstractList<E> {
        private final List<E> fList;

        public ReverseList(List<E> list) {
            this.fList = list;
        }

        @Override
        public E get(int index) {
            return this.fList.get(this.fList.size() - index - 1);
        }

        @Override
        public int size() {
            return this.fList.size();
        }
    }

    private final class TestOpenListener
    extends SelectionAdapter {
        private TestOpenListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            TestViewer.this.handleDefaultSelected();
        }
    }

    private final class TestSelectionListener
    implements ISelectionChangedListener {
        private TestSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TestViewer.this.handleSelected();
        }
    }
}

