/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.pde.internal.launching.launcher.LaunchListener;
import org.eclipse.ui.internal.views.log.ILogFileProvider;
import org.eclipse.ui.statushandlers.StatusManager;

public class PDELogFileProvider
implements ILogFileProvider {
    public Map getLogSources() {
        ILaunchConfiguration[] configurations = null;
        try {
            configurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e.getStatus());
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> sources = new HashMap<String, String>();
        int i = 0;
        while (i < configurations.length) {
            ILaunchConfiguration configuration = configurations[i];
            try {
                ILaunchConfigurationType type = configuration.getType();
                if ("org.eclipse.pde.ui.RuntimeWorkbench".equals(type.getIdentifier())) {
                    String name = configuration.getName();
                    File configFile = LaunchListener.getMostRecentLogFile((ILaunchConfiguration)configuration);
                    if (configFile != null) {
                        sources.put(name, configFile.getCanonicalPath());
                    }
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e.getStatus());
            }
            catch (IOException iOException) {}
            ++i;
        }
        return sources;
    }
}

