/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmCompoundTypeReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.util.AbstractTypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xbase.typesystem.util.TraversalData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclaratorTypeArgumentCollector
extends AbstractTypeReferenceVisitorWithParameter.InheritanceAware<TraversalData, Boolean> {
    protected Boolean handleNullReference(TraversalData data) {
        return Boolean.TRUE;
    }

    public Boolean doVisitTypeReference(JvmTypeReference reference, TraversalData data) {
        return Boolean.FALSE;
    }

    public Boolean doVisitCompoundTypeReference(JvmCompoundTypeReference reference, TraversalData data) {
        for (JvmTypeReference component : reference.getReferences()) {
            if (!((Boolean)this.visit(component, data)).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference, TraversalData data) {
        return Boolean.FALSE;
    }

    public Boolean doVisitWildcardTypeReference(JvmWildcardTypeReference reference, TraversalData data) {
        return Boolean.FALSE;
    }

    public Boolean doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference, TraversalData data) {
        JvmType type = reference.getType();
        if (type != null && !type.eIsProxy() && data.getVisited().add(type)) {
            return this.doVisitParameterizedTypeReference(reference, type, data);
        }
        return Boolean.FALSE;
    }

    protected Boolean doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference, JvmType type, TraversalData data) {
        if (type instanceof JvmTypeParameterDeclarator) {
            EList typeParameters = ((JvmTypeParameterDeclarator)type).getTypeParameters();
            EList typeArguments = reference.getArguments();
            int size = Math.min(typeArguments.size(), typeParameters.size());
            int i = 0;
            while (i < size) {
                JvmTypeParameter param = (JvmTypeParameter)typeParameters.get(i);
                JvmTypeReference argument = (JvmTypeReference)typeArguments.get(i);
                if (param != null && argument != null) {
                    data.getTypeParameterMapping().put(param, argument);
                }
                ++i;
            }
        }
        if (type instanceof JvmDeclaredType) {
            EList superTypes = ((JvmDeclaredType)type).getSuperTypes();
            for (JvmTypeReference superType : superTypes) {
                if (!((Boolean)this.visit(superType, data)).booleanValue()) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Map<JvmTypeParameter, JvmTypeReference> getTypeParameterMapping(JvmTypeReference reference) {
        TraversalData data = new TraversalData();
        this.visit(reference, data);
        return data.getTypeParameterMapping();
    }
}

