/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.conversion;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Set;
import org.eclipse.xtext.common.services.DefaultTerminalConverters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.conversion.impl.INTValueConverter;
import org.eclipse.xtext.conversion.impl.KeywordAlternativeConverter;
import org.eclipse.xtext.conversion.impl.KeywordBasedValueConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.conversion.StaticQualifierValueConverter;
import org.eclipse.xtext.xbase.conversion.XbaseQualifiedNameValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class XbaseValueConverterService
extends DefaultTerminalConverters {
    @Inject
    private XbaseQualifiedNameValueConverter qualifiedNameValueConverter;
    @Inject
    private StaticQualifierValueConverter staticQualifierConverter;
    @Inject
    private Provider<KeywordBasedValueConverter> keywordBasedConverterProvider;
    @Inject
    private OtherOperatorsValueConverter otherOperatorsValueConverter;
    @Inject
    private KeywordAlternativeConverter validIDConverter;
    @Inject
    private KeywordAlternativeConverter idOrSuperConverter;
    @Inject
    private IntUnderscoreValueConverter intUnderscoreValueConverter;

    @ValueConverter(rule="IdOrSuper")
    public IValueConverter<String> getIdOrSuperValueConverter() {
        return this.idOrSuperConverter;
    }

    @ValueConverter(rule="ValidID")
    public IValueConverter<String> getValidIDConverter() {
        return this.validIDConverter;
    }

    @ValueConverter(rule="QualifiedName")
    public IValueConverter<String> getQualifiedNameValueConverter() {
        return this.qualifiedNameValueConverter;
    }

    @ValueConverter(rule="StaticQualifier")
    public IValueConverter<String> getStaticQualifierConverter() {
        return this.staticQualifierConverter;
    }

    @ValueConverter(rule="OpSingleAssign")
    public IValueConverter<String> getOpSingleAssignConverter() {
        return (IValueConverter)this.keywordBasedConverterProvider.get();
    }

    @ValueConverter(rule="OpMultiAssign")
    public IValueConverter<String> getOpMultiAssignConverter() {
        return (IValueConverter)this.keywordBasedConverterProvider.get();
    }

    @ValueConverter(rule="OpOr")
    public IValueConverter<String> getOpOrConverter() {
        return (IValueConverter)this.keywordBasedConverterProvider.get();
    }

    @ValueConverter(rule="OpAnd")
    public IValueConverter<String> getOpAndConverter() {
        return (IValueConverter)this.keywordBasedConverterProvider.get();
    }

    @ValueConverter(rule="OpEquality")
    public IValueConverter<String> getOpEqualityConverter() {
        return (IValueConverter)this.keywordBasedConverterProvider.get();
    }

    @ValueConverter(rule="OpCompare")
    public IValueConverter<String> getOpCompareConverter() {
        return (IValueConverter)this.keywordBasedConverterProvider.get();
    }

    @ValueConverter(rule="OpOther")
    public IValueConverter<String> getOpOtherConverter() {
        return this.otherOperatorsValueConverter;
    }

    @ValueConverter(rule="OpAdd")
    public IValueConverter<String> getOpAddConverter() {
        return (IValueConverter)this.keywordBasedConverterProvider.get();
    }

    @ValueConverter(rule="OpMulti")
    public IValueConverter<String> getOpMultiConverter() {
        return (IValueConverter)this.keywordBasedConverterProvider.get();
    }

    @ValueConverter(rule="OpUnary")
    public IValueConverter<String> getOpUnaryConverter() {
        return (IValueConverter)this.keywordBasedConverterProvider.get();
    }

    @ValueConverter(rule="INT")
    public IValueConverter<Integer> INT() {
        return this.intUnderscoreValueConverter;
    }

    public static class IntUnderscoreValueConverter
    extends INTValueConverter {
        public Integer toValue(String string, INode node) {
            if (Strings.isEmpty((String)string)) {
                throw new ValueConverterException("Couldn't convert empty string to an int value.", node, null);
            }
            String withoutUnderscore = string.replace("_", "");
            if (Strings.isEmpty((String)withoutUnderscore)) {
                throw new ValueConverterException("Couldn't convert input '" + string + "' to an int value.", node, null);
            }
            return super.toValue(withoutUnderscore, node);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OtherOperatorsValueConverter
    extends AbstractValueConverter<String> {
        private static final Set<String> operators = ImmutableSet.of((Object)"->", (Object)"..", (Object)"=>", (Object)">>", (Object)">>>", (Object)"<<", (Object[])new String[]{"<<<", "<>", "?:", "<=>"});

        public String toValue(String string, INode node) throws ValueConverterException {
            return string;
        }

        public String toString(String value) throws ValueConverterException {
            if (!operators.contains(value)) {
                throw new ValueConverterException("'" + value + "' is not a valid operator.", null, null);
            }
            return value;
        }
    }
}

