/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.ide.ResourceUtil;

public class BuildUtilities {
    public static IProject[] extractProjects(Object[] selection) {
        HashSet<IProject> projects = new HashSet<IProject>();
        int i = 0;
        while (i < selection.length) {
            IResource resource = ResourceUtil.getResource(selection[i]);
            if (resource != null) {
                projects.add(resource.getProject());
            } else {
                ResourceMapping mapping = ResourceUtil.getResourceMapping(selection[i]);
                if (mapping != null) {
                    IProject[] theProjects = mapping.getProjects();
                    int j = 0;
                    while (j < theProjects.length) {
                        projects.add(theProjects[j]);
                        ++j;
                    }
                }
            }
            ++i;
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    public static IProject[] findSelectedProjects(IWorkbenchWindow window) {
        IEditorPart editor;
        IFile file;
        if (window == null) {
            return new IProject[0];
        }
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            return new IProject[0];
        }
        IWorkbenchPart activePart = activePage.getActivePart();
        if (activePart == null) {
            return new IProject[0];
        }
        ISelection selection = window.getSelectionService().getSelection(activePart.getSite().getId());
        IProject[] selected = null;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            selected = BuildUtilities.extractProjects(((IStructuredSelection)selection).toArray());
        } else if (activePart instanceof IEditorPart && (file = ResourceUtil.getFile((editor = (IEditorPart)activePart).getEditorInput())) != null) {
            selected = new IProject[]{file.getProject()};
        }
        if (selected == null) {
            selected = new IProject[]{};
        }
        return selected;
    }

    public static boolean isEnabled(IProject[] projects, int trigger) {
        if (trigger == 10 && ResourcesPlugin.getWorkspace().isAutoBuilding() && !BuildUtilities.matchingTrigger(projects, 9, false)) {
            return false;
        }
        return BuildUtilities.matchingTrigger(projects, trigger, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean matchingTrigger(IProject[] projects, int trigger, boolean value) {
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isAccessible()) {
                try {
                    IProjectDescription description = projects[i].getDescription();
                    ICommand[] buildSpec = description.getBuildSpec();
                    int j = 0;
                    while (j < buildSpec.length) {
                        if (buildSpec[j].isBuilding(trigger) == value) {
                            return true;
                        }
                        ++j;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return false;
    }

    public static void saveEditors(Collection projects) {
        if (!BuildAction.isSaveAllSet()) {
            return;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                if (projects == null) {
                    page.saveAllEditors(false);
                } else {
                    IEditorPart[] editors = page.getDirtyEditors();
                    int k = 0;
                    while (k < editors.length) {
                        IEditorPart editor = editors[k];
                        IFile inputFile = ResourceUtil.getFile(editor.getEditorInput());
                        if (inputFile != null && projects.contains(inputFile.getProject())) {
                            page.saveEditor(editor, false);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private BuildUtilities() {
    }
}

