/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String filterPath = "";
    String fileName = "";
    String[] fileNames = new String[0];
    String fullPath = "";
    int filterIndex = -1;
    boolean overwrite = false;
    boolean uriMode;
    long handle;
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);
    static final char EXTENSION_SEPARATOR = ';';
    static final char FILE_EXTENSION_SEPARATOR = '.';

    public FileDialog(Shell parent) {
        this(parent, 65536);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, FileDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    String computeResultChooserDialog() {
        long filterNamePtr;
        this.fullPath = null;
        if ((this.style & 2) != 0) {
            long list = 0L;
            list = this.uriMode ? OS.gtk_file_chooser_get_uris(this.handle) : OS.gtk_file_chooser_get_filenames(this.handle);
            int listLength = OS.g_slist_length(list);
            this.fileNames = new String[listLength];
            long current = list;
            int writePos = 0;
            int i = 0;
            while (i < listLength) {
                long name = OS.g_slist_data(current);
                long utf8Ptr = 0L;
                if (this.uriMode) {
                    utf8Ptr = name;
                } else {
                    utf8Ptr = OS.g_filename_to_utf8(name, -1L, null, null, null);
                    if (utf8Ptr == 0L) {
                        utf8Ptr = OS.g_filename_display_name(name);
                    }
                }
                if (name != utf8Ptr) {
                    OS.g_free(name);
                }
                if (utf8Ptr != 0L) {
                    long[] items_written = new long[1];
                    long utf16Ptr = OS.g_utf8_to_utf16(utf8Ptr, -1L, null, items_written, null);
                    OS.g_free(utf8Ptr);
                    if (utf16Ptr != 0L) {
                        int clength = (int)items_written[0];
                        char[] chars = new char[clength];
                        OS.memmove(chars, utf16Ptr, (long)(clength * 2));
                        OS.g_free(utf16Ptr);
                        this.fullPath = new String(chars);
                        this.fileNames[writePos++] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                    }
                }
                current = OS.g_slist_next(current);
                ++i;
            }
            if (writePos != 0 && writePos != listLength) {
                String[] validFileNames = new String[writePos];
                System.arraycopy(this.fileNames, 0, validFileNames, 0, writePos);
                this.fileNames = validFileNames;
            }
            OS.g_slist_free(list);
        } else {
            long utf8Ptr = 0L;
            if (this.uriMode) {
                utf8Ptr = OS.gtk_file_chooser_get_uri(this.handle);
            } else {
                long path = OS.gtk_file_chooser_get_filename(this.handle);
                if (path != 0L) {
                    utf8Ptr = OS.g_filename_to_utf8(path, -1L, null, null, null);
                    if (utf8Ptr == 0L) {
                        utf8Ptr = OS.g_filename_display_name(path);
                    }
                    if (path != utf8Ptr) {
                        OS.g_free(path);
                    }
                }
            }
            if (utf8Ptr != 0L) {
                long[] items_written = new long[1];
                long utf16Ptr = OS.g_utf8_to_utf16(utf8Ptr, -1L, null, items_written, null);
                OS.g_free(utf8Ptr);
                if (utf16Ptr != 0L) {
                    int clength = (int)items_written[0];
                    char[] chars = new char[clength];
                    OS.memmove(chars, utf16Ptr, (long)(clength * 2));
                    OS.g_free(utf16Ptr);
                    this.fullPath = new String(chars);
                    this.fileNames = new String[1];
                    this.fileNames[0] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                }
            }
        }
        this.filterIndex = -1;
        long filter = OS.gtk_file_chooser_get_filter(this.handle);
        if (filter != 0L && (filterNamePtr = OS.gtk_file_filter_get_name(filter)) != 0L) {
            int length = OS.strlen(filterNamePtr);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, filterNamePtr, (long)length);
            String filterName = new String(Converter.mbcsToWcs(null, buffer));
            int i = 0;
            while (i < this.filterExtensions.length) {
                if (this.filterNames.length > 0) {
                    if (this.filterNames[i].equals(filterName)) {
                        this.filterIndex = i;
                        break;
                    }
                } else if (this.filterExtensions[i].equals(filterName)) {
                    this.filterIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (this.fullPath != null) {
            int separatorIndex = this.fullPath.lastIndexOf(SEPARATOR);
            this.fileName = this.fullPath.substring(separatorIndex + 1);
            this.filterPath = this.fullPath.substring(0, separatorIndex);
            int fileExtensionIndex = this.fileName.indexOf(46);
            if ((this.style & 0x2000) != 0 && fileExtensionIndex == -1 && this.filterIndex != -1 && this.filterExtensions.length > this.filterIndex) {
                String extension;
                String selection = this.filterExtensions[this.filterIndex];
                int length = selection.length();
                int index = selection.indexOf(59);
                if (index == -1) {
                    index = length;
                }
                if (!(extension = selection.substring(0, index).trim()).equals("*") && !extension.equals("*.*")) {
                    if (extension.startsWith("*.")) {
                        extension = extension.substring(1);
                    }
                    this.fullPath = String.valueOf(this.fullPath) + extension;
                }
            }
        }
        return this.fullPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String open() {
        return this.openChooserDialog();
    }

    String openChooserDialog() {
        long pixbufs;
        byte[] titleBytes = Converter.wcsToMbcs(null, this.title, true);
        int action = (this.style & 0x2000) != 0 ? 1 : 0;
        long shellHandle = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.handle = display.getDismissalAlignment() == 131072 ? OS.gtk_file_chooser_dialog_new(titleBytes, shellHandle, action, OS.GTK_STOCK_CANCEL(), -6, OS.GTK_STOCK_OK(), -5, 0L) : OS.gtk_file_chooser_dialog_new(titleBytes, shellHandle, action, OS.GTK_STOCK_OK(), -5, OS.GTK_STOCK_CANCEL(), -6, 0L);
        if (this.handle == 0L) {
            this.error(2);
        }
        OS.gtk_window_set_modal(this.handle, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
            long group = OS.gtk_window_get_group(0L);
            OS.gtk_window_group_add_window(group, this.handle);
        }
        if ((pixbufs = OS.gtk_window_get_icon_list(shellHandle)) != 0L) {
            OS.gtk_window_set_icon_list(this.handle, pixbufs);
            OS.g_list_free(pixbufs);
        }
        if (this.uriMode) {
            OS.gtk_file_chooser_set_local_only(this.handle, false);
        }
        this.presetChooserDialog();
        display.addIdleProc();
        String answer = null;
        Dialog oldModal = null;
        if (OS.gtk_window_get_modal(this.handle)) {
            oldModal = display.getModalDialog();
            display.setModalDialog(this);
        }
        int signalId = 0;
        long hookId = 0L;
        if ((this.style & 0x4000000) != 0) {
            signalId = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            hookId = OS.g_signal_add_emission_hook(signalId, 0, display.emissionProc, this.handle, 0L);
        }
        int response = OS.gtk_dialog_run(this.handle);
        OS.gdk_threads_leave();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(signalId, hookId);
        }
        if (OS.gtk_window_get_modal(this.handle)) {
            display.setModalDialog(oldModal);
        }
        if (response == -5) {
            answer = this.computeResultChooserDialog();
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(this.handle);
        return answer;
    }

    void presetChooserDialog() {
        if ((this.style & 0x2002) == 2) {
            OS.gtk_file_chooser_set_select_multiple(this.handle, true);
        }
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        if (this.fileName == null) {
            this.fileName = "";
        }
        if ((this.style & 0x2000) != 0) {
            byte[] buffer;
            if (this.filterPath.length() > 0) {
                if (this.uriMode) {
                    buffer = Converter.wcsToMbcs(null, this.filterPath, true);
                    OS.gtk_file_chooser_set_current_folder_uri(this.handle, buffer);
                } else {
                    buffer = Converter.wcsToMbcs(null, String.valueOf(SEPARATOR) + this.filterPath, true);
                    long ptr = OS.realpath(buffer, null);
                    OS.gtk_file_chooser_set_current_folder(this.handle, ptr);
                    OS.g_free(ptr);
                }
            }
            if (this.fileName.length() > 0) {
                buffer = Converter.wcsToMbcs(null, this.fileName, true);
                OS.gtk_file_chooser_set_current_name(this.handle, buffer);
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.filterPath.length() > 0) {
                if (!this.uriMode) {
                    stringBuffer.append(SEPARATOR);
                }
                stringBuffer.append(this.filterPath);
                stringBuffer.append(SEPARATOR);
            }
            if (this.fileName.length() > 0) {
                stringBuffer.append(this.fileName);
            }
            byte[] buffer = Converter.wcsToMbcs(null, stringBuffer.toString(), true);
            if (this.uriMode) {
                OS.gtk_file_chooser_set_uri(this.handle, buffer);
            } else {
                long ptr = OS.realpath(buffer, null);
                if (ptr != 0L) {
                    if (this.fileName.length() > 0) {
                        OS.gtk_file_chooser_set_filename(this.handle, ptr);
                    } else {
                        OS.gtk_file_chooser_set_current_folder(this.handle, ptr);
                    }
                    OS.g_free(ptr);
                }
            }
        }
        if ((this.style & 0x2000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
            OS.gtk_file_chooser_set_do_overwrite_confirmation(this.handle, this.overwrite);
        }
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        long initialFilter = 0L;
        int i = 0;
        while (i < this.filterExtensions.length) {
            if (this.filterExtensions[i] != null) {
                byte[] filterString;
                String current;
                byte[] name;
                long filter = OS.gtk_file_filter_new();
                if (this.filterNames.length > i && this.filterNames[i] != null) {
                    name = Converter.wcsToMbcs(null, this.filterNames[i], true);
                    OS.gtk_file_filter_set_name(filter, name);
                } else {
                    name = Converter.wcsToMbcs(null, this.filterExtensions[i], true);
                    OS.gtk_file_filter_set_name(filter, name);
                }
                int start = 0;
                int index = this.filterExtensions[i].indexOf(59);
                while (index != -1) {
                    current = this.filterExtensions[i].substring(start, index);
                    filterString = Converter.wcsToMbcs(null, current, true);
                    OS.gtk_file_filter_add_pattern(filter, filterString);
                    start = index + 1;
                    index = this.filterExtensions[i].indexOf(59, start);
                }
                current = this.filterExtensions[i].substring(start);
                filterString = Converter.wcsToMbcs(null, current, true);
                OS.gtk_file_filter_add_pattern(filter, filterString);
                OS.gtk_file_chooser_add_filter(this.handle, filter);
                if (i == this.filterIndex) {
                    initialFilter = filter;
                }
            }
            ++i;
        }
        if (initialFilter != 0L) {
            OS.gtk_file_chooser_set_filter(this.handle, initialFilter);
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterIndex(int index) {
        this.filterIndex = index;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    void setURIMode(boolean uriMode) {
        this.uriMode = uriMode;
    }
}

