/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class NoLineTerminationResolution
extends AbstractManifestMarkerResolution {
    public NoLineTerminationResolution(int type) {
        super(type);
    }

    protected void createChange(BundleModel model) {
        if (this.getType() == 3) {
            IDocument doc = model.getDocument();
            try {
                IRegion lastLine = doc.getLineInformation(doc.getNumberOfLines() - 1);
                doc.replace(lastLine.getOffset(), lastLine.getLength(), "");
            }
            catch (BadLocationException badLocationException) {}
        } else if (this.getType() == 1) {
            IDocument doc = model.getDocument();
            try {
                String lineDelimiter = doc.getLineDelimiter(0);
                if (lineDelimiter == null) {
                    lineDelimiter = "";
                }
                doc.replace(doc.getLength(), 0, lineDelimiter);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    public String getDescription() {
        if (this.getType() == 3) {
            return PDEUIMessages.NoLineTerminationResolutionRemove_description;
        }
        return PDEUIMessages.NoLineTerminationResolutionCreate_description;
    }

    public String getLabel() {
        if (this.getType() == 3) {
            return PDEUIMessages.NoLineTerminationResolutionRemove_label;
        }
        return PDEUIMessages.NoLineTerminationResolutionCreate_label;
    }
}

