/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.labels;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TransportMode implements Enumerator
{
    UNSPECIFIED_LITERAL(0, "unspecified", "unspecified"),
    AIR_LITERAL(2, "air", "air"),
    ROAD_LITERAL(4, "road", "road"),
    RAIL_LITERAL(6, "rail", "rail"),
    MARINE_LITERAL(8, "marine", "marine"),
    FOOT_LITERAL(10, "foot", "foot");

    public static final int UNSPECIFIED = 0;
    public static final int AIR = 2;
    public static final int ROAD = 4;
    public static final int RAIL = 6;
    public static final int MARINE = 8;
    public static final int FOOT = 10;
    private static final TransportMode[] VALUES_ARRAY;
    public static final List<TransportMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TransportMode[]{UNSPECIFIED_LITERAL, AIR_LITERAL, ROAD_LITERAL, RAIL_LITERAL, MARINE_LITERAL, FOOT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TransportMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TransportMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TransportMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TransportMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TransportMode get(int value) {
        switch (value) {
            case 0: {
                return UNSPECIFIED_LITERAL;
            }
            case 2: {
                return AIR_LITERAL;
            }
            case 4: {
                return ROAD_LITERAL;
            }
            case 6: {
                return RAIL_LITERAL;
            }
            case 8: {
                return MARINE_LITERAL;
            }
            case 10: {
                return FOOT_LITERAL;
            }
        }
        return null;
    }

    private TransportMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

