/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import org.eclipse.birt.core.archive.compound.AllocEntry;
import org.eclipse.birt.core.archive.compound.ArchiveConstants;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFileV2;
import org.eclipse.birt.core.archive.compound.Block;
import org.eclipse.birt.core.archive.compound.NameEntry;
import org.eclipse.birt.core.i18n.CoreMessages;

class ArchiveEntryV2
extends ArchiveEntry
implements ArchiveConstants {
    protected final int BLOCK_SIZE;
    protected int cachId;
    protected ArchiveFileV2 af;
    protected NameEntry entry;
    protected AllocEntry index;
    private int cachedBlockId;
    private Block cachedBlock;

    ArchiveEntryV2(ArchiveFileV2 af, NameEntry entry) throws IOException {
        super(entry.getName());
        this.af = af;
        this.BLOCK_SIZE = af.BLOCK_SIZE;
        this.entry = entry;
        this.cachId = entry.getBlock();
        if (this.cachId != -1) {
            this.index = af.allocTbl.loadEntry(this.cachId);
        }
        this.cachedBlockId = -1;
        this.cachedBlock = null;
    }

    public void close() throws IOException {
        if (this.cachedBlock != null) {
            this.af.unloadBlock(this.cachedBlock);
        }
        this.cachedBlockId = -1;
        this.cachedBlock = null;
    }

    public synchronized long getLength() throws IOException {
        return this.entry.getLength();
    }

    public synchronized void setLength(long length) throws IOException {
        this.ensureSize(length);
        this.entry.setLength(length);
    }

    public synchronized void flush() throws IOException {
        super.flush();
    }

    public synchronized void refresh() throws IOException {
    }

    public synchronized int read(long pos, byte[] b, int off, int len) throws IOException {
        long length = this.entry.getLength();
        if (pos >= length) {
            return -1;
        }
        if (pos + (long)len > length) {
            len = (int)(length - pos);
        }
        if (len == 0) {
            return 0;
        }
        int blockId = (int)(pos / (long)this.BLOCK_SIZE);
        int blockOff = (int)(pos % (long)this.BLOCK_SIZE);
        int readSize = this.BLOCK_SIZE - blockOff;
        if (len < readSize) {
            readSize = len;
        }
        Block block = this.loadBlock(blockId);
        block.read(blockOff, b, off, readSize);
        int remainSize = len - readSize;
        while (remainSize >= this.BLOCK_SIZE) {
            block = this.loadBlock(++blockId);
            block.read(0, b, off + readSize, this.BLOCK_SIZE);
            readSize += this.BLOCK_SIZE;
            remainSize -= this.BLOCK_SIZE;
        }
        if (remainSize > 0) {
            block = this.loadBlock(++blockId);
            block.read(0, b, off + readSize, remainSize);
            readSize += remainSize;
        }
        return readSize;
    }

    public synchronized void write(long pos, byte[] b, int off, int len) throws IOException {
        long offset;
        long length;
        this.ensureSize(pos + (long)len);
        if (len == 0) {
            return;
        }
        int blockId = (int)(pos / (long)this.BLOCK_SIZE);
        int blockOff = (int)(pos % (long)this.BLOCK_SIZE);
        int writeSize = this.BLOCK_SIZE - blockOff;
        if (len < writeSize) {
            writeSize = len;
        }
        Block block = this.loadBlock(blockId);
        block.write(blockOff, b, off, writeSize);
        int remainSize = len - writeSize;
        while (remainSize >= this.BLOCK_SIZE) {
            block = this.loadBlock(++blockId);
            block.write(0, b, off + writeSize, this.BLOCK_SIZE);
            writeSize += this.BLOCK_SIZE;
            remainSize -= this.BLOCK_SIZE;
        }
        if (remainSize > 0) {
            block = this.loadBlock(++blockId);
            block.write(0, b, off + writeSize, remainSize);
        }
        if ((length = this.entry.getLength()) < (offset = pos + (long)len)) {
            this.setLength(offset);
        }
    }

    protected void ensureSize(long newLength) throws IOException {
        int totalBlock;
        int blockCount;
        if (this.index == null) {
            this.index = this.af.allocTbl.createEntry();
            this.entry.setBlock(this.index.getFirstBlock());
        }
        if ((blockCount = (int)((newLength + (long)this.BLOCK_SIZE - 1L) / (long)this.BLOCK_SIZE)) > (totalBlock = this.index.getTotalBlocks())) {
            while (totalBlock < blockCount) {
                int freeBlock = this.af.allocTbl.getFreeBlock();
                this.index.appendBlock(freeBlock);
                ++totalBlock;
            }
        }
    }

    private Block loadBlock(int blockId) throws IOException {
        if (this.cachedBlockId == blockId) {
            return this.cachedBlock;
        }
        if (this.cachedBlock != null) {
            this.af.unloadBlock(this.cachedBlock);
            this.cachedBlock = null;
        }
        this.cachedBlockId = blockId;
        int fileBlockId = this.index.getBlock(blockId);
        if (fileBlockId != -1) {
            this.cachedBlock = this.af.loadBlock(fileBlockId);
            return this.cachedBlock;
        }
        throw new IOException(CoreMessages.getFormattedString("error.InvalidIndex", blockId));
    }
}

