/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEExtensionRegistry;

public class RequirementHelper {
    public static String[] getApplicationRequirements(ILaunchConfiguration config) throws CoreException {
        HashSet requiredIds = new HashSet();
        if (config.getAttribute("useProduct", false)) {
            String product = config.getAttribute("product", null);
            if (product != null) {
                RequirementHelper.getProductRequirements(product, requiredIds);
            }
        } else {
            String configType = config.getType().getIdentifier();
            if (configType.equals("org.eclipse.pde.ui.RuntimeWorkbench")) {
                String application = config.getAttribute("application", TargetPlatform.getDefaultApplication());
                if (!"org.eclipse.pde.junit.runtime.coretestapplication".equals(application)) {
                    RequirementHelper.getApplicationRequirements(application, requiredIds);
                }
            } else {
                String application = config.getAttribute("testApplication", null);
                if (application == null) {
                    application = config.getAttribute("application", null);
                }
                if (application == null) {
                    application = TargetPlatform.getDefaultApplication();
                }
                if (!"org.eclipse.pde.junit.runtime.coretestapplication".equals(application)) {
                    RequirementHelper.getApplicationRequirements(application, requiredIds);
                }
            }
        }
        return requiredIds.toArray(new String[requiredIds.size()]);
    }

    private static void getProductRequirements(String product, Collection requiredIds) {
        PDEExtensionRegistry registry = PDECore.getDefault().getExtensionsRegistry();
        IExtension[] extensions = registry.findExtensions("org.eclipse.core.runtime.products", true);
        int i = 0;
        while (i < extensions.length) {
            if (product.equals(extensions[i].getUniqueIdentifier()) || product.equals(extensions[i].getSimpleIdentifier())) {
                requiredIds.add(extensions[i].getNamespaceIdentifier());
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    String application = elements[j].getAttribute("application");
                    if (application != null && application.length() > 0) {
                        RequirementHelper.getApplicationRequirements(application, requiredIds);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
    }

    private static void getApplicationRequirements(String application, Collection requiredIds) {
        PDEExtensionRegistry registry = PDECore.getDefault().getExtensionsRegistry();
        IExtension[] extensions = registry.findExtensions("org.eclipse.core.runtime.applications", true);
        int i = 0;
        while (i < extensions.length) {
            if (application.equals(extensions[i].getUniqueIdentifier()) || application.equals(extensions[i].getSimpleIdentifier())) {
                requiredIds.add(extensions[i].getNamespaceIdentifier());
                break;
            }
            ++i;
        }
    }
}

