/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.serializer.impl.FeatureFinderUtil;
import org.eclipse.xtext.serializer.sequencer.IAssignmentFinder;
import org.eclipse.xtext.serializer.sequencer.IContextFinder;
import org.eclipse.xtext.serializer.tokens.ICrossReferenceSerializer;
import org.eclipse.xtext.serializer.tokens.IEnumLiteralSerializer;
import org.eclipse.xtext.serializer.tokens.IKeywordSerializer;
import org.eclipse.xtext.serializer.tokens.IValueSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignmentFinder
implements IAssignmentFinder {
    @Inject
    protected IContextFinder contextFinder;
    @Inject
    protected ICrossReferenceSerializer crossRefSerializer;
    @Inject
    protected IEnumLiteralSerializer enumLiteralSerializer;
    @Inject
    protected IKeywordSerializer keywordSerializer;
    @Inject
    protected IValueSerializer valueSerializer;

    @Override
    public Iterable<AbstractElement> findAssignmentsByValue(EObject semanticObj, Iterable<AbstractElement> assignedElements, Object value, INode node) {
        EStructuralFeature feature = FeatureFinderUtil.getFeature(assignedElements.iterator().next(), semanticObj.eClass());
        if (feature instanceof EAttribute) {
            Class clazz = feature.getEType().getInstanceClass();
            if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                return this.findValidBooleanAssignments(semanticObj, assignedElements, value);
            }
            return this.findValidValueAssignments(semanticObj, assignedElements, value);
        }
        if (feature instanceof EReference) {
            EReference ref = (EReference)feature;
            if (ref.isContainment()) {
                return this.findValidAssignmentsForContainmentRef(semanticObj, assignedElements, (EObject)value);
            }
            return this.findValidAssignmentsForCrossRef(semanticObj, assignedElements, (EObject)value, node);
        }
        throw new RuntimeException("unknown feature type");
    }

    protected Iterable<AbstractElement> findValidAssignmentsForContainmentRef(EObject semanticObj, Iterable<AbstractElement> assignedElements, EObject value) {
        HashMultimap candidates = HashMultimap.create();
        for (AbstractElement ass : assignedElements) {
            if (ass instanceof RuleCall) {
                candidates.put((Object)((RuleCall)ass).getRule(), (Object)ass);
                continue;
            }
            if (!(ass instanceof Action)) continue;
            candidates.put((Object)ass, (Object)ass);
        }
        HashSet contexts = Sets.newHashSet(this.contextFinder.findContextsByContents(value, candidates.keySet()));
        ArrayList result = Lists.newArrayList();
        for (EObject ctx : contexts) {
            result.addAll(candidates.get((Object)ctx));
        }
        return result;
    }

    protected Iterable<AbstractElement> findValidAssignmentsForCrossRef(EObject semanticObj, Iterable<AbstractElement> assignedElements, EObject value, INode node) {
        ArrayList result = Lists.newArrayList();
        for (AbstractElement ass : assignedElements) {
            CrossReference crossref = GrammarUtil.containingCrossReference(ass);
            EReference eref = GrammarUtil.getReference(crossref, semanticObj.eClass());
            if (!EcoreUtil2.isAssignableFrom(eref.getEReferenceType(), value.eClass()) || !this.crossRefSerializer.isValid(semanticObj, crossref, value, node, null)) continue;
            result.add(ass);
        }
        return result;
    }

    protected Iterable<AbstractElement> findValidBooleanAssignments(EObject semanticObj, Iterable<AbstractElement> assignedElements, Object value) {
        ArrayList result = Lists.newArrayList();
        for (AbstractElement ele : assignedElements) {
            if (GrammarUtil.isBooleanAssignment(GrammarUtil.containingAssignment(ele))) {
                if (!Boolean.TRUE.equals(value)) continue;
                result.add(ele);
                continue;
            }
            if (!(ele instanceof RuleCall) || !this.valueSerializer.isValid(semanticObj, (RuleCall)ele, value, null)) continue;
            result.add(ele);
        }
        return result;
    }

    protected Iterable<AbstractElement> findValidValueAssignments(EObject semanticObj, Iterable<AbstractElement> assignedElements, Object value) {
        for (AbstractElement ass : assignedElements) {
            if (!(ass instanceof Keyword) || !this.keywordSerializer.isValid(semanticObj, (Keyword)ass, value, null)) continue;
            return Collections.singletonList(ass);
        }
        ArrayList result = Lists.newArrayList();
        for (AbstractElement ass : assignedElements) {
            if (!(ass instanceof RuleCall)) continue;
            RuleCall rc = (RuleCall)ass;
            if (rc.getRule() instanceof EnumRule) {
                if (!this.enumLiteralSerializer.isValid(semanticObj, rc, value, null)) continue;
                result.add(ass);
                continue;
            }
            if (!this.valueSerializer.isValid(semanticObj, rc, value, null)) continue;
            result.add(ass);
        }
        return result;
    }
}

