/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.kml;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GEData;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.kml.IKmlDisplay;
import org.eclipse.stem.ui.ge.kml.KmlDoc;
import org.eclipse.stem.ui.ge.kml.PlaceMark;
import org.eclipse.stem.ui.ge.kml.Point;
import org.eclipse.stem.ui.ge.kml.Polygon;
import org.eclipse.stem.ui.ge.kml.StemKml;
import org.eclipse.stem.ui.ge.kml.Style;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KmlDisplaySelection
implements IKmlDisplay {
    public void init() {
    }

    @Override
    public void generatePolygons(String controlFileName, Map<String, GEData> geData, Aspect unused) {
        GELog.debug(this, "file=" + controlFileName + " number=" + geData.size());
        KmlDoc kml = new KmlDoc();
        Document doc = kml.getDocument();
        Element root = kml.setRoot(null);
        Element document = kml.appendElement(root, "Document");
        Style styles = this.setupStyles(kml, document);
        for (Map.Entry<String, GEData> e : geData.entrySet()) {
            GEData data = e.getValue();
            PlaceMark placeMark = new PlaceMark(doc);
            placeMark.setDescription(data.getDescription());
            placeMark.setName(data.getName());
            placeMark.setStyleUrl(styles);
            Point point = new Point(doc);
            double[] pts = data.getPoint();
            point.setCoordinates(pts[0], pts[1]);
            placeMark.appendChild(point.getElement());
            document.appendChild(placeMark.getElement());
            placeMark = new PlaceMark(doc);
            Element multiGeometry = null;
            placeMark.setDescription("polygon description");
            placeMark.setName(data.getName());
            placeMark.setStyleUrl(styles);
            document.appendChild(placeMark.getElement());
            multiGeometry = doc.createElement("MultiGeometry");
            placeMark.appendChild(multiGeometry);
            int n = data.getNumAreas();
            int i = 0;
            while (i < n) {
                String coord = data.getCoordinatesAsString(i);
                String county = data.getName();
                GELog.debug(this, String.valueOf(i) + ": " + county + " " + coord);
                Polygon polygon = new Polygon(doc);
                kml.appendText(polygon.getElement(), "name", county);
                polygon.setCoordinates(coord);
                multiGeometry.appendChild(polygon.getElement());
                ++i;
            }
        }
        kml.writeFile(controlFileName);
        kml.display();
    }

    private Style setupStyles(KmlDoc kml, Element document) {
        Document doc = kml.getDocument();
        Style styles = new Style(doc, "StyleSelect");
        styles.setLineStyle(0.3);
        document.appendChild(styles.getElement());
        int oo = 128;
        int blue = 128;
        int red = 0;
        int green = 128;
        boolean outline = GEPreferencePage.isShowBorder();
        String hex = String.valueOf(StemKml.getHex(oo)) + StemKml.getHex(blue) + StemKml.getHex(green) + StemKml.getHex(red);
        styles.setPolyStyle(hex, outline);
        styles.setBalloonStyle();
        return styles;
    }

    public int selectByValue(Aspect aspect, GEData geData) {
        double value;
        int type;
        block9: {
            String code;
            block8: {
                type = 0;
                code = aspect.getCode();
                Assert.isNotNull((Object)code, (String)"Aspect code is null");
                if (code != null) break block8;
                return 0;
            }
            Map<String, Double> map = geData.getValueMap();
            Assert.isNotNull(map, (String)"Aspect map is null");
            value = 0.0;
            if (map != null) {
                Double d = map.get(code);
                if (d != null) {
                    value = d;
                }
                break block9;
            }
            return 0;
        }
        try {
            double[] range = aspect.getRange();
            int i = 0;
            while (i < range.length) {
                if (value <= range[i]) {
                    type = i;
                    break;
                }
                ++i;
            }
        }
        catch (RuntimeException e1) {
            GELog.error("selectByValue", e1);
        }
        return type;
    }
}

