/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.adapters.diseasemodelpropertyeditor;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.model.ModelPackage;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.ui.editors.GenericPropertyEditor;
import org.eclipse.stem.ui.wizards.DiseaseWizardMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public abstract class DiseaseModelPropertyEditor
extends GenericPropertyEditor {
    public boolean isUserSpecifiedProperty(EStructuralFeature feature) {
        boolean retValue = false;
        EClass containingClass = feature.getEContainingClass();
        if (containingClass.equals(ModelPackage.eINSTANCE.getIntegrationDecorator()) || containingClass.equals(StandardPackage.eINSTANCE.getDiseaseModel()) || containingClass.equals(StandardPackage.eINSTANCE.getStochasticDiseaseModel()) || containingClass.getEAllSuperTypes().contains((Object)StandardPackage.eINSTANCE.getDiseaseModel()) || containingClass.getEAllSuperTypes().contains((Object)StandardPackage.eINSTANCE.getStochasticDiseaseModel())) {
            if (feature.getName().equals("finiteDifference") || feature.getName().equals("relativeTolerance")) {
                return false;
            }
            retValue = true;
        }
        return retValue;
    }

    public DiseaseModelPropertyEditor(Composite parent, int style, IProject project) {
        super(parent, style, project);
    }

    public DiseaseModelPropertyEditor(Composite parent, int style, DiseaseModel diseaseModel, ModifyListener projectValidator, IProject project) {
        super(parent, style, (Identifiable)diseaseModel, projectValidator, project);
    }

    public void populate(DiseaseModel diseaseModel) {
        super.populate((EObject)diseaseModel);
        for (Map.Entry entry : this.map.entrySet()) {
            switch (((EStructuralFeature)entry.getKey()).getFeatureID()) {
                case 13: {
                    diseaseModel.setDiseaseName(((Text)entry.getValue()).getText());
                    break;
                }
                case 11: {
                    diseaseModel.setPopulationIdentifier(((Text)entry.getValue()).getText());
                    break;
                }
                case 12: {
                    diseaseModel.setTimePeriod(Long.parseLong(((Text)entry.getValue()).getText()));
                    break;
                }
            }
        }
    }

    public boolean validate() {
        Text text;
        boolean retValue = super.validate();
        if (retValue) {
            text = (Text)this.map.get(StandardPackage.Literals.DISEASE_MODEL__DISEASE_NAME);
            boolean bl = retValue = !text.getText().equals("");
            if (!retValue) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr0");
            }
        }
        if (retValue) {
            text = (Text)this.map.get(StandardPackage.Literals.DISEASE_MODEL__POPULATION_IDENTIFIER);
            boolean bl = retValue = !text.getText().equals("");
            if (!retValue) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr1");
            }
        }
        if (retValue) {
            text = (Text)this.map.get(StandardPackage.Literals.DISEASE_MODEL__TIME_PERIOD);
            boolean bl = retValue = !text.getText().equals("");
            if (!retValue) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr2");
            } else {
                retValue = this.isValidLongValue(text.getText(), 1L);
                if (!retValue) {
                    this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr3");
                }
            }
        }
        return retValue;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

