/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.stem.model.metamodel.CompartmentType;
import org.eclipse.stem.model.metamodel.MetamodelFactory;
import org.eclipse.stem.model.metamodel.Transition;
import org.eclipse.stem.model.ui.editor.vismodel.CompartmentElement;
import org.eclipse.stem.model.ui.editor.vismodel.ModelElement;
import org.eclipse.stem.model.ui.editor.vismodel.TransitionElement;
import org.eclipse.stem.model.ui.editor.vismodel.VisualMetamodelFactory;

public class TransitionCreateCommand
extends Command {
    private TransitionElement transitionElement;
    private CompartmentElement source;
    private CompartmentElement target;

    public TransitionCreateCommand(CompartmentElement source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("Create Transition");
        this.source = source;
    }

    public void setTarget(CompartmentElement target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this.target = target;
    }

    public boolean canExecute() {
        if (this.target == null) {
            return false;
        }
        if (this.source.equals(this.target)) {
            return false;
        }
        if (this.source.getModelElement() != this.target.getModelElement()) {
            return false;
        }
        if (this.source.getCompartment().getType() != CompartmentType.STANDARD) {
            return false;
        }
        if (this.target.getCompartment().getType() != CompartmentType.STANDARD && this.target.getCompartment().getType() != CompartmentType.DEATHS) {
            return false;
        }
        ModelElement model = this.source.getModelElement();
        for (TransitionElement te : model.getTransitionElements()) {
            if (te.getSource() == null || te.getTarget() == null || !te.getSource().equals(this.source) || !te.getTarget().equals(this.target)) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        this.transitionElement = VisualMetamodelFactory.eINSTANCE.createTransitionElement();
        Transition t = MetamodelFactory.eINSTANCE.createTransition();
        t.setSource(this.source.getCompartment());
        t.setTarget(this.target.getCompartment());
        t.setExpression("delta 0;");
        this.source.getModelElement().getModel().getTransitions().add((Object)t);
        this.transitionElement.setTransition(t);
        this.transitionElement.setSource(this.source);
        this.transitionElement.setTarget(this.target);
        this.source.getModelElement().getTransitionElements().add((Object)this.transitionElement);
        this.source.eNotify(null);
        this.target.eNotify(null);
    }

    public void redo() {
    }

    public void undo() {
    }
}

