/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.hover;

import com.google.inject.Inject;
import com.google.inject.Injector;
import org.eclipse.jdt.internal.debug.ui.JavaDebugHover;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.xtext.ui.editor.hover.IEObjectHoverProvider;

public class JavaDebugHoverProvider {
    @Inject
    private Injector injector;
    public static boolean IS_JAVA_DEBUG_HOVER_AVAILABLE = JavaDebugHoverProvider.isJavaDebugHoverAvailable();

    private static boolean isJavaDebugHoverAvailable() {
        try {
            JavaDebugHover.class.getName();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public IEObjectHoverProvider.IInformationControlCreatorProvider getInformationControlCreatorProvider(ITextViewer textViewer, IRegion hoverRegion) {
        if (!IS_JAVA_DEBUG_HOVER_AVAILABLE) {
            return null;
        }
        final JavaDebugHover javaDebugHover = (JavaDebugHover)this.injector.getInstance(JavaDebugHover.class);
        final Object hoverInfo = javaDebugHover.getHoverInfo2(textViewer, hoverRegion);
        if (hoverInfo == null) {
            return null;
        }
        return new IEObjectHoverProvider.IInformationControlCreatorProvider2(){

            public IInformationControlCreator getHoverControlCreator() {
                return javaDebugHover.getHoverControlCreator();
            }

            public Object getInfo() {
                return hoverInfo;
            }

            public IInformationControlCreator getInformationPresenterControlCreator() {
                return javaDebugHover.getInformationPresenterControlCreator();
            }
        };
    }
}

