/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.gis.dbf;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.SwappedDataInputStream;
import org.eclipse.stem.gis.dbf.DbfFieldDef;
import org.eclipse.stem.gis.dbf.DbfHeader;
import org.eclipse.stem.gis.dbf.DbfRecord;

public class DbfInputStream
extends SwappedDataInputStream {
    protected DbfHeader header;

    public DbfInputStream(InputStream input) throws IOException {
        super(input);
        this.readHeader();
    }

    public DbfHeader getHeader() {
        return this.header;
    }

    public boolean hasMoreRecords() throws IOException {
        return !this.atEOF();
    }

    public DbfRecord readNextRecord() throws IOException {
        if (!this.hasMoreRecords()) {
            return null;
        }
        DbfRecord record = new DbfRecord();
        byte[] buf = new byte[this.header.recordSize];
        this.readFully(buf);
        int bufIdx = 0;
        record.deletedFlag = buf[bufIdx++] == 42;
        for (DbfFieldDef def : this.header.fieldDefinitions) {
            Object dataObject = new String(buf, bufIdx, (int)def.fieldSize).trim();
            try {
                switch (def.fieldType) {
                    case 'N': {
                        if (def.fieldDecimalCount == 0) {
                            Integer.valueOf((String)dataObject);
                            break;
                        }
                    }
                    case 'F': {
                        dataObject = Float.valueOf((String)dataObject);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            record.data.add(dataObject);
            bufIdx += def.fieldSize;
        }
        return record;
    }

    protected void readHeader() throws IOException {
        DbfHeader header = new DbfHeader();
        byte versionByte = this.readByte();
        header.version = (short)(versionByte & 0xF);
        header.dateYear = 1900 + this.readUnsignedByte();
        header.dateMonth = this.readUnsignedByte();
        header.dateDay = this.readUnsignedByte();
        header.records = this.readInt();
        header.headerSize = this.readUnsignedShort();
        header.recordSize = this.readUnsignedShort();
        this.skipBytes(2);
        header.incompleteTransactionFlag = this.readByte();
        header.encryptionFlag = this.readByte();
        this.skipBytes(12);
        header.prodMdxFlag = this.readByte();
        header.driverId = this.readByte();
        this.skipBytes(2);
        while (!this.atEOH()) {
            DbfFieldDef fd = this.readFieldDescriptor();
            header.fieldDefinitions.add(fd);
        }
        this.skipBytes(1);
        this.header = header;
    }

    protected DbfFieldDef readFieldDescriptor() throws IOException {
        DbfFieldDef def = new DbfFieldDef();
        byte[] buf = new byte[11];
        this.readFully(buf, 0, 11);
        def.fieldName = new String(buf, 0, 11);
        def.fieldType = (char)this.readByte();
        this.skipBytes(4);
        def.fieldSize = (short)this.readUnsignedByte();
        def.fieldDecimalCount = (short)this.readUnsignedByte();
        this.skipBytes(2);
        def.workAreaId = this.readByte();
        this.skipBytes(10);
        def.mdxFieldFlag = this.readByte();
        return def;
    }

    private boolean nextByteEquals(byte value) throws IOException {
        this.mark(1);
        boolean isEqual = this.readByte() == value;
        this.reset();
        return isEqual;
    }

    private boolean atEOH() throws IOException {
        return this.nextByteEquals((byte)13);
    }

    private boolean atEOF() throws IOException {
        return this.nextByteEquals((byte)26);
    }
}

