/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.generatedfile;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.AptProject;
import org.eclipse.jdt.apt.core.internal.Messages;
import org.eclipse.jdt.apt.core.internal.generatedfile.CompilationUnitHelper;
import org.eclipse.jdt.apt.core.internal.generatedfile.FileGenerationResult;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedFileMap;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedSourceFolderManager;
import org.eclipse.jdt.apt.core.internal.generatedfile.WorkingCopyCleanupListener;
import org.eclipse.jdt.apt.core.internal.util.FileSystemUtil;
import org.eclipse.jdt.apt.core.internal.util.ManyToMany;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;

public class GeneratedFileManager {
    private static final boolean RECURSIVE_RECONCILE = true;
    private static final boolean GENERATE_TYPE_DURING_RECONCILE = true;
    private static final boolean ENABLE_INTEGRITY_CHECKS = true;
    private static final CompilationUnitHelper _CUHELPER = new CompilationUnitHelper();
    private static final Pattern _PACKAGE_DELIMITER = Pattern.compile("\\.");
    private final GeneratedFileMap _buildDeps;
    private final Set<IFile> _clearDuringReconcile;
    private final ManyToMany<IFile, IFile> _reconcileDeps;
    private final ManyToMany<IFile, IFile> _reconcileNonDeps;
    private final Map<IFile, ICompilationUnit> _hiddenBuiltTypes;
    private final Map<IFile, ICompilationUnit> _reconcileGenTypes;
    private final GeneratedPackageFragmentRoot _generatedPackageFragmentRoot;
    private final IJavaProject _jProject;
    private final GeneratedSourceFolderManager _gsfm;
    private boolean _skipTypeGeneration = false;

    static {
        int mask = 1;
        JavaCore.addElementChangedListener((IElementChangedListener)new WorkingCopyCleanupListener(), (int)mask);
    }

    public GeneratedFileManager(AptProject aptProject, GeneratedSourceFolderManager gsfm) {
        this._jProject = aptProject.getJavaProject();
        this._gsfm = gsfm;
        this._buildDeps = new GeneratedFileMap(this._jProject.getProject(), gsfm.isTestCode());
        this._clearDuringReconcile = new HashSet<IFile>();
        this._reconcileDeps = new ManyToMany();
        this._reconcileNonDeps = new ManyToMany();
        this._hiddenBuiltTypes = new HashMap<IFile, ICompilationUnit>();
        this._reconcileGenTypes = new HashMap<IFile, ICompilationUnit>();
        this._generatedPackageFragmentRoot = new GeneratedPackageFragmentRoot();
    }

    public void addGeneratedFileDependency(Collection<IFile> parentFiles, IFile generatedFile) {
        this.addBuiltFileToMaps(parentFiles, generatedFile, false);
    }

    public void compilationStarted() {
        try {
            IMarker[] markers;
            if (!this._gsfm.isTestCode() && (markers = this._jProject.getProject().findMarkers("org.eclipse.jdt.apt.core.configproblem", true, 2)) != null) {
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    marker.delete();
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            AptPlugin.log(e, "Unable to delete configuration marker.");
        }
        this._skipTypeGeneration = false;
        this._gsfm.ensureFolderExists();
        this._generatedPackageFragmentRoot.set();
    }

    public synchronized boolean containsWorkingCopyMapEntriesForParent(IFile f) {
        return this._reconcileDeps.containsKey(f);
    }

    public Set<IFile> deleteObsoleteFilesAfterBuild(IFile parentFile, Set<IFile> newlyGeneratedFiles) {
        ArrayList<ICompilationUnit> toDiscard = new ArrayList<ICompilationUnit>();
        HashSet<IFile> toReport = new HashSet<IFile>();
        Set<IFile> deleted = this.computeObsoleteFiles(parentFile, newlyGeneratedFiles, toDiscard, toReport);
        for (IFile toDelete : deleted) {
            if (AptPlugin.DEBUG_GFM) {
                AptPlugin.trace("deleted obsolete file during build: " + toDelete);
            }
            this.deletePhysicalFile(toDelete);
        }
        for (ICompilationUnit wcToDiscard : toDiscard) {
            _CUHELPER.discardWorkingCopy(wcToDiscard);
        }
        return toReport;
    }

    public void deleteObsoleteTypesAfterReconcile(ICompilationUnit parentWC, Set<IFile> newlyGeneratedFiles) {
        IFile parentFile = (IFile)parentWC.getResource();
        ArrayList<ICompilationUnit> toSetBlank = new ArrayList<ICompilationUnit>();
        ArrayList<ICompilationUnit> toDiscard = new ArrayList<ICompilationUnit>();
        this.computeObsoleteReconcileTypes(parentFile, newlyGeneratedFiles, _CUHELPER, toSetBlank, toDiscard);
        for (ICompilationUnit wcToDiscard : toDiscard) {
            if (AptPlugin.DEBUG_GFM) {
                AptPlugin.trace("discarded obsolete working copy during reconcile: " + wcToDiscard.getElementName());
            }
            _CUHELPER.discardWorkingCopy(wcToDiscard);
        }
        WorkingCopyOwner workingCopyOwner = parentWC.getOwner();
        for (ICompilationUnit wcToSetBlank : toSetBlank) {
            if (AptPlugin.DEBUG_GFM) {
                AptPlugin.trace("hiding file with blank working copy during reconcile: " + wcToSetBlank.getElementName());
            }
            _CUHELPER.updateWorkingCopyContents("", wcToSetBlank, workingCopyOwner, true);
        }
        assert (this.checkIntegrity());
    }

    public void fileDeleted(IFile f) {
        List<IFile> toDelete = this.removeFileFromBuildMaps(f);
        for (IFile fileToDelete : toDelete) {
            this.deletePhysicalFile(fileToDelete);
        }
    }

    public FileGenerationResult generateFileDuringBuild(Collection<IFile> parentFiles, String typeName, String contents, boolean clearDuringReconcile, IProgressMonitor progressMonitor) throws CoreException {
        if (this._skipTypeGeneration) {
            return null;
        }
        GeneratedPackageFragmentRoot.NameAndRoot gpfr = this._generatedPackageFragmentRoot.get();
        IPackageFragmentRoot root = gpfr.root;
        if (root == null) {
            String message = Messages.bind((String)Messages.GeneratedFileManager_missing_classpath_entry, (Object[])new String[]{gpfr.name});
            IMarker marker = this._jProject.getProject().createMarker("org.eclipse.jdt.apt.core.configproblem");
            marker.setAttributes(new String[]{"message", "severity", "sourceId"}, new Object[]{message, 2, "APT"});
            this._skipTypeGeneration = true;
            return null;
        }
        IFile file = this.getIFileForTypeName(typeName);
        boolean contentsDiffer = this.compareFileContents(contents, file);
        try {
            if (contentsDiffer) {
                String[] names = GeneratedFileManager.parseTypeName(typeName);
                String pkgName = names[0];
                String cuName = names[1];
                IFolder genSrcFolder = (IFolder)root.getResource();
                Set<IFolder> newFolders = this.computeNewPackageFolders(pkgName, genSrcFolder);
                IPackageFragment pkgFrag = _CUHELPER.createPackageFragment(pkgName, root, progressMonitor);
                for (IContainer iContainer : newFolders) {
                    try {
                        iContainer.setDerived(true, progressMonitor);
                    }
                    catch (CoreException e) {
                        AptPlugin.logWarning(e, "Unable to mark generated type folder as derived: " + iContainer.getName());
                        break;
                    }
                }
                this.saveCompilationUnit(pkgFrag, cuName, contents, progressMonitor);
            }
            this.addBuiltFileToMaps(parentFiles, file, true);
            if (clearDuringReconcile) {
                this._clearDuringReconcile.add(file);
            }
            if (file.exists()) {
                file.setDerived(true, progressMonitor);
            }
            assert (this.checkIntegrity());
            return new FileGenerationResult(file, contentsDiffer);
        }
        catch (CoreException e) {
            AptPlugin.log(e, "Unable to generate type " + typeName);
            return null;
        }
    }

    public FileGenerationResult generateFileDuringReconcile(ICompilationUnit parentCompilationUnit, String typeName, String contents) throws CoreException {
        IFile parentFile = (IFile)parentCompilationUnit.getResource();
        ICompilationUnit workingCopy = this.getWorkingCopyForReconcile(parentFile, typeName, _CUHELPER);
        boolean modified = _CUHELPER.updateWorkingCopyContents(contents, workingCopy, parentCompilationUnit.getOwner(), true);
        if (AptPlugin.DEBUG_GFM) {
            if (modified) {
                AptPlugin.trace("working copy modified during reconcile: " + typeName);
            } else {
                AptPlugin.trace("working copy unmodified during reconcile: " + typeName);
            }
        }
        IFile generatedFile = (IFile)workingCopy.getResource();
        return new FileGenerationResult(generatedFile, modified);
    }

    public synchronized Set<IFile> getGeneratedFilesForParent(IFile parent) {
        return this._buildDeps.getValues(parent);
    }

    public synchronized boolean isGeneratedFile(IFile f) {
        return this._buildDeps.containsValue(f);
    }

    public synchronized boolean isParentFile(IFile f) {
        return this._buildDeps.containsKey(f);
    }

    public void projectCleaned() {
        List<ICompilationUnit> toDiscard = this.computeClean();
        for (ICompilationUnit wc : toDiscard) {
            _CUHELPER.discardWorkingCopy(wc);
        }
        if (AptPlugin.DEBUG_GFM_MAPS) {
            AptPlugin.trace("cleared build file dependencies");
        }
    }

    public void projectClosed() {
        if (AptPlugin.DEBUG_GFM) {
            AptPlugin.trace("discarding working copy state");
        }
        List<ICompilationUnit> toDiscard = this.computeProjectClosed(false);
        for (ICompilationUnit wc : toDiscard) {
            _CUHELPER.discardWorkingCopy(wc);
        }
    }

    public void projectDeleted() {
        if (AptPlugin.DEBUG_GFM) {
            AptPlugin.trace("discarding all state");
        }
        List<ICompilationUnit> toDiscard = this.computeProjectClosed(true);
        for (ICompilationUnit wc : toDiscard) {
            _CUHELPER.discardWorkingCopy(wc);
        }
    }

    public void reconcileStarted() {
        this._generatedPackageFragmentRoot.set();
    }

    public void workingCopyDiscarded(ICompilationUnit wc) throws CoreException {
        List<ICompilationUnit> toDiscard = this.removeFileFromReconcileMaps((IFile)wc.getResource());
        if (AptPlugin.DEBUG_GFM) {
            AptPlugin.trace("Working copy discarded: " + wc.getElementName() + " removing " + toDiscard.size() + " children");
        }
        for (ICompilationUnit obsoleteWC : toDiscard) {
            _CUHELPER.discardWorkingCopy(obsoleteWC);
        }
    }

    public void writeState() {
        this._buildDeps.writeState();
    }

    private synchronized void addBuiltFileToMaps(Collection<IFile> parentFiles, IFile generatedFile, boolean isSource) {
        for (IFile parentFile : parentFiles) {
            if (parentFile == null) continue;
            boolean added = this._buildDeps.put(parentFile, generatedFile, isSource);
            if (!AptPlugin.DEBUG_GFM_MAPS) continue;
            if (added) {
                AptPlugin.trace("build file dependency added: " + parentFile + " -> " + generatedFile);
                continue;
            }
            AptPlugin.trace("build file dependency already exists: " + parentFile + " -> " + generatedFile);
        }
    }

    private synchronized boolean checkIntegrity() throws IllegalStateException {
        if (!AptPlugin.DEBUG_GFM_MAPS) {
            return true;
        }
        Set<IFile> depChildren = this._reconcileDeps.getValueSet();
        Set<IFile> genTypes = this._reconcileGenTypes.keySet();
        ArrayList<IFile> extraFiles = new ArrayList<IFile>();
        for (IFile f : genTypes) {
            if (depChildren.remove(f)) continue;
            extraFiles.add(f);
        }
        if (!extraFiles.isEmpty()) {
            this.logExtraFiles("File(s) in reconcile-generated list but not in reconcile dependency map: ", extraFiles);
        }
        if (!depChildren.isEmpty()) {
            this.logExtraFiles("File(s) in reconcile dependency map but not in reconcile-generated list: ", depChildren);
        }
        ArrayList<IFile> extraClearDuringReconcileFiles = new ArrayList<IFile>();
        for (IFile clearDuringReconcile : this._clearDuringReconcile) {
            if (this._buildDeps.containsValue(clearDuringReconcile)) continue;
            extraClearDuringReconcileFiles.add(clearDuringReconcile);
        }
        if (!extraClearDuringReconcileFiles.isEmpty()) {
            this.logExtraFiles("File(s) in list to clear during reconcile but not in build dependency map: ", extraClearDuringReconcileFiles);
        }
        ArrayList<IFile> extraHiddenTypes = new ArrayList<IFile>();
        for (IFile hidden : this._hiddenBuiltTypes.keySet()) {
            if (this._reconcileNonDeps.containsValue(hidden)) continue;
            extraHiddenTypes.add(hidden);
        }
        if (!extraHiddenTypes.isEmpty()) {
            this.logExtraFiles("File(s) in hidden types list but not in reconcile-obsoleted list: ", extraHiddenTypes);
        }
        HashMap<IFile, IFile> reconcileOverlaps = new HashMap<IFile, IFile>();
        for (IFile parent : this._reconcileNonDeps.getKeySet()) {
            for (IFile child : this._reconcileNonDeps.getValues(parent)) {
                if (!this._reconcileDeps.containsKeyValuePair(parent, child)) continue;
                reconcileOverlaps.put(parent, child);
            }
        }
        if (!reconcileOverlaps.isEmpty()) {
            this.logExtraFilePairs("Entries exist in both reconcile map and reconcile-obsoleted maps: ", reconcileOverlaps);
        }
        HashMap<IFile, IFile> extraNonDeps = new HashMap<IFile, IFile>();
        for (IFile parent : this._reconcileNonDeps.getKeySet()) {
            for (IFile iFile : this._reconcileNonDeps.getValues(parent)) {
                if (this._buildDeps.containsKeyValuePair(parent, iFile)) continue;
                extraNonDeps.put(parent, iFile);
            }
        }
        if (!extraNonDeps.isEmpty()) {
            this.logExtraFilePairs("Entries exist in reconcile-obsoleted map but not in build map: ", extraNonDeps);
        }
        ArrayList<IFile> nullHiddenTypes = new ArrayList<IFile>();
        for (Map.Entry<IFile, ICompilationUnit> entry : this._hiddenBuiltTypes.entrySet()) {
            if (entry.getValue() != null) continue;
            nullHiddenTypes.add(entry.getKey());
        }
        if (!nullHiddenTypes.isEmpty()) {
            this.logExtraFiles("Null entries in hidden type list: ", nullHiddenTypes);
        }
        ArrayList<IFile> nullReconcileTypes = new ArrayList<IFile>();
        for (Map.Entry entry : this._reconcileGenTypes.entrySet()) {
            if (entry.getValue() != null) continue;
            nullReconcileTypes.add((IFile)entry.getKey());
        }
        if (!nullReconcileTypes.isEmpty()) {
            this.logExtraFiles("Null entries in reconcile type list: ", nullReconcileTypes);
        }
        return true;
    }

    private synchronized List<ICompilationUnit> computeProjectClosed(boolean deleteState) {
        int size = this._hiddenBuiltTypes.size() + this._reconcileGenTypes.size();
        ArrayList<ICompilationUnit> toDiscard = new ArrayList<ICompilationUnit>(size);
        toDiscard.addAll(this._hiddenBuiltTypes.values());
        toDiscard.addAll(this._reconcileGenTypes.values());
        this._reconcileGenTypes.clear();
        this._hiddenBuiltTypes.clear();
        this._reconcileDeps.clear();
        this._reconcileNonDeps.clear();
        if (deleteState) {
            this._buildDeps.clearState();
        } else {
            this._buildDeps.clear();
        }
        this._clearDuringReconcile.clear();
        assert (this.checkIntegrity());
        return toDiscard;
    }

    private boolean compareFileContents(String contents, IFile file) {
        boolean contentsDiffer;
        block24: {
            contentsDiffer = true;
            if (file.exists()) {
                InputStream oldData = null;
                ByteArrayInputStream is = null;
                try {
                    try {
                        is = new ByteArrayInputStream(contents.getBytes());
                        oldData = new BufferedInputStream(file.getContents());
                        contentsDiffer = !FileSystemUtil.compareStreams(oldData, is);
                    }
                    catch (CoreException coreException) {
                        if (oldData != null) {
                            try {
                                oldData.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    if (oldData != null) {
                        try {
                            oldData.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (oldData != null) {
                    try {
                        oldData.close();
                    }
                    catch (IOException iOException) {}
                }
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return contentsDiffer;
    }

    private synchronized List<ICompilationUnit> computeClean() {
        this._buildDeps.clearState();
        this._clearDuringReconcile.clear();
        this._reconcileNonDeps.clear();
        ArrayList<ICompilationUnit> toDiscard = new ArrayList<ICompilationUnit>(this._hiddenBuiltTypes.values());
        this._hiddenBuiltTypes.clear();
        assert (this.checkIntegrity());
        return toDiscard;
    }

    private Set<IFolder> computeNewPackageFolders(String pkgName, IFolder parent) {
        String[] folders;
        HashSet<IFolder> newFolders = new HashSet<IFolder>();
        String[] stringArray = folders = _PACKAGE_DELIMITER.split(pkgName);
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            String folderName = stringArray[n2];
            IFolder folder = parent.getFolder(folderName);
            if (!folder.exists()) {
                newFolders.add(folder);
            }
            parent = folder;
            ++n2;
        }
        return newFolders;
    }

    private synchronized Set<IFile> computeObsoleteFiles(IFile parentFile, Set<IFile> newlyGeneratedFiles, List<ICompilationUnit> toDiscard, Set<IFile> toReport) {
        HashSet<IFile> deleted = new HashSet<IFile>();
        Set obsoleteFiles = this._buildDeps.getValues(parentFile);
        obsoleteFiles.removeAll(newlyGeneratedFiles);
        for (IFile generatedFile : obsoleteFiles) {
            boolean isSource = this._buildDeps.isSource(generatedFile);
            this._buildDeps.remove(parentFile, generatedFile);
            if (AptPlugin.DEBUG_GFM_MAPS) {
                AptPlugin.trace("removed build file dependency: " + parentFile + " -> " + generatedFile);
            }
            if (this._buildDeps.containsValue(generatedFile)) continue;
            deleted.add(generatedFile);
            if (!isSource) continue;
            toReport.add(generatedFile);
        }
        this._clearDuringReconcile.removeAll(deleted);
        toDiscard.addAll(this.computeObsoleteHiddenTypes(parentFile, deleted));
        assert (this.checkIntegrity());
        return deleted;
    }

    private synchronized void computeObsoleteReconcileTypes(IFile parentFile, Set<IFile> newlyGeneratedFiles, CompilationUnitHelper cuh, List<ICompilationUnit> toSetBlank, List<ICompilationUnit> toDiscard) {
        Set<IFile> obsoleteFiles = this._reconcileDeps.getValues(parentFile);
        HashMap<IFile, ICompilationUnit> typesToDiscard = new HashMap<IFile, ICompilationUnit>();
        obsoleteFiles.removeAll(newlyGeneratedFiles);
        for (IFile obsoleteFile : obsoleteFiles) {
            this._reconcileDeps.remove(parentFile, obsoleteFile);
            if (!this._reconcileDeps.getKeys(obsoleteFile).isEmpty()) continue;
            ICompilationUnit wc = this._reconcileGenTypes.remove(obsoleteFile);
            assert (wc != null) : "Value in reconcile deps missing from reconcile type list: " + obsoleteFile;
            typesToDiscard.put(obsoleteFile, wc);
        }
        Set builtChildren = this._buildDeps.getValues(parentFile);
        builtChildren.retainAll(this._clearDuringReconcile);
        builtChildren.removeAll(newlyGeneratedFiles);
        for (IFile builtChild : builtChildren) {
            this._reconcileNonDeps.put(parentFile, builtChild);
            boolean foundOtherParent = false;
            Set parents = this._buildDeps.getKeys(builtChild);
            parents.remove(parentFile);
            for (IFile otherParent : parents) {
                if (this._reconcileNonDeps.containsKeyValuePair(otherParent, builtChild)) continue;
                foundOtherParent = true;
                break;
            }
            if (foundOtherParent) continue;
            ICompilationUnit wc = (ICompilationUnit)typesToDiscard.remove(builtChild);
            if (wc == null) {
                IPackageFragmentRoot root = this._generatedPackageFragmentRoot.get().root;
                String typeName = this.getTypeNameForDerivedFile(builtChild);
                wc = cuh.getWorkingCopy(typeName, root);
            }
            this._hiddenBuiltTypes.put(builtChild, wc);
            toSetBlank.add(wc);
        }
        toDiscard.addAll(typesToDiscard.values());
        assert (this.checkIntegrity());
    }

    private synchronized List<ICompilationUnit> computeObsoleteHiddenTypes(IFile parentFile, Set<IFile> deletedFiles) {
        ArrayList<ICompilationUnit> toDiscard = new ArrayList<ICompilationUnit>();
        for (IFile deletedFile : deletedFiles) {
            ICompilationUnit wc;
            if (!this._reconcileNonDeps.remove(parentFile, deletedFile) || (wc = this._hiddenBuiltTypes.remove(deletedFile)) == null) continue;
            toDiscard.add(wc);
        }
        assert (this.checkIntegrity());
        return toDiscard;
    }

    private void deletePhysicalFile(IFile file) {
        IFolder genFolder = this._gsfm.getFolder();
        assert (genFolder != null) : "Generated folder == null";
        IContainer parent = file.getParent();
        try {
            if (AptPlugin.DEBUG_GFM) {
                AptPlugin.trace("delete physical file: " + file);
            }
            file.delete(true, true, null);
        }
        catch (CoreException e) {
            AptPlugin.logWarning(e, "Unable to delete generated file: " + file);
        }
        while (!genFolder.equals((Object)parent) && parent != null && parent.isDerived()) {
            IResource[] members = null;
            try {
                members = parent.members();
            }
            catch (CoreException e) {
                AptPlugin.logWarning(e, "Unable to read contents of generated file folder " + parent);
            }
            IContainer grandParent = parent.getParent();
            if (members != null && members.length != 0) break;
            try {
                parent.delete(true, null);
            }
            catch (CoreException e) {
                AptPlugin.logWarning(e, "Unable to delete generated file folder " + parent);
            }
            parent = grandParent;
        }
    }

    public IFile getIFileForTypeName(String typeName) {
        String[] parts = _PACKAGE_DELIMITER.split(typeName);
        IFolder folder = this._gsfm.getFolder();
        int i = 0;
        while (i < parts.length - 1) {
            folder = folder.getFolder(parts[i]);
            ++i;
        }
        String fileName = String.valueOf(parts[parts.length - 1]) + ".java";
        IFile file = folder.getFile(fileName);
        return file;
    }

    private String getTypeNameForDerivedFile(IFile f) {
        IPath p = f.getFullPath();
        IFolder folder = this._gsfm.getFolder();
        IPath generatedSourcePath = folder.getFullPath();
        int count = p.matchingFirstSegments(generatedSourcePath);
        p = p.removeFirstSegments(count);
        String s = p.toPortableString();
        int idx = s.lastIndexOf(46);
        s = p.toPortableString().replace('/', '.');
        return s.substring(0, idx);
    }

    private synchronized ICompilationUnit getWorkingCopyForReconcile(IFile parentFile, String typeName, CompilationUnitHelper cuh) {
        IPackageFragmentRoot root = this._generatedPackageFragmentRoot.get().root;
        IFile generatedFile = this.getIFileForTypeName(typeName);
        ICompilationUnit workingCopy = this._hiddenBuiltTypes.remove(generatedFile);
        if (workingCopy != null) {
            this._reconcileNonDeps.remove(parentFile, generatedFile);
            this._reconcileGenTypes.put(generatedFile, workingCopy);
            this._reconcileDeps.put(parentFile, generatedFile);
            if (AptPlugin.DEBUG_GFM_MAPS) {
                AptPlugin.trace("moved working copy from hidden to regular list: " + generatedFile);
            }
        } else {
            workingCopy = this._reconcileGenTypes.get(generatedFile);
            if (workingCopy != null) {
                if (AptPlugin.DEBUG_GFM_MAPS) {
                    AptPlugin.trace("obtained existing working copy from regular list: " + generatedFile);
                }
            } else {
                workingCopy = cuh.getWorkingCopy(typeName, root);
                this._reconcileDeps.put(parentFile, generatedFile);
                this._reconcileGenTypes.put(generatedFile, workingCopy);
                if (AptPlugin.DEBUG_GFM_MAPS) {
                    AptPlugin.trace("added new working copy to regular list: " + generatedFile);
                }
            }
        }
        assert (this.checkIntegrity());
        return workingCopy;
    }

    private boolean hasNoOtherReconcileParents(IFile child, IFile parent) {
        if (this._reconcileDeps.valueHasOtherKeys(child, parent)) {
            return true;
        }
        Set buildParents = this._buildDeps.getKeys(child);
        buildParents.remove(parent);
        buildParents.removeAll(this._reconcileNonDeps.getKeys(child));
        return buildParents.isEmpty();
    }

    private void logExtraFilePairs(String message, Map<IFile, IFile> pairs) {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        Iterator<Map.Entry<IFile, IFile>> iter = pairs.entrySet().iterator();
        while (true) {
            Map.Entry<IFile, IFile> entry = iter.next();
            sb.append(entry.getKey().getName());
            sb.append("->");
            sb.append(entry.getValue().getName());
            if (!iter.hasNext()) break;
            sb.append(", ");
        }
        String s = sb.toString();
        AptPlugin.log(new IllegalStateException(s), s);
    }

    private void logExtraFiles(String message, Iterable<IFile> files) {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        Iterator<IFile> iter = files.iterator();
        while (true) {
            sb.append(iter.next().getName());
            if (!iter.hasNext()) break;
            sb.append(", ");
        }
        String s = sb.toString();
        AptPlugin.log(new IllegalStateException(s), s);
    }

    private static String[] parseTypeName(String qualifiedName) {
        String fname;
        String pkgName;
        if (qualifiedName.indexOf(47) != -1) {
            qualifiedName = qualifiedName.replace('/', '.');
        }
        String[] names = new String[2];
        int idx = qualifiedName.lastIndexOf(46);
        if (idx > 0) {
            pkgName = qualifiedName.substring(0, idx);
            fname = String.valueOf(qualifiedName.substring(idx + 1, qualifiedName.length())) + ".java";
        } else {
            pkgName = "";
            fname = String.valueOf(qualifiedName) + ".java";
        }
        names[0] = pkgName;
        names[1] = fname;
        return names;
    }

    private synchronized List<IFile> removeFileFromBuildMaps(IFile f) {
        ArrayList<IFile> toDelete = new ArrayList<IFile>();
        Set childFiles = this._buildDeps.getValues(f);
        for (IFile childFile : childFiles) {
            Set parentFiles = this._buildDeps.getKeys(childFile);
            if (parentFiles.size() != 1 || !parentFiles.contains(f)) continue;
            toDelete.add(childFile);
        }
        boolean removed = this._buildDeps.removeKey(f);
        if (removed && AptPlugin.DEBUG_GFM_MAPS) {
            AptPlugin.trace("removed parent file from build dependencies: " + f);
        }
        assert (this.checkIntegrity());
        return toDelete;
    }

    private synchronized List<ICompilationUnit> removeFileFromReconcileMaps(IFile file) {
        ArrayList<ICompilationUnit> toDiscard = new ArrayList<ICompilationUnit>();
        Set<IFile> genFiles = this._reconcileDeps.getValues(file);
        for (IFile child : genFiles) {
            if (!this.hasNoOtherReconcileParents(child, file)) continue;
            ICompilationUnit childWC = this._reconcileGenTypes.remove(child);
            assert (childWC != null) : "Every value in _reconcileDeps must be a key in _reconcileGenTypes";
            toDiscard.add(childWC);
        }
        this._reconcileDeps.removeKey(file);
        Set<IFile> nonGenFiles = this._reconcileNonDeps.getValues(file);
        for (IFile child : nonGenFiles) {
            ICompilationUnit hidingWC = this._hiddenBuiltTypes.remove(child);
            if (hidingWC == null) continue;
            toDiscard.add(hidingWC);
        }
        this._reconcileNonDeps.removeKey(file);
        assert (this.checkIntegrity());
        return toDiscard;
    }

    private void saveCompilationUnit(IPackageFragment pkgFrag, String cuName, String contents, IProgressMonitor progressMonitor) {
        ICompilationUnit unit = pkgFrag.getCompilationUnit(cuName);
        boolean isWorkingCopy = unit.isWorkingCopy();
        if (isWorkingCopy) {
            try {
                _CUHELPER.commitNewContents(unit, contents, progressMonitor);
                if (AptPlugin.DEBUG_GFM) {
                    AptPlugin.trace("Committed existing working copy during build: " + unit.getElementName());
                }
            }
            catch (JavaModelException e) {
                if (e.getJavaModelStatus().getCode() == 995) {
                    _CUHELPER.discardWorkingCopy(unit);
                    isWorkingCopy = false;
                    if (AptPlugin.DEBUG_GFM) {
                        AptPlugin.trace("Discarded invalid existing working copy in order to try again: " + unit.getElementName());
                    }
                }
                AptPlugin.log(e, "Unable to commit working copy to disk: " + unit.getElementName());
                return;
            }
        }
        if (!isWorkingCopy) {
            try {
                unit = pkgFrag.createCompilationUnit(cuName, contents, true, progressMonitor);
                if (AptPlugin.DEBUG_GFM) {
                    AptPlugin.trace("Created compilation unit during build: " + unit.getElementName());
                }
            }
            catch (JavaModelException e) {
                AptPlugin.log(e, "Unable to create compilation unit on disk: " + cuName + " in pkg fragment: " + pkgFrag.getElementName());
            }
        }
    }

    private class GeneratedPackageFragmentRoot {
        private IPackageFragmentRoot _root = null;
        private String _folderName = null;

        private GeneratedPackageFragmentRoot() {
        }

        public synchronized NameAndRoot get() {
            return new NameAndRoot(this._folderName, this._root);
        }

        public synchronized void set() {
            IFolder genFolder = GeneratedFileManager.this._gsfm.getFolder();
            this._root = null;
            if (GeneratedFileManager.this._jProject.isOnClasspath((IResource)genFolder)) {
                this._root = GeneratedFileManager.this._jProject.getPackageFragmentRoot((IResource)genFolder);
            }
            this._folderName = genFolder.getProjectRelativePath().toString();
        }

        final class NameAndRoot {
            final String name;
            final IPackageFragmentRoot root;

            NameAndRoot(String name, IPackageFragmentRoot root) {
                this.name = name;
                this.root = root;
            }
        }
    }
}

