/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.swt.widgets.Widget;

public class TaskBar
extends Widget {
    int itemCount;
    TaskItem[] items = new TaskItem[4];

    TaskBar(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.display = display;
        this.reskinWidget();
    }

    void createItem(TaskItem item, int index) {
        if (index == -1) {
            index = this.itemCount;
        }
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            TaskItem[] newItems = new TaskItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item;
    }

    void createItems() {
    }

    void destroyItem(TaskItem item) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
    }

    public TaskItem getItem(int index) {
        this.checkWidget();
        this.createItems();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        this.createItems();
        return this.itemCount;
    }

    public TaskItem getItem(Shell shell) {
        this.checkWidget();
        return null;
    }

    public TaskItem[] getItems() {
        this.checkWidget();
        this.createItems();
        TaskItem[] result = new TaskItem[this.itemCount];
        System.arraycopy(this.items, 0, result, 0, result.length);
        return result;
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                TaskItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void reskinChildren(int flags) {
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                TaskItem item = this.items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }
}

