/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.adapters.relativevalue.history;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.adapters.history.HistoryExtendedListener;
import org.eclipse.stem.adapters.history.HistoryProviderAdapter;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryExtendedListener;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProvider;

public abstract class RelativeValueHistoryProviderAdapter
extends RelativeValueProviderAdapter
implements RelativeValueHistoryProvider,
HistoryExtendedListener {
    private List<RelativeValueHistoryExtendedListener> extensionListeners = new CopyOnWriteArrayList<RelativeValueHistoryExtendedListener>();
    private static final int earliestCycleNumber = 0;

    @Override
    public double getRelativeValue(ItemPropertyDescriptor property, STEMTime time) {
        return this.getRelativeValue((EStructuralFeature)property.getFeature(null), time);
    }

    @Override
    public abstract double getRelativeValue(EStructuralFeature var1, STEMTime var2);

    @Override
    public abstract double[] getAllHistoricRelativeValues(EStructuralFeature var1);

    @Override
    public double[] getAllHistoricRelativeValues(ItemPropertyDescriptor property) {
        return this.getAllHistoricRelativeValues((EStructuralFeature)property.getFeature(null));
    }

    @Override
    public abstract STEMTime[] getAllHistoricTimeValues();

    @Override
    public abstract STEMTime getEarliestTimeValue();

    @Override
    public int getEarliestCycleNumber() {
        return 0;
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return type == RelativeValueHistoryProvider.class;
    }

    public void historyExtended(HistoryProviderAdapter historyProviderAdapter) {
        this.fireHistoryExtended();
    }

    public void addExtensionListener(RelativeValueHistoryExtendedListener listener) {
        this.extensionListeners.add(listener);
    }

    public void removeExtensionListener(RelativeValueHistoryExtendedListener listener) {
        this.extensionListeners.remove(listener);
    }

    protected void fireHistoryExtended() {
        for (RelativeValueHistoryExtendedListener listener : this.extensionListeners) {
            listener.relativeValueHistoryExtended(this);
        }
    }
}

