/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.editors.forms.nebula.sections;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.XViewerFactory;
import org.eclipse.nebula.widgets.xviewer.XViewerSorter;
import org.eclipse.nebula.widgets.xviewer.XViewerTextFilter;
import org.eclipse.nebula.widgets.xviewer.edit.XViewerEditAdapter;
import org.eclipse.sphinx.emf.editors.forms.BasicTransactionalFormEditor;
import org.eclipse.sphinx.emf.editors.forms.nebula.internal.Activator;
import org.eclipse.sphinx.emf.editors.forms.nebula.providers.BasicModelXViewerLabelProvider;
import org.eclipse.sphinx.emf.editors.forms.pages.AbstractFormPage;
import org.eclipse.sphinx.emf.editors.forms.sections.AbstractViewerFormSection;
import org.eclipse.sphinx.platform.ui.util.SelectionUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;

public class BasicXViewerSection
extends AbstractViewerFormSection {
    protected EObject exampleValue;
    protected XViewerFactory xViewerFactory;
    protected GridData layoutData;

    public BasicXViewerSection(AbstractFormPage formPage, Object sectionInput, EObject exampleValue) {
        this(formPage, sectionInput, exampleValue, 384);
    }

    public BasicXViewerSection(AbstractFormPage formPage, Object sectionInput, EObject exampleValue, int style) {
        super(formPage, sectionInput, style);
        Assert.isNotNull((Object)exampleValue);
        this.exampleValue = exampleValue;
    }

    public BasicXViewerSection(AbstractFormPage formPage, Object sectionInput, XViewerFactory xViewerFactory) {
        this(formPage, sectionInput, xViewerFactory, 384);
    }

    public BasicXViewerSection(AbstractFormPage formPage, Object sectionInput, XViewerFactory xViewerFactory, int style) {
        super(formPage, sectionInput, style);
        Assert.isNotNull((Object)xViewerFactory);
        this.xViewerFactory = xViewerFactory;
    }

    public GridData getLayoutData() {
        if (this.layoutData == null) {
            this.layoutData = new GridData(4, 4, true, true);
        }
        return this.layoutData;
    }

    public void setLayoutData(GridData layoutData) {
        this.layoutData = layoutData;
    }

    protected int getNumberOfColumns() {
        return 1;
    }

    protected void createSectionClientContent(IManagedForm managedForm, SectionPart sectionPart, Composite sectionClient) {
        Assert.isNotNull((Object)managedForm);
        Assert.isNotNull((Object)sectionPart);
        Assert.isNotNull((Object)sectionClient);
        if (this.xViewerFactory == null) {
            this.xViewerFactory = this.createXViewerFactory();
            this.registerColumns(this.xViewerFactory);
        }
        XViewer xViewer = this.createXViewer(sectionClient, this.xViewerFactory);
        xViewer.getTree().setLayoutData((Object)this.getLayoutData());
        this.setViewer((Viewer)xViewer);
        xViewer.setContentProvider(this.createContentProvider());
        xViewer.setLabelProvider(this.createLabelProvider());
        xViewer.setInput(this.sectionInput);
    }

    protected XViewerFactory createXViewerFactory() {
        XViewerFactory xViewerFactory = new XViewerFactory(this.exampleValue.eClass().getName()){

            public boolean isAdmin() {
                return true;
            }

            public XViewerSorter createNewXSorter(XViewer xViewer) {
                return new XViewerSorter(xViewer){

                    public int getCompareForDate(String date1, Object obj1, String date2, Object obj2) {
                        if (date1 != null && obj1 == null && date2 != null && obj2 == null) {
                            Date date1Date = null;
                            try {
                                date1Date = BasicXViewerSection.this.getDateFormat().parse(date1);
                            }
                            catch (ParseException ex) {
                                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                                return 0;
                            }
                            Date date2Date = null;
                            try {
                                date2Date = BasicXViewerSection.this.getDateFormat().parse(date2);
                            }
                            catch (ParseException ex) {
                                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                                return 0;
                            }
                            return this.getCompareForDate(date1Date, date2Date);
                        }
                        return super.getCompareForDate(date1, obj1, date2, obj2);
                    }
                };
            }
        };
        return xViewerFactory;
    }

    protected DateFormat getDateFormat() {
        return new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.US);
    }

    protected XViewer createXViewer(Composite sectionClient, XViewerFactory xViewerFactory) {
        final BasicTransactionalFormEditor formEditor = this.formPage.getTransactionalFormEditor();
        XViewer xViewer = new XViewer(sectionClient, 68354, (IXViewerFactory)xViewerFactory){

            public void setSelection(ISelection selection) {
                selection = !SelectionUtil.getStructuredSelection((ISelection)selection).isEmpty() ? selection : formEditor.getDefaultSelection();
                super.setSelection(selection);
            }

            public XViewerTextFilter getXViewerTextFilter() {
                return BasicXViewerSection.this.createXViewerTextFilter(this);
            }
        };
        XViewerEditAdapter xViewerEditAdapter = this.createXViewerEditAdapter();
        if (xViewerEditAdapter != null) {
            xViewer.setXViewerEditAdapter(xViewerEditAdapter);
        }
        return xViewer;
    }

    protected XViewerTextFilter createXViewerTextFilter(XViewer xViewer) {
        return new XViewerTextFilter(xViewer);
    }

    protected XViewerEditAdapter createXViewerEditAdapter() {
        return null;
    }

    protected void registerColumns(XViewerFactory xViewerFactory) {
        List propertyDescriptors = this.formPage.getItemDelegator().getPropertyDescriptors((Object)this.exampleValue);
        for (IItemPropertyDescriptor propertyDescriptor : propertyDescriptors) {
            xViewerFactory.registerColumns(new XViewerColumn[]{new XViewerColumn(propertyDescriptor.getId((Object)this.exampleValue).toString(), propertyDescriptor.getDisplayName((Object)this.exampleValue), 100, 16384, true, this.getSortDataType(propertyDescriptor, this.exampleValue), false, propertyDescriptor.getDescription((Object)this.exampleValue))});
        }
    }

    protected XViewerColumn.SortDataType getSortDataType(IItemPropertyDescriptor propertyDescriptor, Object object) {
        Assert.isNotNull((Object)propertyDescriptor);
        Assert.isNotNull((Object)object);
        EClassifier propertyType = ((EStructuralFeature)propertyDescriptor.getFeature(object)).getEType();
        if (propertyType == EcorePackage.eINSTANCE.getEDate()) {
            return XViewerColumn.SortDataType.Date;
        }
        if (propertyType == EcorePackage.eINSTANCE.getEFloat() || propertyType == EcorePackage.eINSTANCE.getEDouble()) {
            return XViewerColumn.SortDataType.Float;
        }
        if (propertyType == EcorePackage.eINSTANCE.getEBoolean()) {
            return XViewerColumn.SortDataType.Check;
        }
        if (propertyType == EcorePackage.eINSTANCE.getEInt()) {
            return XViewerColumn.SortDataType.Integer;
        }
        if (propertyDescriptor.isMultiLine(object)) {
            return XViewerColumn.SortDataType.String_MultiLine;
        }
        return XViewerColumn.SortDataType.String;
    }

    protected IBaseLabelProvider createLabelProvider() {
        return new BasicModelXViewerLabelProvider((XViewer)this.getViewer(), this.formPage.getItemDelegator());
    }
}

