/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.groups;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.sphinx.platform.ui.fields.IField;
import org.eclipse.sphinx.platform.ui.groups.IGroup;
import org.eclipse.sphinx.platform.ui.groups.IGroupListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public abstract class AbstractGroup
implements IGroup {
    protected String groupName;
    private IDialogSettings dialogSettings = null;
    private ListenerList groupListeners = new ListenerList();

    public AbstractGroup(String groupName) {
        this(groupName, null);
    }

    public AbstractGroup(String groupName, IDialogSettings dialogSettings) {
        this.groupName = groupName;
        this.dialogSettings = dialogSettings;
    }

    @Override
    public void createContent(Composite parent, int numColumns) {
        this.createContent(parent, numColumns, false);
    }

    @Override
    public void createContent(Composite parent, int numColumns, boolean suppressGroupFrame) {
        Composite parentComposite;
        if (suppressGroupFrame) {
            parentComposite = new Composite(parent, 32);
        } else {
            Group group = new Group(parent, 32);
            group.setText(this.groupName);
            parentComposite = group;
        }
        parentComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.doCreateContent(parentComposite, numColumns);
        this.loadGroupSettings();
    }

    protected abstract void doCreateContent(Composite var1, int var2);

    protected void notifyGroupChanged(IField field) {
        Object[] objectArray = this.groupListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IGroupListener)listener).groupChanged(field);
            ++n2;
        }
    }

    protected void loadGroupSettings() {
    }

    public void saveGroupSettings() {
    }

    @Override
    public final void addGroupListener(IGroupListener listener) {
        this.groupListeners.add((Object)listener);
    }

    @Override
    public void removeGroupListener(IGroupListener listener) {
        this.groupListeners.remove((Object)listener);
    }

    @Override
    public boolean isGroupComplete() {
        return true;
    }

    public void setDialogSettings(IDialogSettings dialogSettings) {
        this.dialogSettings = dialogSettings;
    }

    protected IDialogSettings getDialogSettings() {
        return this.dialogSettings;
    }
}

