/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.dynamic.headless;

import java.io.FileNotFoundException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.mwe.dynamic.headless.IWorkflowRunnerCLIConstants;
import org.eclipse.sphinx.emf.mwe.dynamic.headless.internal.messages.Messages;
import org.eclipse.sphinx.emf.mwe.dynamic.operations.BasicWorkflowRunnerOperation;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.platform.cli.AbstractCLIApplication;
import org.eclipse.sphinx.platform.cli.ICommonCLIConstants;

public class BasicWorkflowRunnerApplication
extends AbstractCLIApplication {
    private static final Pattern JAVA_CLASS_NAME_PATTERN = Pattern.compile("((?:\\w|\\.)+)(\\.)([A-Z](?:\\w)+)");
    protected Resource modelResource = null;

    protected String getCommandLineSyntax() {
        return String.format(ICommonCLIConstants.COMMAND_LINE_SYNTAX_FORMAT_WITH_WORKSPACE, IWorkflowRunnerCLIConstants.APPLICATION_NAME);
    }

    protected void defineOptions() {
        super.defineOptions();
        OptionBuilder.isRequired();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)IWorkflowRunnerCLIConstants.OPTION_WORKFLOW_ARG_NAME);
        OptionBuilder.withDescription((String)IWorkflowRunnerCLIConstants.OPTION_WORKFLOW_DESCRIPTION);
        this.addOption(OptionBuilder.create((String)"workflow"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)IWorkflowRunnerCLIConstants.OPTION_MODEL_ARG_NAME);
        OptionBuilder.withDescription((String)IWorkflowRunnerCLIConstants.OPTION_MODEL_DESCRIPTION);
        this.addOption(OptionBuilder.create((String)"model"));
        this.addOption(new Option("skipSave", IWorkflowRunnerCLIConstants.OPTION_SKIP_SAVE_DESCRIPTION));
    }

    protected Object interrogate() throws Throwable {
        URI uri;
        super.interrogate();
        CommandLine commandLine = this.getCommandLine();
        String workflowOptionValue = commandLine.getOptionValue("workflow");
        String modelOptionValue = commandLine.getOptionValue("model");
        boolean skipSaveOption = commandLine.hasOption("skipSave");
        URI modelURI = this.getModelURI(modelOptionValue);
        if (modelURI != null && !EcoreResourceUtil.exists((URI)(uri = modelURI.trimFragment()))) {
            throw new FileNotFoundException(NLS.bind((String)Messages.cliError_modelResourceDoesNotExist, (Object)uri.toPlatformString(true)));
        }
        Object workflow = this.getWorkflow(workflowOptionValue);
        BasicWorkflowRunnerOperation operation = this.createWorkflowRunnerOperation(workflow);
        if (modelURI != null) {
            operation.getModelURIs().add(modelURI);
        }
        operation.setAutoSave(!skipSaveOption);
        operation.run(this.createProgressMonitor());
        return ERROR_NO;
    }

    protected Object getWorkflow(String workflowOptionValue) throws ClassNotFoundException, FileNotFoundException {
        Assert.isNotNull((Object)workflowOptionValue);
        Matcher matcher = JAVA_CLASS_NAME_PATTERN.matcher(workflowOptionValue);
        if (matcher.find()) {
            try {
                return Class.forName(workflowOptionValue);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ClassNotFoundException(NLS.bind((String)Messages.cliError_workflowClassNotFound, (Object)workflowOptionValue));
            }
        }
        Path workflowPath = new Path(workflowOptionValue);
        IFile workflowFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)workflowPath);
        if (!workflowFile.exists()) {
            IPath workflowLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append((IPath)workflowPath);
            throw new FileNotFoundException(NLS.bind((String)Messages.cliError_workflowFileDoesNotExist, (Object)workflowLocation.toOSString()));
        }
        return workflowFile;
    }

    protected URI getModelURI(String modelOptionValue) {
        return modelOptionValue != null ? EcorePlatformUtil.createURI((IPath)new Path(modelOptionValue).makeAbsolute()) : null;
    }

    protected BasicWorkflowRunnerOperation createWorkflowRunnerOperation(Object workflow) {
        return new BasicWorkflowRunnerOperation(IWorkflowRunnerCLIConstants.APPLICATION_NAME, workflow);
    }

    protected IProgressMonitor createProgressMonitor() {
        return new NullProgressMonitor();
    }
}

