/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.decorators;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.sphinx.emf.workspace.ui.decorators.TreeItemDecorationCalculator;
import org.eclipse.sphinx.emf.workspace.ui.internal.Activator;
import org.eclipse.sphinx.platform.resources.IProblemMarkerFinder;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.decorators.DecorationBuilder;

public abstract class AbstractTreeContentProblemDecorator
implements ILightweightLabelDecorator {
    protected TreeItemDecorationCalculator decorationCalculator;
    protected IResourceChangeListener problemMarkerChangeListener;

    public AbstractTreeContentProblemDecorator() {
        IProblemMarkerFinder problemMarkerFinder = this.createProblemMarkerFinder();
        this.decorationCalculator = this.createDecorationCalculator(problemMarkerFinder);
        this.problemMarkerChangeListener = this.createProblemMarkerChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.problemMarkerChangeListener, 1);
    }

    protected abstract IProblemMarkerFinder createProblemMarkerFinder();

    protected TreeItemDecorationCalculator createDecorationCalculator(IProblemMarkerFinder problemMarkerFinder) {
        return new TreeItemDecorationCalculator(problemMarkerFinder);
    }

    protected IResourceChangeListener createProblemMarkerChangeListener() {
        return new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                Assert.isNotNull((Object)event);
                IMarkerDelta[] markerDelta = event.findMarkerDeltas("org.eclipse.core.resources.problemmarker", true);
                if (markerDelta != null && markerDelta.length > 0) {
                    AbstractTreeContentProblemDecorator.this.decorationCalculator.reset();
                }
            }
        };
    }

    public void decorate(Object element, IDecoration decoration) {
        ITreeContentProvider contentProvider = this.getContentProvider(decoration);
        if (contentProvider != null) {
            String overlayImageName = null;
            TreeItemDecorationCalculator.DecorationOverlayKind overlayKind = this.decorationCalculator.getDecorationOverlayKind(contentProvider, element);
            switch (overlayKind) {
                case NONE: {
                    break;
                }
                case WARNING: {
                    overlayImageName = "IMG_DEC_FIELD_WARNING";
                    break;
                }
                case ERROR: {
                    overlayImageName = "IMG_DEC_FIELD_ERROR";
                    break;
                }
                default: {
                    PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)new RuntimeException("Invalid decoration overlay kind: " + (Object)((Object)overlayKind)));
                }
            }
            if (overlayImageName != null) {
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                ImageDescriptor overlayImageDescriptor = sharedImages.getImageDescriptor(overlayImageName);
                decoration.addOverlay(overlayImageDescriptor, 2);
            }
        }
    }

    protected ITreeContentProvider getContentProvider(IDecoration decoration) {
        if (decoration instanceof DecorationBuilder) {
            DecorationBuilder builder = (DecorationBuilder)decoration;
            IDecorationContext context = builder.getDecorationContext();
            return (ITreeContentProvider)context.getProperty(ITreeContentProvider.class.getName());
        }
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.problemMarkerChangeListener);
    }
}

