/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.viewers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.sphinx.emf.workspace.ui.viewers.ITreeContentIterator;

public class TreeContentProviderIterator
extends AbstractTreeIterator<Object>
implements ITreeContentIterator {
    private static final long serialVersionUID = 1L;
    private ITreeContentProvider contentProvider;
    private ITreeContentIterator.IItemFilter itemFilter;
    private Object currentItem = null;
    private Set<Object> visitedUnderlyingObjects = new HashSet<Object>();
    private Set<Object> recurrentItems = new HashSet<Object>();

    public TreeContentProviderIterator(ITreeContentProvider contentProvider, Object item) {
        this(contentProvider, item, null);
    }

    public TreeContentProviderIterator(ITreeContentProvider contentProvider, Object item, ITreeContentIterator.IItemFilter itemFilter) {
        super(item);
        Assert.isNotNull((Object)contentProvider);
        this.contentProvider = contentProvider;
        this.itemFilter = itemFilter;
    }

    public Object next() {
        this.currentItem = super.next();
        return this.currentItem;
    }

    protected Iterator<Object> getChildren(Object parentItem) {
        if (this.recurrentItems.contains(parentItem)) {
            return Collections.emptyList().iterator();
        }
        Object underlyingParentObject = AdapterFactoryEditingDomain.unwrap((Object)parentItem);
        this.visitedUnderlyingObjects.add(underlyingParentObject);
        ArrayList<Object> childItems = new ArrayList<Object>();
        Object[] objectArray = this.contentProvider.getChildren(parentItem);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object childItem = objectArray[n2];
            if (this.itemFilter == null || this.itemFilter.accept(childItem)) {
                Object underlyingChildObject = AdapterFactoryEditingDomain.unwrap((Object)childItem);
                if (!this.visitedUnderlyingObjects.add(underlyingChildObject)) {
                    this.recurrentItems.add(childItem);
                }
                childItems.add(childItem);
            }
            ++n2;
        }
        return childItems.iterator();
    }

    @Override
    public boolean isRecurrent() {
        return this.recurrentItems.contains(this.currentItem);
    }
}

