/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.dynamic;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflow;
import org.eclipse.sphinx.emf.mwe.dynamic.IWorkflowHandler;
import org.eclipse.sphinx.emf.mwe.dynamic.internal.Activator;
import org.eclipse.sphinx.emf.mwe.dynamic.internal.WorkflowHandlerDescriptor;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class WorkflowHandlerRegistry {
    private static final String EXTP_WORKFLOW_HANDLERS = String.valueOf(Activator.INSTANCE.getSymbolicName()) + ".workflowHandlers";
    private static final String ELEM_HANDLER = "handler";
    private static final String ATTR_CLASS = "class";
    private IExtensionRegistry extensionRegistry;
    private ILog log;
    private Set<WorkflowHandlerDescriptor> workflowHandlerDescriptors;
    private Map<Class<IWorkflow>, List<IWorkflowHandler>> workflowClassToWorkflowHandlerDescriptorsMap;
    public static final WorkflowHandlerRegistry INSTANCE = new WorkflowHandlerRegistry(Platform.getExtensionRegistry(), PlatformLogUtil.getLog((Plugin)Activator.getPlugin()));

    private WorkflowHandlerRegistry(IExtensionRegistry extensionRegistry, ILog log) {
        Assert.isNotNull((Object)extensionRegistry);
        Assert.isNotNull((Object)log);
        this.extensionRegistry = extensionRegistry;
        this.log = log;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this.extensionRegistry == null) {
            return;
        }
        if (this.workflowHandlerDescriptors == null) {
            WorkflowHandlerRegistry workflowHandlerRegistry = this;
            synchronized (workflowHandlerRegistry) {
                IConfigurationElement[] elements;
                this.workflowHandlerDescriptors = new HashSet<WorkflowHandlerDescriptor>();
                this.workflowClassToWorkflowHandlerDescriptorsMap = new HashMap<Class<IWorkflow>, List<IWorkflowHandler>>();
                IConfigurationElement[] iConfigurationElementArray = elements = this.extensionRegistry.getConfigurationElementsFor(EXTP_WORKFLOW_HANDLERS);
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    if (element.getName().equals(ELEM_HANDLER)) {
                        String handlerClass = element.getAttribute(ATTR_CLASS);
                        if (handlerClass == null || handlerClass.isEmpty()) {
                            String msg = "Missing handler class in " + EXTP_WORKFLOW_HANDLERS + " extension from " + element.getContributor().getName();
                            IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)new RuntimeException(msg));
                            this.log.log(status);
                        } else {
                            this.workflowHandlerDescriptors.add(new WorkflowHandlerDescriptor(element));
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    public List<IWorkflowHandler> getSortedHandlers(Class<? extends IWorkflow> workflowClass) {
        List<IWorkflowHandler> result = this.workflowClassToWorkflowHandlerDescriptorsMap.get(workflowClass);
        if (result == null) {
            result = new ArrayList<IWorkflowHandler>();
            List<WorkflowHandlerDescriptor> handlerDescriptors = this.getHandlerDescriptors(workflowClass);
            Collections.sort(handlerDescriptors, new Comparator<WorkflowHandlerDescriptor>(){

                @Override
                public int compare(WorkflowHandlerDescriptor desc1, WorkflowHandlerDescriptor desc2) {
                    return Ints.compare((int)desc1.getPriority(), (int)desc2.getPriority());
                }
            });
            for (WorkflowHandlerDescriptor handlerDesc : handlerDescriptors) {
                try {
                    result.add((IWorkflowHandler)handlerDesc.getInstance());
                }
                catch (Exception ex) {
                    IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                    this.log.log(status);
                }
            }
        }
        return result;
    }

    private List<WorkflowHandlerDescriptor> getHandlerDescriptors(Class<? extends IWorkflow> workflowClass) {
        ArrayList<WorkflowHandlerDescriptor> result = new ArrayList<WorkflowHandlerDescriptor>();
        for (WorkflowHandlerDescriptor handlerDesc : this.workflowHandlerDescriptors) {
            if (!handlerDesc.isApplicableFor(workflowClass)) continue;
            result.add(handlerDesc);
        }
        return result;
    }
}

