/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.transform.scale.internal.profiles;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.thing.profiles.ProfileCallback;
import org.eclipse.smarthome.core.thing.profiles.ProfileContext;
import org.eclipse.smarthome.core.thing.profiles.ProfileTypeUID;
import org.eclipse.smarthome.core.thing.profiles.StateProfile;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationHelper;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ScaleTransformationProfile
implements StateProfile {
    public static final ProfileTypeUID PROFILE_TYPE_UID = new ProfileTypeUID("transform", "SCALE");
    private final Logger logger = LoggerFactory.getLogger(ScaleTransformationProfile.class);
    private final TransformationService service;
    private final ProfileCallback callback;
    private static final String FUNCTION_PARAM = "function";
    private static final String SOURCE_FORMAT_PARAM = "sourceFormat";
    @NonNullByDefault(value={})
    private final String function;
    @NonNullByDefault(value={})
    private final String sourceFormat;

    public ScaleTransformationProfile(ProfileCallback callback, ProfileContext context, TransformationService service) {
        this.service = service;
        this.callback = callback;
        Object paramFunction = context.getConfiguration().get(FUNCTION_PARAM);
        Object paramSource = context.getConfiguration().get(SOURCE_FORMAT_PARAM);
        this.logger.debug("Profile configured with '{}'='{}', '{}'={}", new Object[]{FUNCTION_PARAM, paramFunction, SOURCE_FORMAT_PARAM, paramSource});
        if (paramSource == null) {
            paramSource = "%s";
        }
        if (paramFunction instanceof String && paramSource instanceof String) {
            this.function = (String)paramFunction;
            this.sourceFormat = (String)paramSource;
        } else {
            this.logger.error("Parameter '{}' and '{}' have to be Strings. Profile will be inactive.", (Object)FUNCTION_PARAM, (Object)SOURCE_FORMAT_PARAM);
            this.function = null;
            this.sourceFormat = null;
        }
    }

    public ProfileTypeUID getProfileTypeUID() {
        return PROFILE_TYPE_UID;
    }

    public void onStateUpdateFromItem(State state) {
        this.callback.handleUpdate(state);
    }

    public void onCommandFromItem(Command command) {
        this.callback.handleCommand(command);
    }

    public void onCommandFromHandler(Command command) {
        if (this.function == null || this.sourceFormat == null) {
            this.logger.warn("Please specify a function and a source format for this Profile in the '{}', and '{}' parameters. Returning the original command now.", (Object)FUNCTION_PARAM, (Object)SOURCE_FORMAT_PARAM);
            this.callback.sendCommand(command);
            return;
        }
        this.callback.sendCommand((Command)this.transformState((Type)command));
    }

    public void onStateUpdateFromHandler(State state) {
        if (this.function == null || this.sourceFormat == null) {
            this.logger.warn("Please specify a function and a source format for this Profile in the '{}' and '{}' parameters. Returning the original state now.", (Object)FUNCTION_PARAM, (Object)SOURCE_FORMAT_PARAM);
            this.callback.sendUpdate(state);
            return;
        }
        this.callback.sendUpdate((State)this.transformState((Type)state));
    }

    private Type transformState(Type state) {
        String result = state.toFullString();
        try {
            result = TransformationHelper.transform((TransformationService)this.service, (String)this.function, (String)this.sourceFormat, (String)state.toFullString());
        }
        catch (TransformationException transformationException) {
            this.logger.warn("Could not transform state '{}' with function '{}' and format '{}'", new Object[]{state, this.function, this.sourceFormat});
        }
        StringType resultType = new StringType(result);
        this.logger.debug("Transformed '{}' into '{}'", (Object)state, (Object)resultType);
        return resultType;
    }
}

