/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.transform.exec.internal;

import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.eclipse.smarthome.io.net.exec.ExecUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecTransformationService
implements TransformationService {
    private final Logger logger = LoggerFactory.getLogger(ExecTransformationService.class);

    public String transform(String commandLine, String source) throws TransformationException {
        if (commandLine == null || source == null) {
            throw new TransformationException("the given parameters 'commandLine' and 'source' must not be null");
        }
        this.logger.debug("about to transform '{}' by the commanline '{}'", (Object)source, (Object)commandLine);
        long startTime = System.currentTimeMillis();
        String formattedCommandLine = String.format(commandLine, source);
        String result = ExecUtil.executeCommandLineAndWaitResponse((String)formattedCommandLine, (int)5000);
        this.logger.trace("command line execution elapsed {} ms", (Object)(System.currentTimeMillis() - startTime));
        return result;
    }
}

