/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.thing.validation;

import com.google.common.base.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.model.thing.thing.ModelThing;
import org.eclipse.smarthome.model.thing.thing.ThingPackage;
import org.eclipse.smarthome.model.thing.validation.AbstractThingValidator;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ThingValidator
extends AbstractThingValidator {
    public static final String INVALID_NAME = "invalidName";

    @Check
    public ThingUID check_thing_has_valid_id(ModelThing thing) {
        ThingUID _xifexpression = null;
        boolean _isNested = this.isNested(thing);
        if (_isNested) {
            boolean _not;
            boolean _eIsSet = thing.eIsSet((EStructuralFeature)ThingPackage.Literals.MODEL_THING__THING_TYPE_ID);
            boolean bl = _not = !_eIsSet;
            if (_not) {
                boolean _eIsSet_1 = thing.eIsSet((EStructuralFeature)ThingPackage.Literals.MODEL_PROPERTY_CONTAINER__ID);
                if (_eIsSet_1) {
                    this.error("Provide a thing type ID and a thing ID in this format:\n <thingTypeId> <thingId>", (EStructuralFeature)ThingPackage.Literals.MODEL_PROPERTY_CONTAINER__ID);
                } else {
                    boolean _eIsSet_2 = thing.eIsSet((EStructuralFeature)ThingPackage.Literals.MODEL_BRIDGE__BRIDGE);
                    if (_eIsSet_2) {
                        this.error("Provide a thing type ID and a thing ID in this format:\n <thingTypeId> <thingId>", (EStructuralFeature)ThingPackage.Literals.MODEL_BRIDGE__BRIDGE);
                    }
                }
            } else {
                boolean _not_1;
                boolean _eIsSet_3 = thing.eIsSet((EStructuralFeature)ThingPackage.Literals.MODEL_THING__THING_ID);
                boolean bl2 = _not_1 = !_eIsSet_3;
                if (_not_1) {
                    this.error("Provide a thing type ID and a thing ID in this format:\n <thingTypeId> <thingId>", (EStructuralFeature)ThingPackage.Literals.MODEL_THING__THING_TYPE_ID);
                }
            }
        } else {
            ThingUID _xifexpression_1 = null;
            if (thing.eIsSet((EStructuralFeature)ThingPackage.Literals.MODEL_THING__THING_TYPE_ID) && thing.eIsSet((EStructuralFeature)ThingPackage.Literals.MODEL_THING__THING_ID)) {
                INode thingTypeIdFeature = (INode)IterableExtensions.head((Iterable)NodeModelUtils.findNodesForFeature((EObject)thing, (EStructuralFeature)ThingPackage.Literals.MODEL_THING__THING_TYPE_ID));
                INode thingIdFeature = (INode)IterableExtensions.head((Iterable)NodeModelUtils.findNodesForFeature((EObject)thing, (EStructuralFeature)ThingPackage.Literals.MODEL_THING__THING_ID));
                int startOffset = thingTypeIdFeature.getOffset();
                int endOffset = thingIdFeature.getEndOffset();
                this.getMessageAcceptor().acceptError("Provide a thing UID in this format:\n <bindingId>:<thingTypeId>:<thingId>", (EObject)thing, startOffset, endOffset - startOffset, null, null);
            } else {
                boolean _notEquals;
                ThingUID _xifexpression_2 = null;
                String _id = thing.getId();
                boolean bl = _notEquals = !Objects.equal((Object)_id, null);
                if (_notEquals) {
                    ThingUID _xtrycatchfinallyexpression = null;
                    try {
                        String _id_1 = thing.getId();
                        _xtrycatchfinallyexpression = new ThingUID(_id_1);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof IllegalArgumentException) {
                            IllegalArgumentException e = (IllegalArgumentException)_t;
                            this.error(e.getMessage(), (EStructuralFeature)ThingPackage.Literals.MODEL_PROPERTY_CONTAINER__ID);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    _xifexpression_2 = _xtrycatchfinallyexpression;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private boolean isNested(ModelThing thing) {
        EStructuralFeature _eContainingFeature = thing.eContainingFeature();
        return Objects.equal((Object)_eContainingFeature, (Object)ThingPackage.Literals.MODEL_BRIDGE__THINGS);
    }
}

