/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.thing.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smarthome.model.thing.services.ThingGrammarAccess;
import org.eclipse.smarthome.model.thing.thing.ModelBridge;
import org.eclipse.smarthome.model.thing.thing.ModelChannel;
import org.eclipse.smarthome.model.thing.thing.ModelProperty;
import org.eclipse.smarthome.model.thing.thing.ModelThing;
import org.eclipse.smarthome.model.thing.thing.ThingModel;
import org.eclipse.smarthome.model.thing.thing.ThingPackage;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;

public abstract class AbstractThingSemanticSequencer
extends AbstractDelegatingSemanticSequencer {
    @Inject
    private ThingGrammarAccess grammarAccess;

    public void sequence(ISerializationContext context, EObject semanticObject) {
        EPackage epackage = semanticObject.eClass().getEPackage();
        ParserRule rule = context.getParserRule();
        Action action = context.getAssignedAction();
        Set parameters = context.getEnabledBooleanParameters();
        if (epackage == ThingPackage.eINSTANCE) {
            switch (semanticObject.eClass().getClassifierID()) {
                case 5: {
                    this.sequence_ModelBridge(context, (ModelBridge)semanticObject);
                    return;
                }
                case 3: {
                    this.sequence_ModelChannel(context, (ModelChannel)semanticObject);
                    return;
                }
                case 4: {
                    this.sequence_ModelProperty(context, (ModelProperty)semanticObject);
                    return;
                }
                case 2: {
                    this.sequence_ModelThing(context, (ModelThing)semanticObject);
                    return;
                }
                case 0: {
                    this.sequence_ThingModel(context, (ThingModel)semanticObject);
                    return;
                }
            }
        }
        if (this.errorAcceptor != null) {
            this.errorAcceptor.accept(this.diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
        }
    }

    protected void sequence_ModelBridge(ISerializationContext context, ModelBridge semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_ModelChannel(ISerializationContext context, ModelChannel semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_ModelProperty(ISerializationContext context, ModelProperty semanticObject) {
        if (this.errorAcceptor != null) {
            if (this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)ThingPackage.Literals.MODEL_PROPERTY__KEY) == ITransientValueService.ValueTransient.YES) {
                this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)ThingPackage.Literals.MODEL_PROPERTY__KEY));
            }
            if (this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)ThingPackage.Literals.MODEL_PROPERTY__VALUE) == ITransientValueService.ValueTransient.YES) {
                this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)ThingPackage.Literals.MODEL_PROPERTY__VALUE));
            }
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, semanticObject);
        feeder.accept(this.grammarAccess.getModelPropertyAccess().getKeyIDTerminalRuleCall_0_0(), (Object)semanticObject.getKey());
        feeder.accept(this.grammarAccess.getModelPropertyAccess().getValueValueTypeParserRuleCall_2_0(), semanticObject.getValue());
        feeder.finish();
    }

    protected void sequence_ModelThing(ISerializationContext context, ModelThing semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_ThingModel(ISerializationContext context, ThingModel semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }
}

