/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.dispatch.internal;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.core.service.AbstractWatchService;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ConfigDispatcher
extends AbstractWatchService {
    private final Logger logger = LoggerFactory.getLogger(ConfigDispatcher.class);
    private final Gson gson = new Gson();
    public static final String SERVICEDIR_PROG_ARGUMENT = "smarthome.servicedir";
    public static final String SERVICEPID_PROG_ARGUMENT = "smarthome.servicepid";
    public static final String SERVICECFG_PROG_ARGUMENT = "smarthome.servicecfg";
    public static final String SERVICES_FOLDER = "services";
    public static final String SERVICE_PID_NAMESPACE = "org.eclipse.smarthome";
    public static final String SERVICE_CFG_FILE = "smarthome.cfg";
    private static final String PID_MARKER = "pid:";
    private static final String EXCLUSIVE_PID_STORE_FILE = "configdispatcher_pid_list.json";
    private ExclusivePIDMap exclusivePIDMap;
    private ConfigurationAdmin configAdmin;
    private File exclusivePIDStore;

    public ConfigDispatcher() {
        super(ConfigDispatcher.getPathToWatch());
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        super.activate();
        this.exclusivePIDStore = bundleContext.getDataFile(EXCLUSIVE_PID_STORE_FILE);
        this.loadExclusivePIDList();
        this.readDefaultConfig();
        this.readConfigFiles();
        this.processOrphanExclusivePIDs();
        this.storeCurrentExclusivePIDList();
    }

    @Deactivate
    public void deactivate() {
        super.deactivate();
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    protected void setConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    protected void unsetConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = null;
    }

    protected boolean watchSubDirectories() {
        return false;
    }

    protected WatchEvent.Kind<?>[] getWatchEventKinds(Path subDir) {
        return new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    }

    protected void processWatchEvent(WatchEvent<?> event, WatchEvent.Kind<?> kind, Path path) {
        if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY) {
            try {
                File f = path.toFile();
                if (!f.isHidden()) {
                    this.processConfigFile(f);
                }
            }
            catch (IOException e) {
                this.logger.warn("Could not process config file '{}': {}", (Object)path, (Object)e);
            }
        } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
            File configFile = path.toFile();
            if (configFile.isHidden() || configFile.isDirectory() || !configFile.getName().endsWith(".cfg")) {
                return;
            }
            this.exclusivePIDMap.setFileRemoved(configFile.getAbsolutePath());
            this.processOrphanExclusivePIDs();
        }
        this.storeCurrentExclusivePIDList();
    }

    private void loadExclusivePIDList() {
        try {
            try {
                Throwable throwable = null;
                Object var2_5 = null;
                try (FileReader reader = new FileReader(this.exclusivePIDStore);){
                    this.exclusivePIDMap = (ExclusivePIDMap)this.gson.fromJson((Reader)reader, ExclusivePIDMap.class);
                    if (this.exclusivePIDMap != null) {
                        this.exclusivePIDMap.initializeProcessPIDMapping();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (JsonIOException | JsonSyntaxException e) {
                this.logger.error("Error parsing exclusive pids from '{}': {}", (Object)this.exclusivePIDStore.getAbsolutePath(), (Object)e.getMessage());
                if (this.exclusivePIDMap == null) {
                    this.exclusivePIDMap = new ExclusivePIDMap();
                }
            }
            catch (IOException e) {
                this.logger.debug("Error loading exclusive pids from '{}': {}", (Object)this.exclusivePIDStore.getAbsolutePath(), (Object)e.getMessage());
                if (this.exclusivePIDMap == null) {
                    this.exclusivePIDMap = new ExclusivePIDMap();
                }
            }
        }
        finally {
            if (this.exclusivePIDMap == null) {
                this.exclusivePIDMap = new ExclusivePIDMap();
            }
        }
    }

    private void storeCurrentExclusivePIDList() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileWriter writer = new FileWriter(this.exclusivePIDStore);){
                this.exclusivePIDMap.setCurrentExclusivePIDList();
                this.gson.toJson((Object)this.exclusivePIDMap, (Appendable)writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonIOException | IOException e) {
            this.logger.error("Error storing exclusive PID list in bundle data file: {}", (Object)e.getMessage());
        }
    }

    private void processOrphanExclusivePIDs() {
        for (String orphanPID : this.exclusivePIDMap.getOrphanPIDs()) {
            try {
                Configuration configuration = this.configAdmin.getConfiguration(orphanPID, null);
                configuration.delete();
                this.logger.debug("Deleting configuration for orphan pid {}", (Object)orphanPID);
            }
            catch (IOException e) {
                this.logger.error("Error deleting configuration for orphan pid {}.", (Object)orphanPID);
            }
        }
    }

    private static String getPathToWatch() {
        String progArg = System.getProperty(SERVICEDIR_PROG_ARGUMENT);
        if (progArg != null) {
            return String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + progArg;
        }
        return String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + SERVICES_FOLDER;
    }

    private String getDefaultServiceConfigPath() {
        String progArg = System.getProperty(SERVICECFG_PROG_ARGUMENT);
        if (progArg != null) {
            return progArg;
        }
        return String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + SERVICE_CFG_FILE;
    }

    private void readDefaultConfig() {
        String defaultCfgPath = this.getDefaultServiceConfigPath();
        try {
            this.processConfigFile(new File(defaultCfgPath));
        }
        catch (IOException e) {
            this.logger.warn("Could not process default config file '{}': {}", (Object)defaultCfgPath, (Object)e.getMessage());
        }
    }

    private void readConfigFiles() {
        File dir = this.getSourcePath().toFile();
        if (dir.exists()) {
            File[] files = dir.listFiles();
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File left, File right) {
                    return Long.valueOf(left.lastModified()).compareTo(right.lastModified());
                }
            });
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    this.processConfigFile(file);
                }
                catch (IOException e) {
                    this.logger.warn("Could not process config file '{}': {}", (Object)file.getName(), (Object)e.getMessage());
                }
                ++n2;
            }
        } else {
            this.logger.debug("Configuration folder '{}' does not exist.", (Object)dir.toString());
        }
    }

    private static String getServicePidNamespace() {
        String progArg = System.getProperty(SERVICEPID_PROG_ARGUMENT);
        if (progArg != null) {
            return progArg;
        }
        return SERVICE_PID_NAMESPACE;
    }

    private String pidFromFilename(File configFile) {
        String filenameWithoutExt = StringUtils.substringBeforeLast((String)configFile.getName(), (String)".");
        if (filenameWithoutExt.contains(".")) {
            return filenameWithoutExt;
        }
        return String.valueOf(ConfigDispatcher.getServicePidNamespace()) + "." + filenameWithoutExt;
    }

    private void processConfigFile(File configFile) throws IOException, FileNotFoundException {
        String exclusivePID;
        if (configFile.isDirectory() || !configFile.getName().endsWith(".cfg")) {
            this.logger.debug("Ignoring file '{}'", (Object)configFile.getName());
            return;
        }
        this.logger.debug("Processing config file '{}'", (Object)configFile.getName());
        HashMap<Configuration, Dictionary> configsToUpdate = new HashMap<Configuration, Dictionary>();
        HashMap<Configuration, Dictionary> configMap = new HashMap<Configuration, Dictionary>();
        String pid = this.pidFromFilename(configFile);
        List lines = IOUtils.readLines((InputStream)new FileInputStream(configFile));
        String string = exclusivePID = lines.size() > 0 ? this.getPIDFromLine((String)lines.get(0)) : null;
        if (exclusivePID != null) {
            if (this.exclusivePIDMap.contains(exclusivePID)) {
                this.logger.warn("The file {} subsequently defines the exclusive PID '{}'.", (Object)configFile.getAbsolutePath(), (Object)exclusivePID);
            }
            pid = exclusivePID;
            lines = lines.subList(1, lines.size());
            this.exclusivePIDMap.setProcessedPID(pid, configFile.getAbsolutePath());
        } else if (this.exclusivePIDMap.contains(pid)) {
            this.exclusivePIDMap.removeExclusivePID(pid);
        }
        Configuration configuration = this.configAdmin.getConfiguration(pid, null);
        if (this.exclusivePIDMap.contains(pid)) {
            configMap.put(configuration, new Properties());
        }
        for (String string2 : lines) {
            Dictionary configProperties;
            ParseLineResult parsedLine = this.parseLine(configFile.getPath(), string2);
            if (parsedLine.isEmpty()) continue;
            if (this.exclusivePIDMap.contains(pid) && parsedLine.pid != null && !pid.equals(parsedLine.pid)) {
                this.logger.error("Error parsing config file {}. Exclusive PID {} found but line starts with {}.", new Object[]{configFile.getName(), pid, parsedLine.pid});
                configuration.update((Dictionary)new Properties());
                return;
            }
            if (!this.exclusivePIDMap.contains(pid) && parsedLine.pid != null && this.exclusivePIDMap.contains(parsedLine.pid)) {
                this.logger.error("Error parsing config file {}. The PID {} is exclusive but defined in another file, skipping the line.", (Object)configFile.getName(), (Object)parsedLine.pid);
                continue;
            }
            if (parsedLine.pid != null) {
                pid = parsedLine.pid;
                configuration = this.configAdmin.getConfiguration(pid, null);
            }
            if ((configProperties = (Dictionary)configMap.get(configuration)) == null) {
                configProperties = configuration.getProperties() != null ? configuration.getProperties() : new Properties();
                configMap.put(configuration, configProperties);
            }
            if (parsedLine.value.equals(configProperties.get(parsedLine.property))) continue;
            configProperties.put(parsedLine.property, parsedLine.value);
            configsToUpdate.put(configuration, configProperties);
        }
        for (Map.Entry entry : configsToUpdate.entrySet()) {
            ((Configuration)entry.getKey()).update((Dictionary)entry.getValue());
        }
    }

    private String getPIDFromLine(String line) {
        if (line.startsWith(PID_MARKER)) {
            return line.substring(PID_MARKER.length()).trim();
        }
        return null;
    }

    private ParseLineResult parseLine(String filePath, String line) {
        String trimmedLine = line.trim();
        if (trimmedLine.startsWith("#") || trimmedLine.isEmpty()) {
            return new ParseLineResult();
        }
        String pid = null;
        String key = StringUtils.substringBefore((String)trimmedLine, (String)"=");
        if (key.contains(":")) {
            pid = StringUtils.substringBefore((String)key, (String)":");
            trimmedLine = trimmedLine.substring(pid.length() + 1);
            if (!(pid = pid.trim()).contains(".")) {
                pid = String.valueOf(ConfigDispatcher.getServicePidNamespace()) + "." + pid;
            }
        }
        if (!trimmedLine.isEmpty() && trimmedLine.substring(1).contains("=")) {
            String property = StringUtils.substringBefore((String)trimmedLine, (String)"=");
            String value = trimmedLine.substring(property.length() + 1);
            return new ParseLineResult(pid, property.trim(), value.trim());
        }
        this.logger.warn("Could not parse line '{}'", (Object)line);
        return new ParseLineResult();
    }

    private class ExclusivePIDMap {
        private List<String> exclusivePIDs = new ArrayList<String>();
        private transient Map<String, String> processedPIDMapping = new HashMap<String, String>();

        private ExclusivePIDMap() {
        }

        public void setProcessedPID(String pid, String pathToFile) {
            this.processedPIDMapping.put(pid, pathToFile);
        }

        public void removeExclusivePID(String pid) {
            this.processedPIDMapping.remove(pid);
        }

        public void setFileRemoved(String absolutePath) {
            for (Map.Entry<String, String> entry : this.processedPIDMapping.entrySet()) {
                if (!entry.getValue().equals(absolutePath)) continue;
                entry.setValue(null);
                return;
            }
        }

        public void initializeProcessPIDMapping() {
            this.processedPIDMapping = new HashMap<String, String>();
            for (String pid : this.exclusivePIDs) {
                this.processedPIDMapping.put(pid, null);
            }
        }

        public List<String> getOrphanPIDs() {
            return this.processedPIDMapping.entrySet().stream().filter(e -> e.getValue() == null).map(e -> (String)e.getKey()).collect(Collectors.toList());
        }

        public void setCurrentExclusivePIDList() {
            this.exclusivePIDs = this.processedPIDMapping.entrySet().stream().filter(e -> e.getValue() != null).map(e -> (String)e.getKey()).collect(Collectors.toList());
        }

        public boolean contains(String pid) {
            return this.processedPIDMapping.containsKey(pid);
        }
    }

    private class ParseLineResult {
        public String pid;
        public String property;
        public String value;

        public ParseLineResult() {
            this(null, null, null);
        }

        public ParseLineResult(String pid, String property, String value) {
            this.pid = pid;
            this.property = property;
            this.value = value;
        }

        public boolean isEmpty() {
            return this.pid == null && this.property == null && this.value == null;
        }
    }
}

