/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.rulesupport.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.ModuleTypeProvider;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.common.registry.ProviderChangeListener;

public class ScriptedCustomModuleTypeProvider
implements ModuleTypeProvider {
    private HashMap<String, ModuleType> modulesTypes = new HashMap();
    private HashSet<ProviderChangeListener<ModuleType>> listeners = new HashSet();

    public Collection<ModuleType> getAll() {
        return this.modulesTypes.values();
    }

    public void addProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        this.listeners.add(listener);
    }

    public void removeProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        this.listeners.remove(listener);
    }

    public <T extends ModuleType> T getModuleType(String UID, Locale locale) {
        ModuleType handler = this.modulesTypes.get(UID);
        return (T)handler;
    }

    public <T extends ModuleType> Collection<T> getModuleTypes(Locale locale) {
        return this.modulesTypes.values();
    }

    public void addModuleType(ModuleType moduleType) {
        this.modulesTypes.put(moduleType.getUID(), moduleType);
        for (ProviderChangeListener<ModuleType> listener : this.listeners) {
            listener.added((Provider)this, (Object)moduleType);
        }
    }

    public void removeModuleType(ModuleType moduleType) {
        this.removeModuleType(moduleType.getUID());
    }

    public void removeModuleType(String moduleTypeUID) {
        ModuleType element = this.modulesTypes.remove(moduleTypeUID);
        for (ProviderChangeListener<ModuleType> listener : this.listeners) {
            listener.removed((Provider)this, (Object)element);
        }
    }

    public void updateModuleHandler(String uid) {
        ModuleType modType = this.modulesTypes.get(uid);
        if (modType != null) {
            for (ProviderChangeListener<ModuleType> listener : this.listeners) {
                listener.updated((Provider)this, null, (Object)modType);
            }
        }
    }
}

