/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script.jvmmodel;

import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.ItemRegistryChangeListener;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptItemRefresher
implements ItemRegistryChangeListener {
    private final Logger logger = LoggerFactory.getLogger(ScriptItemRefresher.class);
    ModelRepository modelRepository;
    private ItemRegistry itemRegistry;
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> job;
    Runnable runnable = new Runnable(){

        @Override
        public void run() {
            try {
                ScriptItemRefresher.this.modelRepository.reloadAllModelsOfType("script");
            }
            catch (Exception e) {
                ScriptItemRefresher.this.logger.debug("Exception occurred during execution: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    };

    public void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    public void unsetModelRepository(ModelRepository modelRepository) {
        this.modelRepository = null;
    }

    public void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
        this.itemRegistry.addRegistryChangeListener((RegistryChangeListener)this);
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.itemRegistry = null;
    }

    public void added(Item element) {
        this.scheduleScriptRefresh();
    }

    public void removed(Item element) {
        this.scheduleScriptRefresh();
    }

    public void updated(Item oldElement, Item element) {
    }

    public void allItemsChanged(Collection<String> oldItemNames) {
        this.scheduleScriptRefresh();
    }

    private synchronized void scheduleScriptRefresh() {
        if (this.job != null && !this.job.isDone()) {
            this.job.cancel(false);
        }
        this.job = this.scheduler.schedule(this.runnable, 1000L, TimeUnit.SECONDS);
    }
}

