/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script.internal.actions;

import java.util.Date;
import java.util.Iterator;
import org.eclipse.smarthome.model.script.actions.Timer;
import org.eclipse.smarthome.model.script.internal.actions.TimerExecutionJob;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInstant;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerImpl
implements Timer {
    private final Logger logger = LoggerFactory.getLogger(TimerImpl.class);
    public static Scheduler scheduler;
    private final JobKey jobKey;
    private TriggerKey triggerKey;
    private final JobDataMap dataMap;
    private final AbstractInstant startTime;
    private boolean cancelled = false;
    private boolean terminated = false;

    static {
        try {
            scheduler = StdSchedulerFactory.getDefaultScheduler();
        }
        catch (SchedulerException e) {
            LoggerFactory.getLogger(TimerImpl.class).error("initializing scheduler throws exception", (Throwable)e);
        }
    }

    public TimerImpl(JobKey jobKey, TriggerKey triggerKey, JobDataMap dataMap, AbstractInstant startTime) {
        this.jobKey = jobKey;
        this.triggerKey = triggerKey;
        this.dataMap = dataMap;
        this.startTime = startTime;
        dataMap.put("timer", (Object)this);
    }

    @Override
    public boolean cancel() {
        try {
            boolean result = scheduler.deleteJob(this.jobKey);
            if (result) {
                this.cancelled = true;
            }
        }
        catch (SchedulerException e) {
            this.logger.warn("An error occurred while cancelling the job '{}': {}", (Object)this.jobKey.toString(), (Object)e.getMessage());
        }
        return this.cancelled;
    }

    @Override
    public boolean reschedule(AbstractInstant newTime) {
        try {
            Trigger trigger = TriggerBuilder.newTrigger().startAt(newTime.toDate()).build();
            Date nextTriggerTime = scheduler.rescheduleJob(this.triggerKey, trigger);
            if (nextTriggerTime == null) {
                this.logger.debug("Scheduling a new job job '{}' because the original has already run", (Object)this.jobKey.toString());
                JobDetail job = JobBuilder.newJob(TimerExecutionJob.class).withIdentity(this.jobKey).usingJobData(this.dataMap).build();
                scheduler.scheduleJob(job, trigger);
            }
            this.triggerKey = trigger.getKey();
            this.cancelled = false;
            this.terminated = false;
            return true;
        }
        catch (SchedulerException e) {
            this.logger.warn("An error occurred while rescheduling the job '{}': {}", (Object)this.jobKey.toString(), (Object)e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isRunning() {
        try {
            JobExecutionContext context;
            Iterator iterator = scheduler.getCurrentlyExecutingJobs().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(context = (JobExecutionContext)iterator.next()).getJobDetail().getKey().equals((Object)this.jobKey));
            return true;
        }
        catch (SchedulerException e) {
            this.logger.debug("An error occurred getting currently running jobs: {}", (Object)e.getMessage());
            return DateTime.now().isAfter((ReadableInstant)this.startTime) && !this.terminated;
        }
    }

    @Override
    public boolean hasTerminated() {
        return this.terminated;
    }

    public void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }
}

