/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.timer.handler;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.handler.BaseModuleHandler;
import org.eclipse.smarthome.automation.handler.ConditionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DayOfWeekConditionHandler
extends BaseModuleHandler<Condition>
implements ConditionHandler {
    private final Logger logger = LoggerFactory.getLogger(DayOfWeekConditionHandler.class);
    public static final String MODULE_TYPE_ID = "timer.DayOfWeekCondition";
    public static final String MODULE_CONTEXT_NAME = "MODULE";
    private static final String CFG_DAYS = "days";
    private final Set<Integer> days;

    public DayOfWeekConditionHandler(Condition module) {
        super((Module)module);
        try {
            this.days = new HashSet<Integer>();
            for (String day : (Iterable)module.getConfiguration().get(CFG_DAYS)) {
                switch (day.toUpperCase()) {
                    case "SUN": {
                        this.days.add(1);
                        break;
                    }
                    case "MON": {
                        this.days.add(2);
                        break;
                    }
                    case "TUE": {
                        this.days.add(3);
                        break;
                    }
                    case "WED": {
                        this.days.add(4);
                        break;
                    }
                    case "THU": {
                        this.days.add(5);
                        break;
                    }
                    case "FRI": {
                        this.days.add(6);
                        break;
                    }
                    case "SAT": {
                        this.days.add(7);
                        break;
                    }
                    default: {
                        this.logger.warn("Ignoring illegal weekday '{}'", (Object)day);
                    }
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException("'days' parameter must be an array of strings.");
        }
    }

    public boolean isSatisfied(Map<String, Object> context) {
        int dow = Calendar.getInstance().get(7);
        return this.days.contains(dow);
    }
}

