/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.basic.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebAppConfig {
    private static final String DEFAULT_SITEMAP = "default";
    private static final String DEFAULT_ICON_TYPE = "png";
    public static final String THEME_NAME_DEFAULT = "default";
    public static final String THEME_NAME_DARK = "dark";
    private static final String DEFAULT_THEME = "default";
    private String defaultSitemap = "default";
    private String iconType = "png";
    private String theme = "default";
    private List<String> cssClassList = new ArrayList<String>();
    private static final Map<String, String> cssClasses = new HashMap<String, String>();
    private static final Map<String, Boolean> cssDefaultValues;
    private static final String CONFIG_ENABLE_ICONS = "enableIcons";
    private static final String CONFIG_CONDENSED_LAYOUT = "condensedLayout";
    private static final String CONFIG_CAPITALIZE = "capitalizeValues";

    static {
        cssClasses.put(CONFIG_ENABLE_ICONS, "ui-icons-enabled");
        cssClasses.put(CONFIG_CONDENSED_LAYOUT, "ui-layout-condensed");
        cssClasses.put(CONFIG_CAPITALIZE, "ui-capitalize-values");
        cssDefaultValues = new HashMap<String, Boolean>();
        cssDefaultValues.put(CONFIG_ENABLE_ICONS, true);
        cssDefaultValues.put(CONFIG_CONDENSED_LAYOUT, false);
        cssDefaultValues.put(CONFIG_CAPITALIZE, false);
    }

    private void applyCssClasses(Map<String, Object> configProps) {
        this.cssClassList.clear();
        for (String key : cssClasses.keySet()) {
            Boolean value = cssDefaultValues.get(key);
            if (configProps.containsKey(key)) {
                value = configProps.get(key).toString().equalsIgnoreCase("true");
            }
            if (!value.booleanValue()) continue;
            this.cssClassList.add(cssClasses.get(key));
        }
    }

    public void applyConfig(Map<String, Object> configProps) {
        String configDefaultSitemap = (String)configProps.get("defaultSitemap");
        String configIconType = (String)configProps.get("iconType");
        String configTheme = (String)configProps.get("theme");
        if (configDefaultSitemap == null) {
            configDefaultSitemap = "default";
        }
        if (configIconType == null) {
            configIconType = DEFAULT_ICON_TYPE;
        } else if (!configIconType.equalsIgnoreCase("svg") && !configIconType.equalsIgnoreCase(DEFAULT_ICON_TYPE)) {
            configIconType = DEFAULT_ICON_TYPE;
        }
        if (configTheme == null) {
            configTheme = "default";
        }
        this.defaultSitemap = configDefaultSitemap;
        this.iconType = configIconType;
        this.theme = configTheme;
        this.applyCssClasses(configProps);
    }

    public String getDefaultSitemap() {
        return this.defaultSitemap;
    }

    public String getIconType() {
        return this.iconType;
    }

    public String getTheme() {
        return this.theme;
    }

    public String getCssClassList() {
        String result = " ";
        for (String item : this.cssClassList) {
            result = String.valueOf(result) + item + " ";
        }
        return result;
    }
}

