/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table.tree;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.tree.ITreeData;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeCollapseAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandCollapseCommand;
import org.eclipse.set.model.tablemodel.CellContent;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.utils.table.TMFactory;
import org.eclipse.set.utils.table.TableDataProvider;
import org.eclipse.set.utils.table.TableRowData;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class TreeDataProvider
extends TableDataProvider
implements ITreeData<TableRowData> {
    private List<Pair<TableRowData, List<TableRowData>>> rowGroupMapping;
    private List<TableRowData> parentRowMapping;
    private TMFactory tmFactory;
    private Set<Integer> hiddenRowsIndex;

    public TreeDataProvider(Table table, UnaryOperator<Integer> getSourceLine) {
        super(table, getSourceLine);
        TMFactory _tMFactory;
        this.tmFactory = _tMFactory = new TMFactory(table);
        this.hiddenRowsIndex = CollectionLiterals.newHashSet();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshRowGroup();
    }

    public void refreshRowGroup() {
        this.parentRowMapping = CollectionLiterals.newLinkedList();
        this.rowGroupMapping = CollectionLiterals.newLinkedList();
        Functions.Function1<RowGroup, EList<TableRow>> _function = new Functions.Function1<RowGroup, EList<TableRow>>(){

            public EList<TableRow> apply(RowGroup it) {
                return it.getRows();
            }
        };
        Functions.Function1<EList<TableRow>, Boolean> _function_1 = new Functions.Function1<EList<TableRow>, Boolean>(){

            public Boolean apply(EList<TableRow> it) {
                return !it.isEmpty() && IterableExtensions.exists(it, (Functions.Function1)new Functions.Function1<TableRow, Boolean>(){

                    public Boolean apply(TableRow it_1) {
                        TableRowData _findRow = TreeDataProvider.this.findRow(it_1);
                        return _findRow != null;
                    }
                });
            }
        };
        List rowGroups = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map((List)this.table.getTablecontent().getRowgroups(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        Consumer<EList<TableRow>> _function_2 = new Consumer<EList<TableRow>>(){

            @Override
            public void accept(EList<TableRow> rows) {
                boolean _greaterThan;
                TableRowData firstRow = TreeDataProvider.this.findRow((TableRow)rows.get(0));
                TreeDataProvider.this.parentRowMapping.add(firstRow);
                int _size = rows.size();
                boolean bl = _greaterThan = _size > 1;
                if (_greaterThan) {
                    Functions.Function1<TableRow, TableRowData> _function = new Functions.Function1<TableRow, TableRowData>(){

                        public TableRowData apply(TableRow it) {
                            return TreeDataProvider.this.findRow(it);
                        }
                    };
                    List childs = IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)rows.subList(1, rows.size()), (Functions.Function1)_function)));
                    boolean _isEmpty = childs.isEmpty();
                    if (_isEmpty) {
                        TreeDataProvider.this.tableContents.remove(firstRow);
                    } else {
                        Pair _pair = new Pair((Object)firstRow, (Object)childs);
                        TreeDataProvider.this.rowGroupMapping.add((Pair<TableRowData, List<TableRowData>>)_pair);
                    }
                } else {
                    boolean _equals;
                    int _size_1 = rows.size();
                    boolean bl2 = _equals = _size_1 == 1;
                    if (_equals) {
                        List _emptyList = Collections.emptyList();
                        Pair _pair_1 = new Pair((Object)firstRow, _emptyList);
                        TreeDataProvider.this.rowGroupMapping.add((Pair<TableRowData, List<TableRowData>>)_pair_1);
                    }
                }
            }
        };
        rowGroups.forEach(_function_2);
        if (this.currentComparator != null) {
            this.sort((Integer)this.currentComparator.getKey(), (Comparator)this.currentComparator.getValue());
        }
    }

    @Override
    public boolean filterMatch(TableRowData row) {
        boolean _isParentRow = this.isParentRow(row);
        if (_isParentRow) {
            return true;
        }
        return super.filterMatch(row);
    }

    private boolean isParentRow(final TableRowData rowData) {
        boolean _isNullOrEmpty;
        if (this.rowGroupMapping == null) {
            return false;
        }
        Functions.Function1<Pair<TableRowData, List<TableRowData>>, Boolean> _function = new Functions.Function1<Pair<TableRowData, List<TableRowData>>, Boolean>(){

            public Boolean apply(Pair<TableRowData, List<TableRowData>> it) {
                return ((TableRowData)it.getKey()).getRow().equals(rowData.getRow());
            }
        };
        Pair _findFirst = (Pair)IterableExtensions.findFirst(this.rowGroupMapping, (Functions.Function1)_function);
        List _value = null;
        if (_findFirst != null) {
            _value = (List)_findFirst.getValue();
        }
        return !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty(_value));
    }

    public List<TableRowData> getChildren(final TableRowData object) {
        if (object != null && this.getDepthOfData(object) == 0) {
            Functions.Function1<Pair<TableRowData, List<TableRowData>>, Boolean> _function = new Functions.Function1<Pair<TableRowData, List<TableRowData>>, Boolean>(){

                public Boolean apply(Pair<TableRowData, List<TableRowData>> it) {
                    return ((TableRowData)it.getKey()).equals(object);
                }
            };
            Pair _findFirst = (Pair)IterableExtensions.findFirst(this.rowGroupMapping, (Functions.Function1)_function);
            List _value = null;
            if (_findFirst != null) {
                _value = (List)_findFirst.getValue();
            }
            return _value;
        }
        return CollectionLiterals.newArrayList();
    }

    public List<TableRowData> getChildren(int index) {
        return this.getChildren(this.getDataAtIndex(index));
    }

    public List<TableRowData> getChildren(TableRowData object, boolean fullDepth) {
        return this.getChildren(object);
    }

    public TableRowData getDataAtIndex(int index) {
        boolean _not;
        boolean _isValidIndex = this.isValidIndex(index);
        boolean bl = _not = !_isValidIndex;
        if (_not) {
            return null;
        }
        return (TableRowData)this.tableContents.get(index);
    }

    @Override
    public int getOriginalRowIndex(int index) {
        List<TableRowData> visbile = this.getVisibleRows();
        boolean _isEmpty = visbile.isEmpty();
        if (_isEmpty) {
            return -1;
        }
        TableRowData treeTableRow = visbile.get(index);
        if (treeTableRow == null || this.isParentRow(treeTableRow)) {
            return -1;
        }
        return treeTableRow.getRow().getRowIndex();
    }

    @Override
    public TableRowData getRow(int tableRowPosition) {
        return this.getVisibleRows().get(tableRowPosition);
    }

    public int getDepthOfData(final TableRowData object) {
        Functions.Function1<TableRowData, Boolean> _function = new Functions.Function1<TableRowData, Boolean>(){

            public Boolean apply(TableRowData it) {
                return it.equals(object);
            }
        };
        TableRowData result = (TableRowData)IterableExtensions.findFirst(this.parentRowMapping, (Functions.Function1)_function);
        int _xifexpression = 0;
        _xifexpression = result != null ? 0 : 1;
        return _xifexpression;
    }

    public int getDepthOfData(int index) {
        return this.getDepthOfData(this.getDataAtIndex(index));
    }

    public int getElementCount() {
        return this.getRowCount();
    }

    public boolean hasChildren(final TableRowData object) {
        if (object != null && this.getDepthOfData(object) == 0) {
            List childs;
            Functions.Function1<Pair<TableRowData, List<TableRowData>>, Boolean> _function = new Functions.Function1<Pair<TableRowData, List<TableRowData>>, Boolean>(){

                public Boolean apply(Pair<TableRowData, List<TableRowData>> it) {
                    TableRowData _key = (TableRowData)it.getKey();
                    return _key == object;
                }
            };
            Pair _findFirst = (Pair)IterableExtensions.findFirst(this.rowGroupMapping, (Functions.Function1)_function);
            List _value = null;
            if (_findFirst != null) {
                _value = (List)_findFirst.getValue();
            }
            return (childs = _value) != null && !childs.isEmpty();
        }
        return false;
    }

    public boolean hasChildren(int index) {
        return this.hasChildren(this.getDataAtIndex(index));
    }

    public int indexOf(TableRowData child) {
        return this.tableContents.indexOf(child);
    }

    public boolean isValidIndex(int index) {
        return index >= 0 && index < this.tableContents.size();
    }

    public TableRowData getParent(final TableRowData row) {
        boolean _hasChildren = this.hasChildren(row);
        if (_hasChildren) {
            return row;
        }
        Functions.Function1<Pair<TableRowData, List<TableRowData>>, Boolean> _function = new Functions.Function1<Pair<TableRowData, List<TableRowData>>, Boolean>(){

            public Boolean apply(Pair<TableRowData, List<TableRowData>> it) {
                return ((List)it.getValue()).contains(row);
            }
        };
        Pair _findFirst = (Pair)IterableExtensions.findFirst(this.rowGroupMapping, (Functions.Function1)_function);
        TableRowData _key = null;
        if (_findFirst != null) {
            _key = (TableRowData)_findFirst.getKey();
        }
        return _key;
    }

    public List<TableRowData> getVisibleRows() {
        Functions.Function1<TableRowData, Boolean> _function = new Functions.Function1<TableRowData, Boolean>(){

            public Boolean apply(TableRowData it) {
                boolean _contains = TreeDataProvider.this.hiddenRowsIndex.contains(it.getRowIndex());
                return !_contains;
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)this.tableContents, (Functions.Function1)_function));
    }

    public static List<ColumnDescriptor> getLeaves(ColumnDescriptor descriptor) {
        boolean _isEmpty = descriptor.getChildren().isEmpty();
        if (_isEmpty) {
            return CollectionLiterals.newLinkedList((Object[])new ColumnDescriptor[]{descriptor});
        }
        Functions.Function1<ColumnDescriptor, List<ColumnDescriptor>> _function = new Functions.Function1<ColumnDescriptor, List<ColumnDescriptor>>(){

            public List<ColumnDescriptor> apply(ColumnDescriptor it) {
                return TreeDataProvider.getLeaves(it);
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.flatMap((Iterable)descriptor.getChildren(), (Functions.Function1)_function));
    }

    @Override
    public void sort(final int column, final Comparator<? super String> comparator) {
        Pair _pair;
        Comparator<Pair<TableRowData, List<TableRowData>>> _function;
        final Comparator<Pair<TableRowData, List<TableRowData>>> rowGroupComparator = _function = new Comparator<Pair<TableRowData, List<TableRowData>>>(){

            @Override
            public int compare(Pair<TableRowData, List<TableRowData>> group1, Pair<TableRowData, List<TableRowData>> group2) {
                TableRowData _xifexpression = null;
                boolean _isEmpty = ((List)group1.getValue()).isEmpty();
                _xifexpression = _isEmpty ? (TableRowData)group1.getKey() : (TableRowData)((List)group1.getValue()).get(0);
                TableRowData compareContent1 = _xifexpression;
                TableRowData _xifexpression_1 = null;
                boolean _isEmpty_1 = ((List)group2.getValue()).isEmpty();
                _xifexpression_1 = _isEmpty_1 ? (TableRowData)group2.getKey() : (TableRowData)((List)group2.getValue()).get(0);
                TableRowData compareContent2 = _xifexpression_1;
                return TreeDataProvider.this.tableRowDataComparator(column, comparator).compare(compareContent1, compareContent2);
            }
        };
        Functions.Function1<Pair<TableRowData, List<TableRowData>>, Pair<TableRowData, List<TableRowData>>> _function_1 = new Functions.Function1<Pair<TableRowData, List<TableRowData>>, Pair<TableRowData, List<TableRowData>>>(){

            public Pair<TableRowData, List<TableRowData>> apply(Pair<TableRowData, List<TableRowData>> it) {
                Comparator<TableRowData> _function = new Comparator<TableRowData>(){

                    @Override
                    public int compare(TableRowData row1, TableRowData row2) {
                        return TreeDataProvider.this.tableRowDataComparator(column, comparator).compare(row1, row2);
                    }
                };
                List childs = IterableExtensions.sortWith((Iterable)((Iterable)it.getValue()), (Comparator)_function);
                TableRowData _key = (TableRowData)it.getKey();
                return new Pair((Object)_key, (Object)childs);
            }
        };
        List sortedChilds = ListExtensions.map(this.rowGroupMapping, (Functions.Function1)_function_1);
        Comparator<Pair<TableRowData, List<TableRowData>>> _function_2 = new Comparator<Pair<TableRowData, List<TableRowData>>>(){

            @Override
            public int compare(Pair<TableRowData, List<TableRowData>> group1, Pair<TableRowData, List<TableRowData>> group2) {
                return rowGroupComparator.compare(group1, group2);
            }
        };
        this.rowGroupMapping = IterableExtensions.sortWith((Iterable)sortedChilds, (Comparator)_function_2);
        Functions.Function1<Pair<TableRowData, List<TableRowData>>, LinkedList<TableRowData>> _function_3 = new Functions.Function1<Pair<TableRowData, List<TableRowData>>, LinkedList<TableRowData>>(){

            public LinkedList<TableRowData> apply(Pair<TableRowData, List<TableRowData>> it) {
                LinkedList newList = CollectionLiterals.newLinkedList((Object[])new TableRowData[]{(TableRowData)it.getKey()});
                newList.addAll((Collection)it.getValue());
                return newList;
            }
        };
        this.tableContents = IterableExtensions.toList((Iterable)IterableExtensions.flatMap(this.rowGroupMapping, (Functions.Function1)_function_3));
        this.currentComparator = _pair = new Pair((Object)column, comparator);
    }

    @Override
    public void applyFilter(Map<Integer, Object> filterIndexToObjectMap) {
        this.filters = filterIndexToObjectMap;
        this.refresh();
        this.refreshRowGroup();
        this.sort();
    }

    public void collasedGroup(int parentIndex) {
        TableRowData parentRow = this.getDataAtIndex(parentIndex);
        if (parentRow == null) {
            return;
        }
        parentRow.setContents(parentRow.getContentsFromRow());
    }

    public void expandedGroup(int parentIndex) {
        TableRowData parentRow = this.getDataAtIndex(parentIndex);
        if (parentRow == null) {
            return;
        }
        TableRow emptyRow = this.tmFactory.newTableRow(parentRow.getRow().getRowIndex(), TableExtensions.getColumns((Table)this.table));
        TableRowExtensions.set((TableRow)emptyRow, (ColumnDescriptor)this.getRowIndexColumn(), (String)TableRowExtensions.getPlainStringValue((TableRow)parentRow.getRow(), (ColumnDescriptor)this.getRowIndexColumn()));
        Functions.Function1<TableCell, CellContent> _function = new Functions.Function1<TableCell, CellContent>(){

            public CellContent apply(TableCell it) {
                return it.getContent();
            }
        };
        parentRow.setContents(IterableExtensions.toList((Iterable)ListExtensions.map((List)emptyRow.getCells(), (Functions.Function1)_function)));
    }

    public Set<Integer> getHiddenRowsIndex() {
        return this.hiddenRowsIndex;
    }

    public void doExpandCollapseCommand(ILayerCommand command) {
        if (command instanceof TreeExpandAllCommand) {
            this.expandAllCommandHandle();
        } else if (command instanceof TreeCollapseAllCommand) {
            this.collapseAllCommandHandle();
        } else if (command instanceof TreeExpandCollapseCommand) {
            this.expandCollapseCommandHandle(((TreeExpandCollapseCommand)command).getParentIndex());
        }
    }

    private void expandCollapseCommandHandle(int parentIndex) {
        TableRowData parentRow = this.getDataAtIndex(parentIndex);
        if (parentRow == null) {
            return;
        }
        Functions.Function1<TableRowData, Integer> _function = new Functions.Function1<TableRowData, Integer>(){

            public Integer apply(TableRowData it) {
                return it.getRowIndex();
            }
        };
        List childsIndex = ListExtensions.map(this.getChildren(parentRow), (Functions.Function1)_function);
        boolean _containsAll = this.hiddenRowsIndex.containsAll(childsIndex);
        if (_containsAll) {
            this.hiddenRowsIndex.removeAll(childsIndex);
        } else {
            this.hiddenRowsIndex.addAll(childsIndex);
        }
    }

    private void collapseAllCommandHandle() {
        Functions.Function1<TableRowData, List<Integer>> _function = new Functions.Function1<TableRowData, List<Integer>>(){

            public List<Integer> apply(TableRowData it) {
                Functions.Function1<TableRowData, Integer> _function = new Functions.Function1<TableRowData, Integer>(){

                    public Integer apply(TableRowData it_1) {
                        return it_1.getRowIndex();
                    }
                };
                return ListExtensions.map(TreeDataProvider.this.getChildren(it), (Functions.Function1)_function);
            }
        };
        this.hiddenRowsIndex.addAll(IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)ListExtensions.map(this.parentRowMapping, (Functions.Function1)_function))));
    }

    private void expandAllCommandHandle() {
        this.hiddenRowsIndex = CollectionLiterals.newHashSet();
    }

    private ColumnDescriptor getRowIndexColumn() {
        Functions.Function1<ColumnDescriptor, Boolean> _function = new Functions.Function1<ColumnDescriptor, Boolean>(){

            public Boolean apply(ColumnDescriptor it) {
                return it.getLabel() != null && it.getLabel().equals("Lfd. Nr.");
            }
        };
        return (ColumnDescriptor)IterableExtensions.findFirst((Iterable)TableExtensions.getColumns((Table)this.table), (Functions.Function1)_function);
    }
}

