/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table.sorting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.set.utils.table.TableDataProvider;

public class TableSortModel
implements ISortModel {
    protected TableDataProvider dataProvider;
    protected SortDirectionEnum[] sortDirections;
    protected boolean[] sorted;
    protected SortDirectionEnum currentSortDirection = SortDirectionEnum.ASC;
    protected int currentSortColumn = -1;

    public TableSortModel(TableDataProvider dataProvider) {
        this.dataProvider = dataProvider;
        int columnCount = dataProvider.getColumnCount();
        this.sortDirections = new SortDirectionEnum[columnCount];
        Arrays.fill(this.sortDirections, SortDirectionEnum.NONE);
        this.sorted = new boolean[columnCount];
        Arrays.fill(this.sorted, false);
    }

    public List<Integer> getSortedColumnIndexes() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        if (this.currentSortColumn > -1) {
            indexes.add(this.currentSortColumn);
        }
        return indexes;
    }

    public boolean isColumnIndexSorted(int columnIndex) {
        return this.sorted[columnIndex];
    }

    public SortDirectionEnum getSortDirection(int columnIndex) {
        return this.sortDirections[columnIndex];
    }

    public int getSortOrder(int columnIndex) {
        return 0;
    }

    public List<Comparator> getComparatorsForColumnIndex(int columnIndex) {
        return null;
    }

    public void sort(int columnIndex, SortDirectionEnum sortDirection, boolean accumulate) {
        if (!this.isColumnIndexSorted(columnIndex)) {
            this.clear();
        }
        this.currentSortDirection = sortDirection.equals((Object)SortDirectionEnum.NONE) ? SortDirectionEnum.ASC : sortDirection;
        this.dataProvider.sort(columnIndex, this.getColumnComparator(columnIndex));
        this.sortDirections[columnIndex] = this.currentSortDirection;
        this.sorted[columnIndex] = true;
        this.currentSortColumn = columnIndex;
    }

    public void clear() {
        Arrays.fill(this.sortDirections, SortDirectionEnum.NONE);
        Arrays.fill(this.sorted, false);
        this.currentSortColumn = -1;
    }

    public Comparator<String> getColumnComparator(int columnIndex) {
        return (text1, text2) -> {
            try {
                int number1 = Integer.parseInt(text1);
                int number2 = Integer.parseInt(text2);
                if (this.currentSortDirection == SortDirectionEnum.ASC) {
                    return Integer.compare(number1, number2);
                }
                return Integer.compare(number2, number1);
            }
            catch (Exception ex) {
                if (this.currentSortDirection == SortDirectionEnum.ASC) {
                    return text1.compareTo((String)text2);
                }
                return text2.compareTo((String)text1);
            }
        };
    }

    public TableDataProvider getTableData() {
        return this.dataProvider;
    }
}

