/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table.sorting;

import java.util.Map;
import java.util.function.UnaryOperator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.model.RowGroupModel;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.command.SortColumnCommand;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeConfiguration;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.ColumnDescriptorExtensions;
import org.eclipse.set.nattable.utils.PlanProTableThemeConfiguration;
import org.eclipse.set.utils.table.BodyLayerStack;
import org.eclipse.set.utils.table.TableDataProvider;
import org.eclipse.set.utils.table.menu.TableMenuService;
import org.eclipse.set.utils.table.sorting.TableSortModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractSortByColumnTables {
    public TableDataProvider bodyDataProvider;
    public BodyLayerStack bodyLayerStack;
    protected DataLayer bodyDataLayer;
    protected RowGroupModel<TableRow> rowGroupModel;

    protected void createTableBodyData(Table table, UnaryOperator<Integer> getSourceLine) {
        this.bodyDataProvider = new TableDataProvider(table, getSourceLine);
        this.bodyDataLayer = new DataLayer((IDataProvider)this.bodyDataProvider);
        this.bodyLayerStack = new BodyLayerStack(this.bodyDataLayer);
    }

    protected SelectionLayer getSelectionLayer() {
        return this.bodyLayerStack.getSelectionLayer();
    }

    protected NatTable createTable(Composite parent, Table tableModel, TableMenuService tableMenuService) {
        ColumnDescriptor rootColumnDescriptor = (ColumnDescriptor)tableModel.getColumndescriptors().get(0);
        if (this.bodyDataProvider == null || this.bodyLayerStack == null) {
            this.createTableBodyData(tableModel, null);
        }
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(ColumnDescriptorExtensions.getColumnLabels((ColumnDescriptor)rootColumnDescriptor));
        DataLayer columnHeaderDataLayer = new DataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)this.bodyLayerStack, this.getSelectionLayer());
        SortHeaderLayer<BodyLayerStack> sortHeaderLayer = this.creatSortColumnHeaderLayer(columnHeaderLayer);
        ConfigRegistry configRegistry = new ConfigRegistry();
        GridLayer gridLayer = this.createGridLayer((IDataProvider)columnHeaderDataProvider, columnHeaderDataLayer, sortHeaderLayer, configRegistry);
        NatTable natTable = this.createNattable(parent, tableMenuService, rootColumnDescriptor, columnHeaderDataLayer, configRegistry, gridLayer);
        this.getSelectionLayer().clear();
        natTable.doCommand((ILayerCommand)new SortColumnCommand(sortHeaderLayer, 0, SortDirectionEnum.ASC));
        return natTable;
    }

    protected SortHeaderLayer<BodyLayerStack> creatSortColumnHeaderLayer(ColumnHeaderLayer columnHeaderLayer) {
        return new SortHeaderLayer((ILayer)columnHeaderLayer, (ISortModel)new TableSortModel(this.bodyDataProvider), true);
    }

    private GridLayer createGridLayer(IDataProvider columnHeaderDataProvider, DataLayer columnHeaderDataLayer, SortHeaderLayer<BodyLayerStack> sortHeaderLayer, ConfigRegistry configRegistry) {
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)this.bodyDataProvider);
        DataLayer rowHeaderDataLayer = new DataLayer((IDataProvider)rowHeaderDataProvider, 0, 20);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)this.bodyLayerStack, this.getSelectionLayer());
        FilterRowHeaderComposite<Object> filterRowHeaderLayer = this.createFilterRowHeader(sortHeaderLayer, columnHeaderDataLayer, configRegistry);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider(columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, filterRowHeaderLayer);
        return new GridLayer((ILayer)this.bodyLayerStack, filterRowHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
    }

    protected FilterRowHeaderComposite<Object> createFilterRowHeader(SortHeaderLayer<BodyLayerStack> sortHeaderLayer, DataLayer columnHeaderDataLayer, ConfigRegistry configRegistry) {
        return new FilterRowHeaderComposite(new FilterStrategy(this.bodyDataProvider), sortHeaderLayer, columnHeaderDataLayer.getDataProvider(), (IConfigRegistry)configRegistry);
    }

    protected NatTable createNattable(Composite parent, TableMenuService tableMenuService, ColumnDescriptor rootColumnDescriptor, DataLayer columnHeaderDataLayer, ConfigRegistry configRegistry, GridLayer gridLayer) {
        NatTable natTable = new NatTable(parent, 537133824, (ILayer)gridLayer, false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        if (tableMenuService != null) {
            natTable.addConfiguration((IConfiguration)tableMenuService.createMenuConfiguration(natTable, this.getSelectionLayer()));
        }
        natTable.configure();
        natTable.setTheme((ThemeConfiguration)new PlanProTableThemeConfiguration(natTable, (AbstractLayer)columnHeaderDataLayer, this.bodyDataLayer, gridLayer, rootColumnDescriptor, (AbstractLayer)this.bodyLayerStack, (IDataProvider)this.bodyDataProvider));
        return natTable;
    }

    class FilterStrategy<T>
    implements IFilterStrategy<T> {
        private final TableDataProvider tableDataProvider;

        public FilterStrategy(TableDataProvider tableDataProvider) {
            this.tableDataProvider = tableDataProvider;
        }

        public void applyFilter(Map<Integer, Object> filterIndexToObjectMap) {
            this.tableDataProvider.applyFilter(filterIndexToObjectMap);
        }
    }
}

