/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table;

import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.utils.events.SelectedRowEvent;
import org.eclipse.set.utils.events.ToolboxEvent;
import org.eclipse.set.utils.events.ToolboxEvents;

public class RowSelectionListener
extends AbstractUiBindingConfiguration {
    private int tmpRowPosition = -1;
    IEventBroker broker;
    List<TableRow> rows;
    SelectionLayer selectionLayer;
    String table;

    public RowSelectionListener(String table, SelectionLayer selectionLayer, List<TableRow> rows, IEventBroker broker) {
        this.table = table;
        this.selectionLayer = selectionLayer;
        this.broker = broker;
        this.rows = rows;
    }

    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        if (this.rows.isEmpty()) {
            return;
        }
        uiBindingRegistry.registerFirstSingleClickBinding((IMouseEventMatcher)MouseEventMatcher.bodyLeftClick((int)0), (natTable, event) -> {
            if (this.selectionLayer.getSelectedCells().isEmpty()) {
                ToolboxEvents.send((IEventBroker)this.broker, (ToolboxEvent)new SelectedRowEvent(this.table, null));
                return;
            }
            int rowPosition = ((ILayerCell)this.selectionLayer.getSelectedCells().iterator().next()).getRowPosition();
            if (this.tmpRowPosition == rowPosition) {
                ToolboxEvents.send((IEventBroker)this.broker, (ToolboxEvent)new SelectedRowEvent(this.table, null));
                this.tmpRowPosition = -1;
                this.selectionLayer.clear();
                return;
            }
            TableRow row = this.rows.get(rowPosition);
            this.tmpRowPosition = rowPosition;
            ToolboxEvents.send((IEventBroker)this.broker, (ToolboxEvent)new SelectedRowEvent(this.table, row));
        });
    }
}

