/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.dialogservice;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.ProjectInitializationData;
import org.eclipse.set.basis.Wrapper;
import org.eclipse.set.basis.exceptions.ErrorStatus;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.files.ToolboxFileFilter;
import org.eclipse.set.basis.files.ToolboxFileFilterBuilder;
import org.eclipse.set.basis.rename.RenameConfirmation;
import org.eclipse.set.core.Messages;
import org.eclipse.set.core.dialogservice.ConfirmDialog;
import org.eclipse.set.core.dialogservice.ExceptionTransformation;
import org.eclipse.set.core.dialogservice.LoadIncompleteFileDialog;
import org.eclipse.set.core.dialogservice.LoadInvalidFileDialog;
import org.eclipse.set.core.dialogservice.ProjectFilenameInitialization;
import org.eclipse.set.core.dialogservice.ReportSavedSessionDialog;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.core.services.files.ToolboxFileService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DialogServiceCommonImpl
implements DialogService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialogService.class);
    private List<ToolboxFileFilter> csvFileFilters;
    private List<ToolboxFileFilter> dokumentFileFilters;
    private List<ToolboxFileFilter> fileFiltersForAllFiles;
    @Inject
    private ToolboxFileService fileService;
    private List<ToolboxFileFilter> imageFileFilters;
    private List<ToolboxFileFilter> modelFileFilters;
    private List<ToolboxFileFilter> planProFileFilters;
    private List<ToolboxFileFilter> xlsxFileFilters;
    @Inject
    @Translation
    Messages messages;
    @Inject
    UISynchronize sync;
    @Inject
    @Translation
    org.eclipse.set.utils.Messages utilMessages;

    public boolean confirmClose(Shell shell) {
        ConfirmDialog confirmDialog = new ConfirmDialog(shell, this.messages.WindowCloseAddon_ConfirmTitle, this.messages.WindowCloseAddon_CloseMessage, this.messages.DialogService_CloseLabel);
        return confirmDialog.confirmed();
    }

    public boolean confirmCloseUnsaved(Shell shell) {
        ConfirmDialog confirmDialog = new ConfirmDialog(shell, this.messages.WindowCloseAddon_ConfirmTitle, this.messages.WindowCloseAddon_CloseUnsavedMessage, this.messages.DialogService_CloseUnsavedLabel);
        return confirmDialog.confirmed();
    }

    public boolean confirmCreateDirectory(Shell shell, Path path) {
        ConfirmDialog confirmDialog = new ConfirmDialog(shell, this.messages.DialogService_ConfirmCreateDirectory_Title, String.format(this.messages.DialogService_ConfirmCreateDirectory_MessagePattern, path.toString()), this.messages.DialogService_ConfirmCreateDirectory_ConfirmLabel);
        return confirmDialog.confirmed();
    }

    public boolean confirmDeletion(Shell shell, Path path) {
        final ConfirmDialog confirmDialog = new ConfirmDialog(shell, this.utilMessages.Dialogs_confirmDeletionTitle, String.format(this.utilMessages.Dialogs_confirmDeletionMessagePattern, path.getFileName().toString()), this.messages.DialogService_ConfirmDeleteLabel);
        final Wrapper result = new Wrapper();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result.setValue((Object)confirmDialog.confirmed());
            }
        });
        return (Boolean)result.getValue();
    }

    public boolean confirmOverwrite(Shell shell, Path path) {
        final ConfirmDialog confirmDialog = new ConfirmDialog(shell, this.utilMessages.Dialogs_confirmOverwriteTitle, String.format(this.utilMessages.Dialogs_confirmOverwriteMessagePattern, path.getFileName().toString()), this.utilMessages.Dialogs_confirmOverwriteLabel);
        final Wrapper result = new Wrapper();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result.setValue((Object)confirmDialog.confirmed());
            }
        });
        return (Boolean)result.getValue();
    }

    public boolean confirmOverwriteOperationalData(Shell shell) {
        ConfirmDialog confirmDialog = new ConfirmDialog(shell, this.messages.DialogService_ConfirmOverwriteOperationalData_Title, this.messages.DialogService_ConfirmOverwriteOperationalData_Message, this.messages.DialogService_ConfirmOverwriteOperationalData_ConfirmLabel);
        return confirmDialog.confirmed();
    }

    public boolean confirmOverwriteUnsaved(Shell shell, String title, String mess) {
        ConfirmDialog confirmDialog = new ConfirmDialog(shell, title, mess, this.messages.DialogService_ConfirmOverwriteOperationalData_ConfirmLabel);
        return confirmDialog.confirmed();
    }

    public RenameConfirmation confirmRename(Shell shell, String oldFilename, String newFilename) {
        MessageDialog messageDialog = new MessageDialog(shell, this.messages.DialogService_ConfirmRename_Title, null, String.format(this.messages.DialogService_ConfirmRename_MessagePattern, oldFilename, newFilename), 5, new String[]{this.messages.DialogService_ConfirmRename_ChangeLabel, this.messages.DialogService_ConfirmRename_NewLabel, JFaceResources.getString((String)"cancel")}, 2);
        return RenameConfirmation.fromDialogResult((int)messageDialog.open());
    }

    public boolean confirmSetDefaultsManagement(Shell shell) {
        return MessageDialog.openQuestion((Shell)shell, (String)this.messages.DialogService_ConfirmFillDefaults_Title, (String)this.messages.DialogService_ConfirmFillDefaults_Label);
    }

    public void error(Shell shell, Exception e) {
        LOGGER.error(e.getMessage(), (Throwable)e);
        ErrorStatus status = new ExceptionTransformation(this.messages).transform(e, null);
        this.sync.syncExec(() -> {
            int n = ErrorDialog.openError((Shell)shell, (String)status.getErrorTitle(), (String)status.getUserMessage(), (IStatus)status.getStatus());
        });
    }

    public void error(Shell shell, String message) {
        LOGGER.error(message);
        ErrorStatus status = new ExceptionTransformation(this.messages).transform(null, null);
        this.sync.syncExec(() -> {
            int n = ErrorDialog.openError((Shell)shell, (String)status.getErrorTitle(), (String)message, (IStatus)status.getStatus());
        });
    }

    public void error(Shell shell, String title, String message, Exception e) {
        LOGGER.error(e.getMessage(), (Throwable)e);
        this.sync.syncExec(() -> {
            int n = ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)new ExceptionTransformation(this.messages).transform(e, null).getStatus());
        });
    }

    public void error(Shell shell, String title, String message, String technicalMsg, Exception e) {
        LOGGER.error(e.getMessage(), (Throwable)e);
        this.sync.syncExec(() -> {
            int n = ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)new ExceptionTransformation(this.messages).transform(e, technicalMsg).getStatus());
        });
    }

    public List<ToolboxFileFilter> getCsvFileFilters() {
        return this.csvFileFilters;
    }

    public List<ToolboxFileFilter> getDokumentFileFilters() {
        return this.dokumentFileFilters;
    }

    public List<ToolboxFileFilter> getFileFiltersForAllFiles() {
        return this.fileFiltersForAllFiles;
    }

    public List<ToolboxFileFilter> getImageFileFilters() {
        return this.imageFileFilters;
    }

    public List<ToolboxFileFilter> getModelFileFilters() {
        return this.modelFileFilters;
    }

    public List<ToolboxFileFilter> getPlanProFileFilters() {
        return this.planProFileFilters;
    }

    public List<ToolboxFileFilter> getXlsxFileFilters() {
        return this.xlsxFileFilters;
    }

    public boolean loadIncompleteModel(Shell shell, String filename) {
        LoadIncompleteFileDialog validationDialog = new LoadIncompleteFileDialog(shell, this.messages, filename);
        int result = validationDialog.open();
        validationDialog.close();
        return result == 0;
    }

    public boolean loadInvalidModel(Shell shell, String filename) {
        LoadInvalidFileDialog validationDialog = new LoadInvalidFileDialog(shell, this.messages, filename);
        int result = validationDialog.open();
        validationDialog.close();
        return result == 0;
    }

    public void openInformation(Shell shell, String title, String message) {
        MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
    }

    public int projectInitialization(Shell shell, BiPredicate<Shell, ProjectInitializationData> initAction) {
        ProjectFilenameInitialization dialog = new ProjectFilenameInitialization(shell, this.messages, this);
        dialog.setInitAction(initAction);
        dialog.setCreateDirectoryPermission((dialogShell, path) -> this.confirmCreateDirectory((Shell)dialogShell, (Path)path));
        return dialog.open();
    }

    public void reportExported(Shell shell) {
        MessageDialog.openInformation((Shell)shell, (String)this.messages.DialogService_ReportExported_Title, (String)this.messages.DialogService_ReportExported_Message);
    }

    public void reportImported(Shell shell) {
        MessageDialog.openInformation((Shell)shell, (String)this.messages.DialogService_ReportImported_Title, (String)this.messages.DialogService_ReportImported_Message);
    }

    public void reportSavedFile(Shell shell, Path path) {
        MessageDialog.openInformation((Shell)shell, (String)this.utilMessages.AttachmentTable_fileSaveSuccess, (String)String.format(this.utilMessages.AttachmentTable_fileSuccessfullySavedPattern, path.toString()));
    }

    public void reportSavedSession(Shell shell, IModelSession session) {
        ReportSavedSessionDialog dialog = new ReportSavedSessionDialog(shell, session, this.messages);
        dialog.open();
    }

    public void showDistance(Shell shell, double distance) {
        MessageDialog.openInformation((Shell)shell, (String)this.messages.DialogService_ShowDistance_Title, (String)String.format(this.messages.DialogService_ShowDistance_DistancePattern, distance));
    }

    public void showProgress(Shell shell, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        new ProgressMonitorDialog(shell).run(true, false, runnable);
    }

    public void showProgressUISync(Shell shell, String message, Runnable runnable) {
        MessageDialog dialog = new MessageDialog(shell, this.messages.DialogService_ProgressUISyncTitle, null, message, 2, new String[0], 0);
        dialog.setBlockOnOpen(false);
        dialog.open();
        this.sync.syncExec(runnable);
        dialog.close();
    }

    @PostConstruct
    private void postConstruct() {
        this.modelFileFilters = Lists.newLinkedList();
        this.modelFileFilters.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_ModelFilterName).add((Iterable)this.fileService.extensionsForCategory("ppfile")).filterNameWithFilterList(true).create());
        this.planProFileFilters = Lists.newLinkedList();
        this.planProFileFilters.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_PlanProFilterName).add((Iterable)this.fileService.extensionsForCategory("ppall")).filterNameWithFilterList(true).create());
        this.planProFileFilters.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_ModelFilterName).add((Iterable)this.fileService.extensionsForCategory("ppfile")).filterNameWithFilterList(true).create());
        this.planProFileFilters.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_MergeFilterName).add((Iterable)this.fileService.extensionsForCategory("ppmerge")).filterNameWithFilterList(true).create());
        this.csvFileFilters = Lists.newLinkedList();
        this.csvFileFilters.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_CsvFilterName).add((Iterable)PathExtensions.CSV_FILE_EXTENSIONS).filterNameWithFilterList(true).create());
        this.imageFileFilters = Lists.newLinkedList();
        this.imageFileFilters.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_ImagesFilterName).add((Iterable)PathExtensions.IMAGE_FILE_EXTENSIONS).filterNameWithFilterList(true).create());
        this.dokumentFileFilters = Lists.newLinkedList();
        this.dokumentFileFilters.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_DokumentFilterName).add((Iterable)PathExtensions.DOKUMENT_FILE_EXTENSIONS).filterNameWithFilterList(true).create());
        this.xlsxFileFilters = Lists.newLinkedList();
        this.xlsxFileFilters.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_XlsxFilterName).add((Iterable)PathExtensions.EXCEL_FILE_EXTENSION).filterNameWithFilterList(true).create());
        this.fileFiltersForAllFiles = Lists.newLinkedList();
        this.fileFiltersForAllFiles.add(ToolboxFileFilterBuilder.forName((String)this.messages.DialogService_FilterForAllFiles).add((Iterable)PathExtensions.ALL_FILE_EXTENSION).filterNameWithFilterList(true).create());
    }

    protected String getPlanningDescription(boolean isPrimaryValid, boolean isSecondaryValid) {
        if (!isPrimaryValid && !isSecondaryValid) {
            return this.messages.DialogService_PlanningDescriptionPrimaryAndSecondary;
        }
        if (!isPrimaryValid) {
            return this.messages.DialogService_PlanningDescriptionPrimary;
        }
        if (!isSecondaryValid) {
            return this.messages.DialogService_PlanningDescriptionSecondary;
        }
        throw new IllegalArgumentException("isPrimaryValid=" + isPrimaryValid + " isSecondaryValid=" + isSecondaryValid);
    }
}

