/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.tablemodel.extensions;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.model.tablemodel.CellContent;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.Footnote;
import org.eclipse.set.model.tablemodel.MultiColorCellContent;
import org.eclipse.set.model.tablemodel.MultiColorContent;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.StringCellContent;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.TablemodelFactory;
import org.eclipse.set.model.tablemodel.extensions.ColumnDescriptorExtensions;
import org.eclipse.set.model.tablemodel.extensions.RowGroupExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableCellExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableContentExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Ur_Objekt;
import org.eclipse.set.utils.StringExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class TableRowExtensions {
    public static String getRichTextValue(TableRow row, int columnIndex) {
        TableCell cell = (TableCell)row.getCells().get(columnIndex);
        if (cell == null || cell.getContent() == null) {
            return null;
        }
        return TableCellExtensions.getRichTextValue(cell);
    }

    public static String getRichTextValue(TableRow row, final String label) {
        Functions.Function1<TableCell, Boolean> _function = new Functions.Function1<TableCell, Boolean>(){

            public Boolean apply(TableCell it) {
                String _label = it.getColumndescriptor().getLabel();
                return Objects.equal((Object)_label, (Object)label);
            }
        };
        TableCell _findFirst = (TableCell)IterableExtensions.findFirst((Iterable)row.getCells(), (Functions.Function1)_function);
        String _richTextValue = null;
        if (_findFirst != null) {
            _richTextValue = TableCellExtensions.getRichTextValue(_findFirst);
        }
        return _richTextValue;
    }

    public static String getPlainStringValue(TableRow row, final String label) {
        Functions.Function1<TableCell, Boolean> _function = new Functions.Function1<TableCell, Boolean>(){

            public Boolean apply(TableCell it) {
                String _label = it.getColumndescriptor().getLabel();
                return Objects.equal((Object)_label, (Object)label);
            }
        };
        TableCell _findFirst = (TableCell)IterableExtensions.findFirst((Iterable)row.getCells(), (Functions.Function1)_function);
        String _plainStringValue = null;
        if (_findFirst != null) {
            _plainStringValue = TableCellExtensions.getPlainStringValue(_findFirst);
        }
        return _plainStringValue;
    }

    public static String getPlainStringValue(TableRow row, int columnIndex) {
        TableCell tableCell = (TableCell)row.getCells().get(columnIndex);
        if (tableCell == null || tableCell.getContent() == null) {
            return null;
        }
        return TableCellExtensions.getPlainStringValue(tableCell);
    }

    public static String getPlainStringValue(TableRow row, ColumnDescriptor column) {
        return TableCellExtensions.getPlainStringValue(TableRowExtensions.getCell(row, column));
    }

    public static void set(TableRow row, int columnIndex, String value) {
        StringCellContent newContent = TablemodelFactory.eINSTANCE.createStringCellContent();
        EList _value = newContent.getValue();
        if (_value != null) {
            _value.add((Object)value);
        }
        TableCell _get = (TableCell)row.getCells().get(columnIndex);
        _get.setContent((CellContent)newContent);
    }

    public static void set(TableRow row, ColumnDescriptor column, String value) {
        StringCellContent newContent = TablemodelFactory.eINSTANCE.createStringCellContent();
        EList _value = newContent.getValue();
        if (_value != null) {
            _value.add((Object)value);
        }
        TableCell _cell = TableRowExtensions.getCell(row, column);
        _cell.setContent((CellContent)newContent);
    }

    public static void set(TableRow row, ColumnDescriptor column, Iterable<String> value, String separator) {
        StringCellContent newContent = TablemodelFactory.eINSTANCE.createStringCellContent();
        EList _value = newContent.getValue();
        if (_value != null) {
            Iterables.addAll((Collection)_value, value);
        }
        newContent.setSeparator(separator);
        TableCell _cell = TableRowExtensions.getCell(row, column);
        _cell.setContent((CellContent)newContent);
    }

    public static void set(TableRow row, ColumnDescriptor column, List<MultiColorContent> contents, String seperator) {
        MultiColorCellContent newContent = TablemodelFactory.eINSTANCE.createMultiColorCellContent();
        newContent.getValue().addAll(contents);
        newContent.setSeparator(seperator);
        TableCell _cell = TableRowExtensions.getCell(row, column);
        _cell.setContent((CellContent)newContent);
    }

    public static void set(TableRow row, final String columnLabel, String value) {
        Functions.Function1<TableCell, Boolean> _function = new Functions.Function1<TableCell, Boolean>(){

            public Boolean apply(TableCell it) {
                String _label = it.getColumndescriptor().getLabel();
                return Objects.equal((Object)_label, (Object)columnLabel);
            }
        };
        TableCell column = (TableCell)IterableExtensions.findFirst((Iterable)row.getCells(), (Functions.Function1)_function);
        StringCellContent newContent = TablemodelFactory.eINSTANCE.createStringCellContent();
        EList _value = newContent.getValue();
        if (_value != null) {
            _value.add((Object)value);
        }
        column.setContent((CellContent)newContent);
    }

    public static TableCell getCell(TableRow row, ColumnDescriptor column) {
        EList _cells = row.getCells();
        for (TableCell cell : _cells) {
            if (!Objects.equal((Object)cell.getColumndescriptor(), (Object)column) && !ColumnDescriptorExtensions.isDescendantOf(cell.getColumndescriptor(), column)) continue;
            return cell;
        }
        String _label = column.getLabel();
        String _plus = "no column found: " + _label;
        throw new IllegalArgumentException(_plus);
    }

    public static List<ColumnDescriptor> getColumnDescriptors(TableRow row) {
        Functions.Function1<TableCell, ColumnDescriptor> _function = new Functions.Function1<TableCell, ColumnDescriptor>(){

            public ColumnDescriptor apply(TableCell it) {
                return it.getColumndescriptor();
            }
        };
        return ListExtensions.map((List)row.getCells(), (Functions.Function1)_function);
    }

    public static RowGroup getGroup(TableRow row) {
        EObject _eContainer = row.eContainer();
        return (RowGroup)_eContainer;
    }

    public static Table getTable(TableRow row) {
        return RowGroupExtensions.getTable(TableRowExtensions.getGroup(row));
    }

    public static boolean isEqual(TableRow row, final TableRow other) {
        int _size_1;
        boolean _notEquals;
        int _size = row.getCells().size();
        boolean bl = _notEquals = _size != (_size_1 = other.getCells().size());
        if (_notEquals) {
            return false;
        }
        Functions.Function1<Pair<Integer, TableCell>, Boolean> _function = new Functions.Function1<Pair<Integer, TableCell>, Boolean>(){

            public Boolean apply(Pair<Integer, TableCell> it) {
                return TableCellExtensions.isEqual((TableCell)it.getValue(), (TableCell)other.getCells().get(((Integer)it.getKey()).intValue()));
            }
        };
        return IterableExtensions.forall((Iterable)IterableExtensions.indexed((Iterable)row.getCells()), (Functions.Function1)_function);
    }

    public static List<CellContent> getContent(TableRow row) {
        final Map<ColumnDescriptor, CellContent> contentMap = TableRowExtensions.createContentMap(row);
        Functions.Function1<ColumnDescriptor, CellContent> _function = new Functions.Function1<ColumnDescriptor, CellContent>(){

            public CellContent apply(ColumnDescriptor it) {
                return (CellContent)contentMap.get(it);
            }
        };
        return ListExtensions.map(TableExtensions.getColumns(TableContentExtensions.getTable(RowGroupExtensions.getContent(TableRowExtensions.getGroup(row)))), (Functions.Function1)_function);
    }

    public static String getFootnoteText(TableRow row) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1<Footnote, Integer> _function = new Functions.Function1<Footnote, Integer>(){

            public Integer apply(Footnote it) {
                return it.getNumber();
            }
        };
        List _sortBy = IterableExtensions.sortBy((Iterable)row.getFootnotes(), (Functions.Function1)_function);
        boolean _hasElements = false;
        for (Footnote footnote : _sortBy) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            _builder.append("*");
            int _number = footnote.getNumber();
            _builder.append((Object)_number);
        }
        return _builder.toString();
    }

    public static int getMaxFootnoteNumber(TableRow row) {
        Functions.Function2<Integer, Footnote, Integer> _function = new Functions.Function2<Integer, Footnote, Integer>(){

            public Integer apply(Integer n, Footnote f) {
                return Math.max(n, f.getNumber());
            }
        };
        return (Integer)IterableExtensions.fold((Iterable)row.getFootnotes(), (Object)0, (Functions.Function2)_function);
    }

    public static String getLeadingObjectGuid(TableRow tableRow) {
        Ur_Objekt _leadingObject = TableRowExtensions.getGroup(tableRow).getLeadingObject();
        Identitaet_TypeClass _identitaet = null;
        if (_leadingObject != null) {
            _identitaet = _leadingObject.getIdentitaet();
        }
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        return _wert;
    }

    public static String toDebugString(TableRow row, int groupNumber, int columnWidth) {
        boolean _tripleNotEquals;
        EObject _eContainer = row.eContainer();
        boolean bl = _tripleNotEquals = _eContainer != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            String _paddedString = StringExtensions.toPaddedString((String)Integer.valueOf(groupNumber).toString(), (int)3);
            _builder.append(_paddedString);
            _builder.append(" ");
            String _paddedString_1 = StringExtensions.toPaddedString((String)TableRowExtensions.getLeadingObjectGuid(row), (int)columnWidth);
            _builder.append(_paddedString_1);
            _builder.append(" ");
            EList _cells = row.getCells();
            boolean _hasElements = false;
            for (TableCell cell : _cells) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)" ", "");
                }
                String _paddedString_2 = StringExtensions.toPaddedString((String)TableCellExtensions.getPlainStringValue(cell), (int)columnWidth);
                _builder.append(_paddedString_2);
            }
            return _builder.toString();
        }
        return "detached row";
    }

    private static Map<ColumnDescriptor, CellContent> createContentMap(TableRow row) {
        final HashMap<ColumnDescriptor, CellContent> result = new HashMap<ColumnDescriptor, CellContent>();
        Consumer<TableCell> _function = new Consumer<TableCell>(){

            @Override
            public void accept(TableCell it) {
                result.put(it.getColumndescriptor(), it.getContent());
            }
        };
        row.getCells().forEach((Consumer)_function);
        return result;
    }
}

