/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.utils;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.set.model.validationreport.ObjectScope;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidationObjectScopeProvider {
    private static final String NODE_AUSGABE_FACHDATEN = "Ausgabe_Fachdaten";
    private static final String NODE_IDENTITAET = "Identitaet";
    private static final String NODE_WERT = "Wert";
    private static final String XPATH_PLANUNGSBEREICH = "//ID_LST_Objekt_Planungsbereich/Wert/text()";
    private List<String> guidPlanungsbereichCache;

    private static String findNearestNodeGUID(Node node) {
        Node firstChild;
        Node valueNode;
        if (node == null) {
            return null;
        }
        Node identitaet = ValidationObjectScopeProvider.getChildNodeByName(node, NODE_IDENTITAET);
        if (identitaet != null && (valueNode = ValidationObjectScopeProvider.getChildNodeByName(identitaet, NODE_WERT)) != null && (firstChild = valueNode.getFirstChild()) != null) {
            return firstChild.getNodeValue();
        }
        return ValidationObjectScopeProvider.findNearestNodeGUID(node.getParentNode());
    }

    private static Node getChildNodeByName(Node node, String name) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeName().equals(name)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    private static boolean isFachdaten(Node node) {
        if (node == null) {
            return false;
        }
        String nodeName = node.getNodeName();
        if (nodeName != null && nodeName.equals(NODE_AUSGABE_FACHDATEN)) {
            return true;
        }
        return ValidationObjectScopeProvider.isFachdaten(node.getParentNode());
    }

    public ObjectScope getObjectScope(Node node) {
        if (node == null) {
            return ObjectScope.UNKNOWN;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return ObjectScope.UNKNOWN;
        }
        if (!ValidationObjectScopeProvider.isFachdaten(node)) {
            return ObjectScope.UNKNOWN;
        }
        String guid = ValidationObjectScopeProvider.findNearestNodeGUID(node);
        if (guid == null) {
            return ObjectScope.UNKNOWN;
        }
        if (this.isGUIDInLSTPlanungsbereich(node, guid)) {
            return ObjectScope.PLAN;
        }
        return ObjectScope.BETRACHTUNG;
    }

    private boolean isGUIDInLSTPlanungsbereich(Node node, String guid) {
        if (this.guidPlanungsbereichCache == null) {
            this.guidPlanungsbereichCache = new ArrayList<String>();
            XPath xPath = XPathFactory.newInstance().newXPath();
            String expression = String.format(XPATH_PLANUNGSBEREICH, guid);
            try {
                NodeList nodeList = (NodeList)xPath.compile(expression).evaluate(node.getOwnerDocument(), XPathConstants.NODESET);
                int i = 0;
                while (i < nodeList.getLength()) {
                    Node entry = nodeList.item(i);
                    this.guidPlanungsbereichCache.add(entry.getNodeValue());
                    ++i;
                }
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
        }
        return this.guidPlanungsbereichCache.contains(guid);
    }
}

