/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.utils;

import java.io.IOException;
import java.nio.file.Path;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.feature.validation.utils.ValidationAttributeNameProvider;
import org.eclipse.set.feature.validation.utils.ValidationObjectScopeProvider;
import org.eclipse.set.feature.validation.utils.ValidationObjectStateProvider;
import org.eclipse.set.feature.validation.utils.ValidationObjectTypeProvider;
import org.eclipse.set.model.validationreport.ObjectScope;
import org.eclipse.set.model.validationreport.ObjectState;
import org.eclipse.set.utils.xml.LineNumberXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ObjectMetadataXMLReader {
    private static final String METADATA_READER_KEY = "metadataReader";
    private final Path documentPath;
    private final ValidationObjectTypeProvider validationObjectTypeProvider;
    private final ValidationObjectScopeProvider validationObjectScopeProvider;
    private final ValidationObjectStateProvider validationObjectStateProvider;
    private final ValidationAttributeNameProvider validationAttributeNameProvider;

    public static Document read(ToolboxFile toolboxFile, Path docPath) throws IOException, SAXException, ParserConfigurationException {
        if (docPath == null) {
            return null;
        }
        String docName = PathExtensions.getBaseFileName((Path)docPath);
        Document document = toolboxFile.getXMLDocument(docName);
        if (document == null) {
            ObjectMetadataXMLReader reader = new ObjectMetadataXMLReader(docPath);
            document = reader.read();
            toolboxFile.setXMLDocument(PathExtensions.getBaseFileName((Path)docPath), document);
        }
        return document;
    }

    private Document read() throws IOException, SAXException, ParserConfigurationException {
        Document document = LineNumberXMLReader.read((Path)this.documentPath);
        document.setUserData(METADATA_READER_KEY, this, null);
        return document;
    }

    private ObjectMetadataXMLReader(Path path) {
        this.documentPath = path;
        this.validationObjectScopeProvider = new ValidationObjectScopeProvider();
        this.validationObjectStateProvider = new ValidationObjectStateProvider();
        this.validationObjectTypeProvider = new ValidationObjectTypeProvider();
        this.validationAttributeNameProvider = new ValidationAttributeNameProvider();
    }

    public static ObjectScope getObjectScope(Node node) {
        ObjectMetadataXMLReader metadata = ObjectMetadataXMLReader.getMetadataReader(node);
        return metadata.validationObjectScopeProvider.getObjectScope(node);
    }

    public static String getObjectScopeLiteral(Node node) {
        return ObjectMetadataXMLReader.getObjectScope(node).getLiteral();
    }

    public static String getObjectType(Node node) {
        ObjectMetadataXMLReader metadata = ObjectMetadataXMLReader.getMetadataReader(node);
        return metadata.validationObjectTypeProvider.getObjectType(node);
    }

    public static ObjectState getObjectState(Node node) {
        ObjectMetadataXMLReader metadata = ObjectMetadataXMLReader.getMetadataReader(node);
        return metadata.validationObjectStateProvider.getObjectState(node);
    }

    public static String getAttributeName(Node node) {
        ObjectMetadataXMLReader metadata = ObjectMetadataXMLReader.getMetadataReader(node);
        return metadata.validationAttributeNameProvider.getAttributeName(node);
    }

    private static ObjectMetadataXMLReader getMetadataReader(Node node) {
        return (ObjectMetadataXMLReader)node.getOwnerDocument().getUserData(METADATA_READER_KEY);
    }
}

