/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.tablediff;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.set.model.tablemodel.CellContent;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.CompareCellContent;
import org.eclipse.set.model.tablemodel.Footnote;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.StringCellContent;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.TablemodelFactory;
import org.eclipse.set.model.tablemodel.extensions.TableCellExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.services.table.TableDiffService;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Ur_Objekt;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
public class CustomTableDiffService
implements TableDiffService {
    private static void addEmptyValue(TableRow row, ColumnDescriptor descriptor) {
        TableCell cell = TablemodelFactory.eINSTANCE.createTableCell();
        cell.setColumndescriptor(descriptor);
        StringCellContent content = TablemodelFactory.eINSTANCE.createStringCellContent();
        content.getValue().add((Object)"");
        cell.setContent((CellContent)content);
        row.getCells().add((Object)cell);
    }

    private static void addMissingRowGroup(RowGroup group, Table table) {
        int groupId;
        RowGroup match;
        Identitaet_TypeClass identitaet;
        String groupGuid = null;
        Ur_Objekt leadingObject = group.getLeadingObject();
        if (leadingObject != null && (identitaet = leadingObject.getIdentitaet()) != null) {
            groupGuid = identitaet.getWert();
        }
        if ((match = TableExtensions.getGroupById((Table)table, groupGuid, (int)(groupId = group.getLeadingObjectIndex()))) == null) {
            RowGroup newRowGroup = TablemodelFactory.eINSTANCE.createRowGroup();
            newRowGroup.setLeadingObject(group.getLeadingObject());
            newRowGroup.setLeadingObjectIndex(group.getLeadingObjectIndex());
            int i = 0;
            while (i < group.getRows().size()) {
                TableRow newRow = TablemodelFactory.eINSTANCE.createTableRow();
                newRowGroup.getRows().add((Object)newRow);
                List columns = TableExtensions.getColumns((Table)table);
                columns.forEach(column -> CustomTableDiffService.addEmptyValue(newRow, column));
                ++i;
            }
            table.getTablecontent().getRowgroups().add((Object)newRowGroup);
        }
    }

    private static void copyFootnotes(TableRow source, TableRow destination) {
        EList destinationFootnotes = destination.getFootnotes();
        source.getFootnotes().stream().forEach(arg_0 -> CustomTableDiffService.lambda$1((List)destinationFootnotes, arg_0));
    }

    private static void createDiffContent(int i, TableRow row, TableRow match) {
        TableCell oldCell = (TableCell)row.getCells().get(i);
        Set oldValue = TableCellExtensions.getIterableStringValue((TableCell)oldCell);
        LinkedHashSet newValue = new LinkedHashSet();
        if (match != null) {
            newValue.addAll(TableCellExtensions.getIterableStringValue((TableCell)((TableCell)match.getCells().get(i))));
        }
        if (!oldValue.equals(newValue)) {
            CompareCellContent compareContent = TablemodelFactory.eINSTANCE.createCompareCellContent();
            compareContent.getOldValue().addAll((Collection)oldValue);
            compareContent.getNewValue().addAll(newValue);
            compareContent.setSeparator(oldCell.getContent().getSeparator());
            oldCell.setContent((CellContent)compareContent);
        }
    }

    private static Table expandNewRowGroups(Table oldTable, Table newTable) {
        Table result = (Table)EcoreUtil.copy((EObject)oldTable);
        EList newRowGroups = newTable.getTablecontent().getRowgroups();
        newRowGroups.forEach(group -> CustomTableDiffService.addMissingRowGroup(group, result));
        return result;
    }

    private static void matchRow(TableRow row, Table newTable) {
        TableRow match = TableExtensions.getMatchingRow((Table)newTable, (TableRow)row);
        int i = 0;
        while (i < row.getCells().size()) {
            CustomTableDiffService.createDiffContent(i, row, match);
            ++i;
        }
        row.getFootnotes().clear();
        if (match != null) {
            CustomTableDiffService.copyFootnotes(match, row);
        }
    }

    private static Table matchRows(Table expanded, Table newTable) {
        Table result = (Table)EcoreUtil.copy((EObject)expanded);
        List rows = TableExtensions.getTableRows((Table)result);
        rows.forEach(row -> CustomTableDiffService.matchRow(row, newTable));
        return result;
    }

    public Table createDiffTable(Table oldTable, Table newTable) {
        Table expanded = CustomTableDiffService.expandNewRowGroups(oldTable, newTable);
        return CustomTableDiffService.matchRows(expanded, newTable);
    }

    private static /* synthetic */ void lambda$1(List list, Footnote f) {
        boolean bl = list.add((Footnote)EcoreUtil.copy((EObject)f));
    }
}

