/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.nattable.utils;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterIconPainter;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowPainter;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.group.painter.ColumnGroupHeaderTextPainter;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.AggregateConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.theme.ModernNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.extensions.CellContentExtensions;
import org.eclipse.set.model.tablemodel.extensions.ColumnDescriptorExtensions;
import org.eclipse.set.nattable.utils.CustomizableExportCommandHandler;
import org.eclipse.set.nattable.utils.PlanProRichTextCellPainter;
import org.eclipse.set.nattable.utils.PlanProTableCellPainter;
import org.eclipse.set.utils.Colors;
import org.eclipse.set.utils.SetImages;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public class PlanProTableThemeConfiguration
extends ModernNatTableThemeConfiguration {
    private static final String ALIGN_LEFT = "align_left";
    private static final String EXCEPTION_LABEL = "exception";
    private static final String GREYED_LABEL = "greyedout";
    private static final float SCALE_CM_TO_PIXEL = ToolboxConfiguration.getTablesScaleFactor();
    private final Style alignLeftStyle;
    private final AggregateConfigLabelAccumulator bodyLayerAccumulator = new AggregateConfigLabelAccumulator();
    private final DataLayer dataLayer;
    private final AggregateConfigLabelAccumulator dataLayerAccumulator = new AggregateConfigLabelAccumulator();
    private final Style fatHeaderStyle;
    private final IStyle greyedOutStyle;
    private final Color greyedOutStyleBackgroundColor;
    private final Color greyedOutStyleForegroundColor;
    private Font headerFont;
    private final AbstractLayer headerLayer;
    private final AggregateConfigLabelAccumulator headerLayerAccumulator = new AggregateConfigLabelAccumulator();
    private final ColumnDescriptor heading;
    private final LocalResourceManager resourceManager;
    final IDataProvider bodyDataProvider;
    final AbstractLayer bodyLayer;

    public static int toPixel(float length) {
        return Math.round(length * SCALE_CM_TO_PIXEL);
    }

    private static Image createImage(LocalResourceManager localResourceManager, ImageDescriptor imageDescriptor) {
        if (imageDescriptor != null) {
            return localResourceManager.createImage(imageDescriptor);
        }
        return null;
    }

    private static void registerHandler(ILayer layer) {
        layer.registerCommandHandler((ILayerCommandHandler)new CustomizableExportCommandHandler(layer).setOpen(false));
    }

    public PlanProTableThemeConfiguration(NatTable natTable, AbstractLayer headerLayer, DataLayer dataLayer, GridLayer gridLayer, ColumnDescriptor heading, AbstractLayer bodyLayer, IDataProvider bodyDataProvider) {
        this.cGroupHeaderCellPainter = new BackgroundPainter((ICellPainter)new PaddingDecorator((ICellPainter)new TextPainter(true, true, false)));
        this.defaultHAlign = HorizontalAlignmentEnum.CENTER;
        FontData defaultFontData = GUIHelper.DEFAULT_FONT.getFontData()[0];
        defaultFontData.setStyle(1);
        this.headerFont = GUIHelper.getFont((FontData[])new FontData[]{defaultFontData});
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)natTable.getParent());
        Color defaultBackground = this.createColor(Colors.DEFAULT_GREYEDOUT_COLOR);
        this.greyedOutStyleBackgroundColor = this.createColor("toolbox.greyedoutstyle.background", defaultBackground);
        this.greyedOutStyleForegroundColor = this.createColor("toolbox.greyedoutstyle.foreground", GUIHelper.COLOR_DARK_GRAY);
        this.headerLayer = headerLayer;
        this.dataLayer = dataLayer;
        this.bodyLayer = bodyLayer;
        this.bodyDataProvider = bodyDataProvider;
        this.defaultVAlign = VerticalAlignmentEnum.TOP;
        this.heading = heading;
        this.greyedOutStyle = new Style();
        this.greyedOutStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)this.greyedOutStyleBackgroundColor);
        this.greyedOutStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)this.greyedOutStyleForegroundColor);
        this.alignLeftStyle = new Style();
        this.alignLeftStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.LEFT);
        this.fatHeaderStyle = new Style();
        this.fatHeaderStyle.setAttributeValue(CellStyleAttributes.FONT, (Object)this.headerFont);
        this.fatHeaderStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)this.greyedOutStyleBackgroundColor);
        this.fatHeaderStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, (Object)VerticalAlignmentEnum.MIDDLE);
        headerLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)this.headerLayerAccumulator);
        dataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)this.dataLayerAccumulator);
        bodyLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)this.bodyLayerAccumulator);
        this.addGreyedLabel();
        this.addLeftAlignmentLabel();
        this.addExceptionLabel();
        this.freezeSeparatorColor = GUIHelper.COLOR_BLACK;
        this.setDefaultColumnWidth();
        PlanProTableThemeConfiguration.registerHandler((ILayer)gridLayer);
    }

    public void createPainterInstances() {
        super.createPainterInstances();
        boolean wraptext = true;
        boolean calculateByTextLength = false;
        boolean calculateByTextHeight = true;
        Image leftWarningImage = PlanProTableThemeConfiguration.createImage(this.resourceManager, SetImages.WARNING_YELLOW);
        Image rightWarningImage = PlanProTableThemeConfiguration.createImage(this.resourceManager, SetImages.WARNING_RED);
        Image blackWarningImage = PlanProTableThemeConfiguration.createImage(this.resourceManager, SetImages.IC_WARNING_BLACK_18DP_1X);
        this.defaultCellPainter = new PlanProTableCellPainter((ICellPainter)new PlanProRichTextCellPainter(true, false, true), leftWarningImage, rightWarningImage, blackWarningImage);
        this.filterRowCellPainter = new PaddingDecorator((ICellPainter)new FilterRowPainter((ImagePainter)new FilterIconPainter(GUIHelper.getImage((String)"filter"))), 0, 0, 0, 5);
        this.cGroupHeaderCellPainter = new ColumnGroupHeaderTextPainter((ICellPainter)new TextPainter(true, false), CellEdgeEnum.RIGHT, null);
    }

    public void configureRegistry(IConfigRegistry configRegistry) {
        super.configureRegistry(configRegistry);
        this.registerGreyedStyle(configRegistry);
        this.registerExceptionStyle(configRegistry);
        this.registerAlignLeftStyle(configRegistry);
        this.registerHeaderStyle(configRegistry);
    }

    private void addExceptionLabel() {
        IConfigLabelAccumulator cellLabelAccumulator = (configLabels, columnPosition, rowPosition) -> {
            int rowIndex;
            int columnIndex = this.bodyLayer.getColumnIndexByPosition(columnPosition);
            String dataValue = this.bodyDataProvider.getDataValue(columnIndex, rowIndex = this.bodyLayer.getRowIndexByPosition(rowPosition)).toString();
            if (CellContentExtensions.isErrorText((String)dataValue)) {
                configLabels.addLabel(EXCEPTION_LABEL);
            }
        };
        this.bodyLayerAccumulator.add(cellLabelAccumulator);
    }

    private void addGreyedLabel() {
        int[] greyedColumns;
        ColumnOverrideLabelAccumulator headerGreyed = new ColumnOverrideLabelAccumulator((ILayer)this.headerLayer);
        ColumnOverrideLabelAccumulator dataGreyed = new ColumnOverrideLabelAccumulator((ILayer)this.dataLayer);
        this.headerLayerAccumulator.add((IConfigLabelAccumulator)headerGreyed);
        this.dataLayerAccumulator.add((IConfigLabelAccumulator)dataGreyed);
        int[] nArray = greyedColumns = ColumnDescriptorExtensions.getGreyedColumnIndices((ColumnDescriptor)this.heading);
        int n = greyedColumns.length;
        int n2 = 0;
        while (n2 < n) {
            int greyedColumn = nArray[n2];
            dataGreyed.registerColumnOverrides(greyedColumn, new String[]{GREYED_LABEL});
            ++n2;
        }
    }

    private void addLeftAlignmentLabel() {
        ColumnOverrideLabelAccumulator firstColumnLeft = new ColumnOverrideLabelAccumulator((ILayer)this.dataLayer);
        this.dataLayerAccumulator.add((IConfigLabelAccumulator)firstColumnLeft);
        firstColumnLeft.registerColumnOverrides(0, new String[]{ALIGN_LEFT});
    }

    private Color createColor(ColorDescriptor descriptor) {
        return this.resourceManager.createColor(descriptor);
    }

    private Color createColor(String colorKey, Color defaultColor) {
        ColorDescriptor descriptor = Colors.keyToDescriptor((String)colorKey, (Color)defaultColor);
        return this.createColor(descriptor);
    }

    private void registerAlignLeftStyle(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)this.alignLeftStyle, DisplayMode.NORMAL, ALIGN_LEFT);
    }

    private void registerExceptionStyle(IConfigRegistry configRegistry) {
        if (!ToolboxConfiguration.isDevelopmentMode()) {
            this.registerWarningPainter(configRegistry);
        }
    }

    private void registerGreyedStyle(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)this.greyedOutStyle, DisplayMode.NORMAL, GREYED_LABEL);
    }

    private void registerHeaderStyle(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)this.fatHeaderStyle, DisplayMode.NORMAL, "COLUMN_HEADER");
    }

    private void registerWarningPainter(IConfigRegistry configRegistry) {
        Style style = new Style();
        style.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.CENTER);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, DisplayMode.NORMAL, EXCEPTION_LABEL);
        Image bgImage = PlanProTableThemeConfiguration.createImage(this.resourceManager, SetImages.IC_WARNING_BLACK_18DP_1X);
        ImagePainter bgImagePainter = new ImagePainter(bgImage, true);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)bgImagePainter, DisplayMode.NORMAL, EXCEPTION_LABEL);
    }

    private void setDefaultColumnWidth() {
        int[] columns;
        int[] nArray = columns = ColumnDescriptorExtensions.getColumnIndices((ColumnDescriptor)this.heading);
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            int column = nArray[n2];
            Float width = ColumnDescriptorExtensions.getColumnWidth((ColumnDescriptor)this.heading, (int)column);
            if (width != null) {
                switch (ColumnDescriptorExtensions.getColumnWidthMode((ColumnDescriptor)this.heading, (int)column)) {
                    case WIDTH_CM: {
                        this.dataLayer.setColumnPercentageSizing(column, false);
                        this.dataLayer.setColumnWidthByPosition(column, PlanProTableThemeConfiguration.toPixel(width.floatValue()));
                        break;
                    }
                    case WIDTH_PERCENT: {
                        this.dataLayer.setColumnPercentageSizing(column, true);
                        this.dataLayer.setColumnWidthPercentageByPosition(column, (int)width.floatValue());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid width mode");
                    }
                }
            }
            ++n2;
        }
    }
}

