/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.nattable.utils;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.set.nattable.utils.BaseEdgeEnum;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class BasePainterDecorator
implements ICellPainter {
    private final InternalCellPainterDecorator internalCellPainterDecorator;

    private static CellEdgeEnum getCellEdge(BaseEdgeEnum position) {
        switch (position) {
            case AFTER: {
                return CellEdgeEnum.RIGHT;
            }
            case BEFORE: {
                return CellEdgeEnum.LEFT;
            }
        }
        return CellEdgeEnum.NONE;
    }

    public BasePainterDecorator(ICellPainter baseCellPainter, BaseEdgeEnum position, ICellPainter decoratorCellPainter) {
        this.internalCellPainterDecorator = new InternalCellPainterDecorator(baseCellPainter, BasePainterDecorator.getCellEdge(position), decoratorCellPainter);
    }

    public ICellPainter getCellPainterAt(int x, int y, ILayerCell cell, GC gc, Rectangle adjustedCellBounds, IConfigRegistry configRegistry) {
        return this.internalCellPainterDecorator.getCellPainterAt(x, y, cell, gc, adjustedCellBounds, configRegistry);
    }

    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return this.internalCellPainterDecorator.getPreferredHeight(cell, gc, configRegistry);
    }

    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return this.internalCellPainterDecorator.getPreferredWidth(cell, gc, configRegistry);
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        this.internalCellPainterDecorator.paintCell(cell, gc, bounds, configRegistry);
    }

    private static class InternalCellPainterDecorator
    extends CellPainterDecorator {
        public InternalCellPainterDecorator(ICellPainter baseCellPainter, CellEdgeEnum cellEdge, ICellPainter decoratorCellPainter) {
            super(baseCellPainter, cellEdge, decoratorCellPainter);
        }

        public Rectangle getBaseCellPainterBounds(ILayerCell cell, GC gc, Rectangle adjustedCellBounds, IConfigRegistry configRegistry) {
            ICellPainter decoratorCellPainter = this.getDecoratorCellPainter();
            int preferredDecoratorWidth = decoratorCellPainter != null ? decoratorCellPainter.getPreferredWidth(cell, gc, configRegistry) : 0;
            int grabbedPreferredWidth = adjustedCellBounds.width - preferredDecoratorWidth - this.getSpacing();
            switch (this.getCellEdge()) {
                case LEFT: {
                    return new Rectangle(adjustedCellBounds.x, adjustedCellBounds.y, grabbedPreferredWidth, adjustedCellBounds.height).intersection(adjustedCellBounds);
                }
            }
            return super.getBaseCellPainterBounds(cell, gc, adjustedCellBounds, configRegistry);
        }

        public Rectangle getDecoratorCellPainterBounds(ILayerCell cell, GC gc, Rectangle adjustedCellBounds, IConfigRegistry configRegistry) {
            ICellPainter decoratorCellPainter = this.getDecoratorCellPainter();
            ICellPainter baseCellPainter = this.getBaseCellPainter();
            int preferredDecoratorWidth = decoratorCellPainter != null ? decoratorCellPainter.getPreferredWidth(cell, gc, configRegistry) : 0;
            int preferredDecoratorHeight = decoratorCellPainter != null ? decoratorCellPainter.getPreferredHeight(cell, gc, configRegistry) : 0;
            int preferredBaseHeight = baseCellPainter != null ? baseCellPainter.getPreferredHeight(cell, gc, configRegistry) : 0;
            switch (this.getCellEdge()) {
                case LEFT: {
                    return new Rectangle(adjustedCellBounds.x, adjustedCellBounds.y, preferredDecoratorWidth, preferredDecoratorHeight).intersection(adjustedCellBounds);
                }
                case RIGHT: {
                    return new Rectangle(adjustedCellBounds.x, adjustedCellBounds.y + preferredBaseHeight - preferredDecoratorHeight, preferredDecoratorWidth, preferredDecoratorHeight).intersection(adjustedCellBounds);
                }
            }
            return super.getDecoratorCellPainterBounds(cell, gc, adjustedCellBounds, configRegistry);
        }
    }
}

