/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;
import org.eclipse.set.toolboxmodel.Ansteuerung_Element.Stellelement;
import org.eclipse.set.toolboxmodel.Basisobjekte.Basis_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Fahrweg;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_Rangier;
import org.eclipse.set.toolboxmodel.Geodaten.ENUMTOPAnschluss;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten;
import org.eclipse.set.toolboxmodel.Regelzeichnung.Regelzeichnung;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.ENUMWKrArt;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.GZ_Freimeldung_L_AttributeGroup;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.GZ_Freimeldung_R_AttributeGroup;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Anlage;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Komponente;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Weiche_Element_AttributeGroup;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Zungenpaar_AttributeGroup;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class WKrGspElementExtensions
extends BasisObjektExtensions {
    public static W_Kr_Anlage getWKrAnlage(W_Kr_Gsp_Element wKrGspElement) {
        return wKrGspElement.getIDWKrAnlage();
    }

    public static List<W_Kr_Gsp_Komponente> getWKrGspKomponenten(final W_Kr_Gsp_Element wKrGspElement) {
        if (wKrGspElement == null) {
            return Collections.emptyList();
        }
        Functions.Function1<W_Kr_Gsp_Komponente, Boolean> _function = new Functions.Function1<W_Kr_Gsp_Komponente, Boolean>(){

            public Boolean apply(W_Kr_Gsp_Komponente it) {
                Identitaet_TypeClass _identitaet = it.getIDWKrGspElement().getIdentitaet();
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                String _wert_1 = wKrGspElement.getIdentitaet().getWert();
                return Objects.equal((Object)_wert, (Object)_wert_1);
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)wKrGspElement).getWKrGspKomponente(), (Functions.Function1)_function));
    }

    public static Regelzeichnung getRegelzeichnung(W_Kr_Gsp_Element wKrGspElement) {
        return wKrGspElement.getIDRegelzeichnung();
    }

    public static Basis_Objekt getElement(GZ_Freimeldung_R_AttributeGroup group) {
        return group.getIDElement();
    }

    public static Basis_Objekt getElement(GZ_Freimeldung_L_AttributeGroup group) {
        return group.getIDElement();
    }

    public static TOP_Kante getTopKanteL(W_Kr_Gsp_Element wKrGspElement) {
        return WKrGspElementExtensions.getTopKanteWithAnschluss(wKrGspElement, ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_LINKS);
    }

    public static TOP_Kante getTopKanteR(W_Kr_Gsp_Element wKrGspElement) {
        return WKrGspElementExtensions.getTopKanteWithAnschluss(wKrGspElement, ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_RECHTS);
    }

    public static TOP_Knoten getTopKnoten(W_Kr_Gsp_Element wKrGspElement) {
        ENUMWKrArt _wert = WKrGspElementExtensions.getWKrAnlage(wKrGspElement).getWKrAnlageAllg().getWKrArt().getWert();
        if (_wert != null) {
            switch (_wert) {
                case ENUMW_KR_ART_ABW: 
                case ENUMW_KR_ART_DKW: 
                case ENUMW_KR_ART_DW: 
                case ENUMW_KR_ART_EKW: 
                case ENUMW_KR_ART_EW: 
                case ENUMW_KR_ART_IBW: 
                case ENUMW_KR_ART_KLOTHOIDENWEICHE: 
                case ENUMW_KR_ART_KORBBOGENWEICHE: {
                    boolean _tripleEquals;
                    Weiche_Element_AttributeGroup _weicheElement = null;
                    if (wKrGspElement != null) {
                        _weicheElement = wKrGspElement.getWeicheElement();
                    }
                    boolean bl = _tripleEquals = _weicheElement == null;
                    if (_tripleEquals) {
                        return null;
                    }
                    Functions.Function1<W_Kr_Gsp_Komponente, Boolean> _function = new Functions.Function1<W_Kr_Gsp_Komponente, Boolean>(){

                        public Boolean apply(W_Kr_Gsp_Komponente it) {
                            Zungenpaar_AttributeGroup _zungenpaar = it.getZungenpaar();
                            return _zungenpaar != null;
                        }
                    };
                    Iterable zungenpaare = IterableExtensions.filter(WKrGspElementExtensions.getWKrGspKomponenten(wKrGspElement), (Functions.Function1)_function);
                    boolean _isEmpty = IterableExtensions.isEmpty((Iterable)zungenpaare);
                    boolean _not = !_isEmpty;
                    Assert.isTrue((boolean)_not);
                    W_Kr_Gsp_Komponente zungenpaar = ((W_Kr_Gsp_Komponente[])Conversions.unwrapArray((Object)zungenpaare, W_Kr_Gsp_Komponente.class))[0];
                    return PunktObjektExtensions.getTopKnoten((Punkt_Objekt)zungenpaar);
                }
                case ENUMW_KR_ART_FLACHKREUZUNG: 
                case ENUMW_KR_ART_KR: 
                case ENUMW_KR_ART_SONSTIGE: {
                    return PunktObjektExtensions.getTopKnoten((Punkt_Objekt)WKrGspElementExtensions.getWKrGspKomponenten(wKrGspElement).get(0));
                }
            }
        }
        return null;
    }

    public static Stellelement getStellelement(W_Kr_Gsp_Element wKrGspElement) {
        return wKrGspElement.getIDStellelement();
    }

    private static TOP_Kante getTopKanteWithAnschluss(W_Kr_Gsp_Element wKrGspElement, final ENUMTOPAnschluss anschluss) {
        boolean _tripleNotEquals;
        final TOP_Knoten weichenKnoten = WKrGspElementExtensions.getTopKnoten(wKrGspElement);
        if (weichenKnoten == null) {
            return null;
        }
        Functions.Function1<TOP_Kante, Boolean> _function = new Functions.Function1<TOP_Kante, Boolean>(){

            public Boolean apply(TOP_Kante it) {
                ENUMTOPAnschluss _tOPAnschluss = TopKanteExtensions.getTOPAnschluss(it, weichenKnoten);
                return Objects.equal((Object)_tOPAnschluss, (Object)anschluss);
            }
        };
        Iterable results = IterableExtensions.filter(TopKnotenExtensions.getTopKanten(weichenKnoten), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)results);
        boolean bl = _tripleNotEquals = _size != 1;
        if (_tripleNotEquals) {
            return null;
        }
        return ((TOP_Kante[])Conversions.unwrapArray((Object)results, TOP_Kante.class))[0];
    }

    public static Set<Fstr_Zug_Rangier> getFstrZugCrossingLeg(final W_Kr_Gsp_Element element, final TOP_Kante legTopKante) {
        Functions.Function1<Fstr_Zug_Rangier, Boolean> _function = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

            public Boolean apply(Fstr_Zug_Rangier it) {
                boolean _xblockexpression = false;
                final Fstr_Fahrweg fstrFW = it.getIDFstrFahrweg();
                _xblockexpression = it.getFstrZug() != null && ListExtensions.map((List)it.getIDFstrFahrweg().getBereichObjektTeilbereich(), (Functions.Function1)new Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, TOP_Kante>(){

                    public TOP_Kante apply(Bereich_Objekt_Teilbereich_AttributeGroup it_1) {
                        return BereichObjektExtensions.getTopKante(it_1);
                    }
                }).contains(legTopKante) && IterableExtensions.exists(WKrGspElementExtensions.getWKrGspKomponenten(element), (Functions.Function1)new Functions.Function1<W_Kr_Gsp_Komponente, Boolean>(){

                    public Boolean apply(W_Kr_Gsp_Komponente it_1) {
                        return BereichObjektExtensions.intersects((Bereich_Objekt)fstrFW, (Punkt_Objekt)it_1);
                    }
                });
                return _xblockexpression;
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)element).getFstrZugRangier(), (Functions.Function1)_function)));
    }
}

