/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.basisattribute;

import java.util.Optional;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.set.utils.emfforms.Renderers;
import org.eclipse.set.utils.emfforms.TypedSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasisAttributeSetting<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasisAttributeSetting.class);
    private final EStructuralFeature basisAttributeFeature;
    private final EClassifier domainType;
    private final EditingDomain editingDomain;
    private final EObject parent;
    private final VControl vElement;
    private final ViewModelContext viewModelContext;
    private final EStructuralFeature wertFeature;
    private final Class<T> wertFieldType;

    public static EStructuralFeature getWertFeature(EObject basisAttribute) {
        return basisAttribute.eClass().getEStructuralFeature("wert");
    }

    public static boolean hasWertFeature(EClassifier type) {
        return BasisAttributeSetting.getWertFeatureFromClassifier(type).isPresent();
    }

    public static <S> boolean isWertFeatureTypeAssignableTo(EClassifier classifier, Class<S> wantedType) {
        return BasisAttributeSetting.getWertFeatureFromClassifier(classifier).map(f -> wantedType.isAssignableFrom(f.getEType().getInstanceClass())).orElse(Boolean.FALSE);
    }

    private static Optional<EStructuralFeature> getWertFeatureFromClassifier(EClassifier type) {
        if (!(type instanceof EClass)) {
            return Optional.empty();
        }
        return Optional.ofNullable(((EClass)type).getEStructuralFeature("wert"));
    }

    public BasisAttributeSetting(Class<T> type, VControl vElement, ViewModelContext viewModelContext) {
        this.wertFieldType = type;
        this.vElement = vElement;
        this.viewModelContext = viewModelContext;
        this.domainType = (EClassifier)Renderers.getFeaturePathDomainType((VElement)vElement, (boolean)true).get();
        this.parent = this.getTypedSetting().getEObject();
        this.basisAttributeFeature = this.getTypedSetting().getEStructuralFeature();
        this.wertFeature = ((EClass)this.basisAttributeFeature.getEType()).getEStructuralFeature("wert");
        this.editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.parent);
    }

    public EStructuralFeature getBasisAttributeFeature() {
        return this.basisAttributeFeature;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public EObject getParent() {
        return this.parent;
    }

    public EStructuralFeature getWertFeature() {
        return this.wertFeature;
    }

    public Optional<T> getWertValue() {
        return this.getTypedSetting().getValue().map(EObject.class::cast).map(o -> o.eGet(this.wertFeature)).map(this.wertFieldType::cast);
    }

    public boolean hasContents() {
        return this.getTypedSetting().getValue().map(EObject.class::cast).map(e -> !e.eContents().isEmpty()).orElse(Boolean.FALSE);
    }

    public boolean isOptional() {
        return this.basisAttributeFeature.getLowerBound() == 0;
    }

    public void removeBasisAttribute() {
        if (this.parent.eGet(this.basisAttributeFeature) != null) {
            Command command = SetCommand.create((EditingDomain)this.editingDomain, (Object)this.parent, (Object)this.basisAttributeFeature, null);
            this.editingDomain.getCommandStack().execute(command);
        }
    }

    public void removeWert() {
        EObject basisAttribute = this.getBasisAttribute();
        if (basisAttribute != null && basisAttribute.eGet(this.wertFeature) != null) {
            Command command = SetCommand.create((EditingDomain)this.editingDomain, (Object)basisAttribute, (Object)this.wertFeature, null);
            this.editingDomain.getCommandStack().execute(command);
        }
    }

    public boolean updateValue(T value) {
        if (this.getTypedSetting().getValue().isPresent()) {
            this.updateWithValue(value);
            return false;
        }
        this.createWithValue(value);
        return true;
    }

    private void createWithValue(T value) {
        EClass type = (EClass)this.basisAttributeFeature.getEType();
        EObject newBasisAttributeElement = type.getEPackage().getEFactoryInstance().create(type);
        newBasisAttributeElement.eSet(this.wertFeature, value);
        Command command = SetCommand.create((EditingDomain)this.editingDomain, (Object)this.parent, (Object)this.basisAttributeFeature, (Object)newBasisAttributeElement);
        this.editingDomain.getCommandStack().execute(command);
        Assert.isTrue((boolean)this.getTypedSetting().getValue().isPresent());
    }

    private EObject getBasisAttribute() {
        return this.getTypedSetting().getEObject();
    }

    private TypedSetting<?> getTypedSetting() {
        return Renderers.getTypedSetting((Class)this.domainType.getInstanceClass(), (VElement)this.vElement, (ViewModelContext)this.viewModelContext);
    }

    private boolean isUpdateNeeded(T oldValue, T newValue) {
        if (oldValue == null) {
            return newValue != null;
        }
        return !oldValue.equals(newValue);
    }

    private void updateWithValue(T value) {
        Optional<Object> wertValue = this.getWertValue();
        if (this.isUpdateNeeded(wertValue.orElse(null), value)) {
            LOGGER.debug("oldValue={}", wertValue);
            Command command = SetCommand.create((EditingDomain)this.editingDomain, this.getTypedSetting().getValue().get(), (Object)this.wertFeature, value);
            this.editingDomain.getCommandStack().execute(command);
        }
    }
}

