/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.xml;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LineNumberXMLReader {
    public static final String LINE_NUMBER_KEY = "lineNumber";

    public static Document read(Path location) throws IOException, SAXException, ParserConfigurationException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream inputStream = Files.newInputStream(location, new OpenOption[0]);){
            return LineNumberXMLReader.read(inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Document read(InputStream input) throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        SAXParser parser = factory.newSAXParser();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        final Document doc = docBuilder.newDocument();
        final ArrayDeque elementStack = new ArrayDeque();
        final StringBuilder nodeText = new StringBuilder();
        DefaultHandler handler = new DefaultHandler(){
            private Locator locator;

            private void addTextIfNeeded() {
                if (nodeText.length() > 0) {
                    Element el = (Element)elementStack.peek();
                    Text textNode = doc.createTextNode(nodeText.toString());
                    el.appendChild(textNode);
                    nodeText.delete(0, nodeText.length());
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                nodeText.append(ch, start, length);
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                this.addTextIfNeeded();
                Element closedElement = (Element)elementStack.pop();
                if (elementStack.isEmpty()) {
                    doc.appendChild(closedElement);
                } else {
                    Element parentElement = (Element)elementStack.peek();
                    parentElement.appendChild(closedElement);
                }
            }

            @Override
            public void setDocumentLocator(Locator locator) {
                this.locator = locator;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                this.addTextIfNeeded();
                Element element = doc.createElement(qName);
                int i = 0;
                while (i < attributes.getLength()) {
                    element.setAttribute(attributes.getQName(i), attributes.getValue(i));
                    ++i;
                }
                element.setUserData(LineNumberXMLReader.LINE_NUMBER_KEY, String.valueOf(this.locator.getLineNumber()), null);
                elementStack.push(element);
            }
        };
        parser.parse(input, handler);
        return doc;
    }

    public static int getNodeLastLineNumber(Node node) {
        if (node == null) {
            return -1;
        }
        Node nextNode = node.getNextSibling();
        if (nextNode == null) {
            return -1;
        }
        if (nextNode.getNodeType() == 1) {
            return LineNumberXMLReader.getLineNumber(nextNode) - 1;
        }
        return LineNumberXMLReader.getNodeLastLineNumber(nextNode);
    }

    public static int getLineNumber(Node node) {
        String lineNum = (String)node.getUserData(LINE_NUMBER_KEY);
        if (lineNum != null) {
            return Integer.parseInt(lineNum);
        }
        return -1;
    }
}

